<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <ul id="tabStations" class="nav nav-tabs bordered">
                <li class="active">
                    <a href="#library" role="tab" data-toggle="tab">{{ str_replace("_", " ", env(AIRLINE)) }}</a>
                </li>
                @if (ghaModule())
                    <li>
                        <a href="#airlines" role="tab" data-toggle="tab">@lang("content.airlines")</a>
                    </li>
                @else
                    @foreach($departments as $department)
                        <li>
                            <a href="#dept{{ $department->id }}" role="tab" data-toggle="tab">{{ $department->name }}</a>
                        </li>
                    @endforeach
                @endif
            </ul>

            @php $active = 0 @endphp
            <div id="tabContent" class="tab-content padding-10 background-white">

                <div class="tab-pane active" id="library">
                    @include("library.layouts.index-library-tab")
                </div>

                @if (ghaModule())
                    <div class="tab-pane" id="airlines">
                        @include("library.layouts.index-airlines-tab")
                    </div>
                @else
                    @foreach($departments as $department)
                        <div class="tab-pane" id="dept{{ $department->id }}">
                            @include("library.layouts.index-department-tab", ["department" => $department] )
                        </div>
                    @endforeach
                @endif

            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter(".table");
    }

    pagefunction();

</script>