<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-sm-12 col-lg-12">

            <div class="jarviswidget" id="wid-id-1" data-widget-colorbutton="false" data-widget-editbutton="false" data-widget-custombutton="false">
                <!-- widget options:
                usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                data-widget-colorbutton="false"
                data-widget-editbutton="false"
                data-widget-togglebutton="false"
                data-widget-deletebutton="false"
                data-widget-fullscreenbutton="false"
                data-widget-custombutton="false"
                data-widget-collapsed="true"
                data-widget-sortable="false"

                -->
                <header>
                    <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                    <h2><strong>@lang("content.edit")</strong></h2>

                </header>

                <!-- widget div-->
                <div>

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->

                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body">

                        {!! Form::open([ 'method' => 'POST', 'class' => 'form-horizontal-form', 'url' => url("library/{$library->id}") ]) !!}

                            @if ($library->department_id)
                                <div class="form-group col-sm-12">
                                    <label class="col-md-3">@lang("content.department")</label>
                                    <div class="col-md-6">
                                        <p>{{ $library->department->name }}</p>
                                        {!! Form::hidden('department_id', $library->department_id, ['class'=>'form-control']) !!}
                                    </div>
                                </div>
                            @endif

                            <div class="form-group col-sm-12">
                                <label class="col-md-3">@lang("content.name")</label>
                                <div class="col-md-6">
                                    {!! Form::text('name', $library->name, ['class'=>'form-control']) !!}
                                </div>
                            </div>

                            <div class="form-group col-sm-12">
                                <label class="col-md-3">@lang("content.abbr")</label>
                                <div class="col-md-6">
                                    {!! Form::text('abbr', $library->abbr, ['class'=>'form-control']) !!}
                                </div>
                            </div>

                            <div class="form-group col-sm-12">
                                <label class="col-md-3">@lang("content.category")</label>
                                <div class="col-md-6">
                                    {!! Form::select('category', $categories, $library->category, ['class' => 'form-control input-sm']) !!}
                                </div>
                            </div>

                            <div class="form-group col-sm-12">
                                <label class="col-md-3">@lang("content.new_category")</label>
                                <div class="col-md-6">
                                    {!! Form::text('new_category', null, ['class' => 'form-control']) !!}
                                </div>
                            </div>

                            <div class="form-group col-sm-12">
                                <label class="col-md-3">@lang("content.type")</label>
                                <div class="col-md-6">
                                    {!! Form::text('type', $library->type, ['class'=>'form-control']) !!}
                                </div>
                            </div>

                            <div class="form-group col-sm-12">
                                <label class="col-md-3">@lang("content.issue_date")</label>
                                <div class="col-md-6">
                                    {!! Form::text('issue_date', $library->issue_date, ['class'=>'form-control dateFrom']) !!}
                                </div>
                            </div>

                            <div class="form-group col-sm-12">
                                <label class="col-md-3">@lang("content.effective_date")</label>
                                <div class="col-md-6">
                                    {!! Form::text('effective_date', $library->effective_date, ['class'=>'form-control dateFrom']) !!}
                                </div>
                            </div>

                            <div class="form-group col-sm-12">
                                <label class="col-md-3">@lang("content.edition_no")</label>
                                <div class="col-md-6">
                                    {!! Form::text('edition_no', $library->edition_no, ['class'=>'form-control']) !!}
                                </div>
                            </div>

                            @if ($library->attachment_file)
                                @include("library.layouts.read-and-sign-layout")
                            @else
                                <div class="clearfix"></div>
                                <div class="form-group col-sm-12">
                                    <label class="col-md-3 color-green">@lang("content.read_and_sign")</label>
                                    <div class="col-md-6">
                                        <div class="alert alert-danger">
                                            <h6>Read & Sign option is not available.</h6>
                                            <h6>Please attach a document to enable it</h6>
                                        </div>
                                    </div>
                                </div>
                            @endif

                            <div class="form-group col-sm-12">
                                <label class="col-md-3">@lang("content.details")</label>
                                <div class="col-md-6">
                                    {!! Form::textarea('details', $library->details, ['class'=>'form-control']) !!}
                                </div>
                            </div>

                            <div class="form-group col-md-6 margin-left-10">
                                {!! Form::submit(trans("content.save_changes"), ['class' => 'btn btn-success btn-sm']) !!}
                            </div>

                        {!! Form::close() !!}

                    </div>

                </div>

            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();
    }

    loadScript("{{  asset("/assets/js/views/library/edit.js?10") }}", pagefunction);

</script>