<?php require_once(public_path("smart/inc/init.php")); ?>

<style>
    .table>tbody>tr.unread>td{
        background-color: #fff5e1 !important;
    }
    .table>tbody>tr.unsigned>td{
        background-color: #ffeaea !important;
    }
</style>

        <!-- widget grid -->
<section id="widget-grid" class="bg-white">

            <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <div class="col-md-12 margin-bottom-10">

                @php $column = $type == AIRLINE_LIBRARY ? "airline-library" : "library" @endphp

                @if ($library->airline)
                    @php $picture = $library->airline->picture ? asset("storage/airlines/img/{$library->airline->picture}") : asset("/assets/img/default-airline-picture.png") @endphp
                    <img src="{{ $picture }}" style="max-height: 80px; padding: 10px;" />
                @endif

                <div class="margin-bottom-10">
                    <h4 class="margin-bottom-10">{{ $library->name }} views</h4>
                    <h5>Created on {{ baseDateFormat($library->created_at, true) }}</h5>

                    @if ($library->attachment_file)
                        <div class="btn-group">
                            <a target="_blank" href="{{ url("{$column}/file/{$library->id}") }}?view=1" class="btn btn-warning">@lang("content.view")</a>
                            <a href="{{ url("{$column}/file/{$library->id}") }}?download=1" class="btn btn-primary">@lang("content.download")</a>
                        </div>
                    @else
                        <p class="color-red font-md">Attachment document has not been uploaded yet.</p>
                    @endif
                </div>

                <ul id="tab" class="nav nav-tabs bordered">
                    <li class="active">
                        <a href="#filters" role="tab" data-toggle="tab">@lang("content.filters")</a>
                    </li>
                    <li>
                        <a href="#staff" role="tab" data-toggle="tab">@lang("content.staff")</a>
                    <li>
                    </li>
                </ul>

                <div id="tabContent" class="tab-content padding-10 background-white">
                    <div class="tab-pane active" id="filters">
                        @include("library-view.layouts.views-filters-table-list")
                    </div>

                    <div class="tab-pane" id="staff">
                        @include("library-view.layouts.views-table-list")
                    </div>
                </div>

            </div>

        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter(".table");
    };

    pagefunction();
    {{--loadScript("{{ asset("/assets/js/views/aircraft/edit.js") }}", pagefunction);--}}

</script>
