@php $label = isset($label) ? $label : '' @endphp
@php $name  = isset($name)  ? $name : 'unknown' @endphp
@php $selections = isset($selections) ? $selections : [] @endphp
@php $selected = isset($selected) ? $selected : null @endphp
@php $class = isset($class) ? $class : '' @endphp

@php $emptySelection = isset($emptySelection) ? ['' => 'Select'] : null @endphp

@if ($emptySelection && count($selections))
    @php $selections = $emptySelection + $selections @endphp
@endif

@php $options = [] @endphp
@php $options['class'] = "form-control $class" @endphp

@if (isset($id))
    @php $options['id'] = $id @endphp
@endif

@if (isset($required))
    @php $options['required'] = 'required' @endphp
@endif

<div class="form-group has-feedback col-md-12">
    <label class="control-label col-sm-3 list">{{ $label }}</label>

    <div class="col-sm-9">
        {!! Form::select($name, $selections, $selected, $options) !!}

        @if (isset($icon))
            <span class="glyphicon glyphicon-{{ $icon }} form-control-feedback"></span>
        @endif
    </div>
</div>
