@php $type = isset($type) ? $type : 'text' @endphp
@php $label = isset($label) ? $label : '' @endphp
@php $name  = isset($name)  ? $name : 'unknown' @endphp
@php $value = isset($value) ? $value : null @endphp
@php $class = isset($class) ? $class : '' @endphp
@php $icon = isset($icon) ? $icon : 'ok' @endphp

@php $options = [] @endphp
@php $options['class'] = "form-control $class" @endphp

@php $options['placeholder'] = isset($placeholder) ? $placeholder : $label @endphp

@if (isset($id))
    @php $options['id'] = $id @endphp
@endif

@if (isset($required))
    @php $options['required'] = 'required' @endphp
@endif

<div class="form-group has-feedback col-md-12">
    <label class="control-label col-sm-3 list">{{ $label }}</label>

    <div class="col-sm-9">
        @if($type == 'email')
            {!! Form::email($name, $value, $options) !!}
        @elseif($type == 'password')
            {!! Form::password($name, $options) !!}
        @else
            {!! Form::text($name, $value, $options) !!}
        @endif
        <span class="glyphicon glyphicon-{{ $icon }} form-control-feedback"></span>
    </div>

</div>
