@foreach($attributes as $each)

    @php $type =  isset($each['type']) ? $each['type'] :  'text' @endphp
    @php $label = isset($each['label']) ? $each['label'] :  '' @endphp
    @php $name  = isset($each['name']) ? $each['name'] :  'unknown' @endphp
    @php $value = isset($each['value']) ? $each['value'] :  null @endphp
    @php $class = isset($each['class']) ? $each['class'] :  '' @endphp
    @php $icon =  isset($each['icon']) ? $each['icon'] :  'ok' @endphp

    {{--For Type Selects Only--}}
    @php $selections = isset($each['selections']) ? $each['selections'] :  [] @endphp
    @php $selected = isset($each['selected']) ? $each['selected'] :  null @endphp
    @php $emptySelection = isset($each['emptySelection']) ? ['' => 'Select'] :  null @endphp
    @if ($emptySelection && count($selections))
        @php $selections = $emptySelection + $selections @endphp
    @endif

    @php $options = [] @endphp

    @php $options['class'] = "form-control $class" @endphp

    @php $options['placeholder'] = isset($each['placeholder']) ? $each['placeholder'] :  $label @endphp

    @if (isset($each['id']))
        @php $options['id'] = $id @endphp
    @endif

    @if (isset($each['required']))
        @php $options['required'] = 'required' @endphp
    @endif

    <div class="form-group has-feedback col-md-12">
        <label class="control-label col-sm-3 list">{{ $label }}</label>

        <div class="col-sm-9">
            @if($type == 'select')
                {!! Form::select($name, $selections, $selected, $options) !!}
            @elseif($type == 'email')
                {!! Form::email($name, $value, $options) !!}
            @elseif($type == 'password')
                {!! Form::password($name, $options) !!}
            @else
                {!! Form::text($name, $value, $options) !!}
            @endif
            @if ($icon)
                <span class="glyphicon glyphicon-{{ $icon }} form-control-feedback"></span>
            @endif
        </div>

    </div>
@endforeach