<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        {{--<meta name="viewport" content="width=device-width, initial-scale=1.0">--}}
        @if (env('AIRLINE') == EMIRATES)
            @php $IATA_CODE = "ZZ" @endphp
            <link rel="shortcut icon" href="{{ asset("/assets/img/icons/website.ico") }}" />
            <title>Aviation BIS</title>
            <link href="{{ asset("/assets-emirates/css/main.css") }}" rel="stylesheet /">
            <link href="{{ asset('/assets-emirates/css/app.css') }}" rel="stylesheet"/>
        @else
            @php $IATA_CODE = "SZ" @endphp
            <link rel="shortcut icon" href="{{ asset("/assets/img/icons/somonair.ico") }}" />
            <title>Aviation-BIS</title>
            <link href="{{ asset("/assets/css/main.css") }}?" rel="stylesheet /">
            <link href="{{ asset('assets/css/app.css') }}" rel="stylesheet" />
        @endif
        <!-- Fonts -->
        <link href="{{ asset("/css/fonts.css") }}" rel="stylesheet" type='text/css' />

        <link href="{{ asset("/assets/css/jquery.multiselect.css") }}" rel="stylesheet" />
        <link href="{{ asset("/assets/css/jquery.multiselect.filter.css") }}" rel="stylesheet" />
        <link href="{{ asset("/assets/css/prettify.css") }}" rel="stylesheet" />
        <link href="{{ asset("/assets/css/jquery-ui.min.css") }}" rel="stylesheet" />
        <link href="{{ asset("/assets/css/editable.css") }}" rel="stylesheet" />
        <link href="{{ asset("/assets/css/messenger.css") }}" rel="stylesheet" />
        <link href="{{ asset("/assets/css/jquery.tablesorter.pager.css") }}" rel="stylesheet" />

        <link href="{{ asset("/assets/css/jquery.comiseo.daterangepicker.css") }}" rel="stylesheet" />

        <link rel="stylesheet" type="text/css" href="{{ asset("/assets/css/c3.css") }}">

        @yield("css")

        <script>
            var baseUrl = "{{ url('/') }}";
            var CURRENT_IATA_CODE = "{{ $CURRENT_IATA_CODE }}";

            var $location1, $location2, $assets;
            if (CURRENT_IATA_CODE == "SZ"){
                $location1 = "DYU";
                $location2 = "LBD";
                $assets = "assets";
            }
            else {
                $location1 = "FRU";
                $location2 = "OSS";
                $assets = "assets";
            }

            var TAJIKAIR = "Tajik Air",
                OTHERAIRLINES = "Other Airlines";

            var FLIGHT_OPERATIONS_DIRECTOR_POSITION = "Captain",
                CAPTAIN_POSITION = "Captain",
                FIRST_OFFICER_POSITION = "First Officer",
                CHIEF_PILOT_POSITION = "Chief Pilot",
                PILOT_INSTRUCTOR_POSITION = "Pilot-instructor",
                COPILOT_JUNIOR_POSITION = "Co-Pilot Junior";

            var FLIGHT_ATTENDANT_POSITION = "Flight Attendant",
                FLIGHT_ATTENDANT_N2_POSITION = "Flight Attendant #2",
                FLIGHT_ATTENDANT_JUNIOR_POSITION = "Flight Attendant Junior",
                PURSER_POSITION = "Purser",
                INSTRUCTOR_FLIGHT_ATTENDANT_POSITION = "Instructor-Flight Attendant",
                SENIOR_INSTRUCTOR_FLIGHT_ATTENDANT_POSITION = "Senior Instructor-Flight Attendant";

            var authUserId = "", authUserName = "", authUserStatus = "";
            @if (isset($auth) && is_object($auth) && $auth->user())
                authUserId = "{{ $auth->user()->id }}";
                authUserName = "{{ $auth->user()->first_name." ".$auth->user()->last_name}}";
                authUserStatus = "{{ $auth->user()->chatStatus ? $auth->user()->chatStatus->status : STATUS_ONLINE }}";
            @endif
        </script>
    </head>

    @if (isset($auth) && is_object($auth) && $auth->user())
        <body style="margin: 0 !important;" onload="chat.updateChat()">
    @else
        <body style="margin: 0 !important;">
    @endif

        @include("header")

        @include('template/modal-loading', [ 'text' => 'Please Wait...'])

        @include('layouts/alert-message')

        @include('vendor/flash/message')

        <div id="content" class="content">
            @yield("content")
        </div>

        @include("footer")

    </body>
</html>