<?php
/**
 * Created by PhpStorm.

 */
?>

@extends($ajaxCall)

@section("content")

    @include('general.tab-header', ['departmentName' => 'IATA', 'moduleName' => 'Terms'])

    <div class="tfheader"  style="width: 100%;">
        {!! Form::open([ 'method' => 'GET', 'class' => 'tfnewsearch form-inline', 'url' =>  url('iata/terms') ]) !!}
            <div class="form-group" style="width: 100%">
                <h4 class="form-group" style="margin: 0 5px 5px 0">Search</h4>
                <input name="iata_term" type="search" class="tftextinput" style=" min-width: 900px; width: 80%; margin-right: 0; height: 34px !important; border: 1px solid #a39fa3; font-size: 16px" onclick="this.select()" value="{{ \request("iata_term") }}" />
                <select name="search_source" class="form-control search_select">
                    <option value="term">Terms</option>
                    <option value="definition">Definition</option>
                    <option value="context">Context</option>
                    <option value="source">@lang("content.source")</option>
                    <option value="sub_info">@lang("content.info")</option>
                </select>
                <input type="submit" value="search" class="tfbutton" style=" width: 100px; height: 34px;">
            </div>
        {!! Form::close() !!}
        <div class="tfclear"></div>
    </div>

    <div class="search">

    @foreach($terms as $i => $each)
        @if ($i == 0)
            <div class="result">
                <div>
                    <h4>Found {{ count($total) }} {{ count($total) > 1 ? 'matches' : 'match'}}.
                    @if (count($total) > $perPage)
                        <span style="float: right">Page {{ $currentPage }} of {{ $totalPage }}</span>
                    @endif
                    </h4>
                </div>
            </div>
            <div class="body">
                {{--<div class="head">--}}
                <div class="title">
                    <div style="width: 10%" data-left>Term</div>
                    <div style="width: 60%" data-center>Definition</div>
                    <div style="width: 10%" data-left>Context</div>
                    <div style="width: 10%" data-left>@lang("content.source")</div>
                    <div style="width: 10%" data-left>@lang("content.info")</div>
                </div>
            {{--</div>--}}
        @endif

        <div>
            <div style="width: 10%; min-width: 10%" data-left class="emphasize2">{{ $each->term }}</div>
            <div style="width: 60%; min-width: 60%" data-left class="emphasize">{{ $each->definition }}</div>
            <div style="width: 10%; min-width: 10%" data-left>{{ $each->context }}</div>
            <div style="width: 10%; min-width: 10%" data-left>{{ $each->source }}</div>
            <div style="width: 10%; min-width: 10%" data-left>{{ $each->sub_info }}</div>
        </div>
    @endforeach
        </div>
    </div>

    {!! $pagination->appends($_GET)->render() !!}
@stop

