<?php require_once(public_path("smart/inc/init.php")); ?>

    <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => 'HR', 'moduleName' => 'Employees Requests'])

            @include("hrm.layouts.form")

            <div class="bg-white">

                <ul class="nav nav-pills">
                    <li class="active"><a href="#pending" role="tab" data-toggle="tab">@lang("content.pending")</a></li>
                    <li class=""><a href="#in_line" role="tab" data-toggle="tab">@lang("content.in_line")</a></li>
                    <li class=""><a href="#approved" role="tab" data-toggle="tab">@lang("content.approved")</a></li>
                    <li class=""><a href="#declined" role="tab" data-toggle="tab">@lang("content.declined")</a></li>
                    <li class=""><a href="#void" role="tab" data-toggle="tab">@lang("content.void")</a></li>
                    <li class=""><a href="#all" role="tab" data-toggle="tab">@lang("content.all")</a></li>
                </ul>

                {{--Tab Content--}}
                <div class="tab-content margin-top-10">
                    <div class="tab-pane bg-color-white active" id="pending">
                        @include("user.layouts.employees-requests-table", ["selectedStatus" => APPLICATION_STATUS_PENDING])
                    </div>

                    <div class="tab-pane bg-color-white" id="in_line">
                        @include("user.layouts.employees-requests-table", ["selectedStatus" => APPLICATION_STATUS_IN_LINE])
                    </div>

                    <div class="tab-pane bg-color-white" id="approved">
                        @include("user.layouts.employees-requests-table", ["selectedStatus" => APPLICATION_STATUS_APPROVED])
                    </div>

                    <div class="tab-pane bg-color-white" id="declined">
                        @include("user.layouts.employees-requests-table", ["selectedStatus" => APPLICATION_STATUS_DECLINED])
                    </div>

                    <div class="tab-pane bg-color-white" id="void">
                        @include("user.layouts.employees-requests-table", ["selectedStatus" => APPLICATION_STATUS_VOID])
                    </div>

                    <div class="tab-pane bg-color-white" id="all">
                        @include("user.layouts.employees-requests-table")
                    </div>
                </div>

                {{--                @foreach($employeesStatus as $j => $each)--}}
                {{--                    @include("user.layouts.request-content", ["each" => $each])--}}
                {{--                @endforeach--}}

                {{--                <ul class="nav nav-tabs">--}}
                {{--                    <li class="active">--}}
                {{--                        <a href="#requests" role="tab" data-toggle="tab">@lang("content.leave_requests")</a>--}}
                {{--                    </li>--}}
                {{--                </ul>--}}
                {{--                --}}{{--Tab Content--}}
                {{--                <div class="tab-content margin-top-10">--}}
                {{--                    <div class="tab-pane bg-color-white active" id="requests">--}}
                {{--                        @include("user.layouts.employees-requests-table", ["hideForm" => true])--}}
                {{--                    </div>--}}
                {{--                </div>--}}

            </div>
        </article>
    </div>

    <div id="details_content">
        @foreach($employeesStatus as $j => $each)
            @include("user.layouts.request-content", ["each" => $each])
        @endforeach
    </div>

    <div id="details_modal" class="modal fade" role="dialog">
        <div class="modal-dialog" style="width: 80%;">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title" id="modal_title">Details</h4>
                </div>
                <div class="modal-body">
                </div>
            </div>
        </div>
    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter(".table-apply");

        var details_modal = $("#details_modal"), details_content = $("#details_content");

        $(document).on('click', 'td.status', function () {
            var _this = $(this), objID = _this.parent().attr("data-request-id"),
                // parent = _this.parents(".tab-pane"),
                // all_details = parent.find("div.details"),
                find_details = details_content.find("div.details.request-"+ objID),
                title = find_details.data("title");
            // parent = _this.parent(),
            // find_details = parent.nextUntil("tr.request").filter('tr.details')
            ;

            var data = find_details.clone();
            details_modal.find("#modal_title").html(title);
            details_modal.find(".modal-body").html(data);
            data.show();
            details_modal.modal('toggle');

            // if (find_details.is(":visible")){
            //     find_details.hide();
            // }
            // else {
            //     find_details.show();
            // }
        });
    };

    pagefunction();

</script>
