@php $tableID = isset($id) ? $id : "table_".rand(100,999) @endphp
<div class="jarviswidget jarviswidget-color-blueDark" id="wid-staff-{{ $i }}" data-widget-editbutton="false">

    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>
        <h2>@lang("content.list")</h2>
    </header>

    <!-- widget div-->
    <div class="editable_div">

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="min-height: 50px !important;">

            <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover table-apply" id="{{ $tableID }}">
                    <thead>
                        <tr>
                            <th rowspan="2">#</th>
                            <th rowspan="2">@lang("content.picture")</th>
                            <th rowspan="2">@lang("content.first_name")</th>
                            <th rowspan="2">@lang("content.last_name")</th>
                            <th rowspan="2">@lang("content.station")</th>
                            <th rowspan="2" width="10%">@lang("content.department")</th>
                            <th rowspan="2" width="10%">@lang("content.position")</th>
                            @foreach($last3years as $year)
                                <th colspan="5">{{ $year }}</th>
                            @endforeach
                            <th rowspan="2">@lang("content.actions")</th>
                        </tr>
                        <tr>
                            @foreach($last3years as $year)
                                <th>Entitlement<br>(days)</th>
                                <th>@lang("content.leave_type")</th>
                                <th>Used<br>(days)</th>
                                <th>Pending<br>(days)</th>
                                <th>Balance<br>(days)</th>
                            @endforeach
                        </tr>
                    </thead>
                    <tbody>
                    @foreach($list as $j => $user)
                        @php $no = $j + 1 @endphp
                        @php $picture = !is_null($user->thumb) ? '/storage/users/'.$user->thumb : '/assets/img/default-user-picture.png'; @endphp
                        <tr>
                            <td>{{ $no }}</td>
                            <td><a target="_blank" href="{{ route("homepage")."#". url("staff/{$user->id}/edit") }}">
                                    <img src="{{ $picture }}" class="img-thumbnail thumb_report_prev"  />
                                </a>
                            </td>
                            <td data-left><a target="_blank" href="{{ route("homepage")."#". url("staff/{$user->id}/edit") }}">{{ $user->first_name }}</a></td>
                            <td data-left><a target="_blank" href="{{ route("homepage")."#". url("staff/{$user->id}/edit") }}">{{ $user->last_name }}</a></td>
                            <td data-left>{{ $user->ap }}</td>

                            <td data-left>{{ count($user->department) ? $user->department[0]->name : "" }}</td>
                            <td data-left>{{ count($user->position) ? $user->position[0]->name : "" }}</td>

                            @foreach($last3years as $year)
                                @php $search = $user->entitlements->where('year', intval($year)); @endphp
                                @php $search = $search->count() ? $search->first() : null @endphp
                                @php $pending = $days = $used = 0 @endphp
                                <td>
                                    <a href="#" data-field='year' data-field_value="{{ $year }}" data-model="UserEntitlement"
                                       data-foreign_key='user_id' data-type="text" data-id='{{ $user->id }}' data-placeholder="Required"
                                       data-value_key="entitlement" data-value='{{ $search ? $search->entitlement : null }}'
                                       class="editable {{ $search && $search->entitlement ? 'editable-click' : 'editable-empty'  }}">
                                        {{ $search && $search->entitlement ? $days = $search->entitlement  : '0' }}</a>
                                </td>
                                <td>
                                    <a href="#" data-field='year' data-field_value="{{ $year }}"
                                       data-model="UserEntitlement"
                                       data-foreign_key='user_id' data-type="select" data-id='{{ $user->id }}' data-placeholder="Required"
                                       data-value_key="type" data-value_value="{!! json_encode(array_keys($types)) !!}"
                                       data-value='{{ $search && $search->type ? $search->type : null }}'
                                       class="editable {{ $search && $search->type ? 'editable-click' : 'editable-empty'  }}">
                                        {{ $search && $search->type ? $search->type  : '0' }}</a>
                                </td>
                                <td>
                                    <a href="#" data-field='year' data-field_value="{{ $year }}" data-model="UserEntitlement"
                                       data-foreign_key='user_id' data-type="text" data-id='{{ $user->id }}' data-placeholder="Required"
                                       data-value_key="used" data-value='{{ $search ? $search->used : null }}'
                                       class="editable {{ $search && $search->used ? 'editable-click' : 'editable-empty'  }}">
                                        {{ $search && $search->used ? $used = $search->used  : '0' }}</a>
                                </td>
                                <td>{{ $search ? $pending = $search->pending : null }}</td>
                                <td>{{ $days ? ($days - ($used ? $used : 0) - ($pending ? $pending : 0)) : "" }}</td>

                            @endforeach
                            <td><a target="_blank" href="{{ route("homepage")."#hrm/{$user->id}/edit" }}" class="btn btn-warning btn-sm">@lang("content.edit")</a></td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
