<?php require_once(public_path("smart/inc/init.php")); ?>

<!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <div class="bg-white">

                <ul class="nav nav-tabs">
                    <li class="active"><a href="#entitlements" role="tab" data-toggle="tab">@lang("content.entitlements")</a></li>
                    <li class="">
                        <a href="{{ route("homepage")."#hrm/requests" }}" target="_blank">@lang("content.leave_requests")</a>
                    </li>
                </ul>

                {{--Tab Content--}}
                <div class="tab-content margin-top-10">
                    <div class="tab-pane bg-color-white active" id="entitlements">
                        <div class="bg-white">
                            <ul class="nav nav-pills padding-10">
                                @php $j = 0 @endphp
                                @foreach($airports as $i => $each)
                                    <li class="{{ $j++ == 0 ? "active" : "" }}">
                                        <a href="#staff-{{ $i }}" role="tab" data-toggle="tab">{{ $each }}</a>
                                    </li>
                                @endforeach
                            </ul>

                            <div class="pill-content padding-10 background-white">
                                @php $j = 0 @endphp
                                @foreach($airports as $i => $airport)
                                    <div class="pill-pane {{ $j++ == 0 ? "active" : "" }}" id="staff-{{ $i }}">
                                        @if(isset($staffList[$airport]))
                                            @include("hrm.layouts.staff-list", ["list" => $staffList[$airport], "airport" => $airport, "id" => "table_".$i])
                                        @endif
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>

{{--                    <div class="tab-pane bg-color-white" id="requests">--}}
{{--                        @include("user.layouts.employees-requests-table", ["hideForm" => true])--}}
{{--                    </div>--}}
                </div>

            </div>
        </article>
    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        @foreach($airports as $i => $airport)
            ApplyTableFilter("#table_{{$i}}");
        @endforeach
    };

    pagefunction();

</script>