<?php require_once(public_path("smart/inc/init.php")); ?>

<!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
            <div class="col-lg-6">
                <h5>{{ getUserName($user) }}</h5>
                <h5>Staff No {{ $user->staff_number }}</h5>
                <h5>{{ count($user->position) ? $user->position[0]->name : "" }}, {{ count($user->department) ? $user->department[0]->name : "" }}</h5>
            </div>
            <div class="col-lg-12" style="margin-top: 10px">
                {!! Form::open([ 'method' => 'POST', 'class' => '', 'url' => url("/hrm/{$user->id}") ]) !!}
                <table class="table table-bordered table-striped table-hover">
                   <thead>
                   <tr>
                       <th>@lang("content.year")</th>
                       <th>Entitlement(Days)</th>
                       <th>@lang("content.type")</th>
{{--                       <th>Pending(Days)</th>--}}
                       <th>Used(Days)</th>
                   </tr>
                   </thead>
                   <tbody>
                   @foreach($last3years as $year)
                       @php $days = isset($entitlements[$year]) ? $entitlements[$year]->entitlement : "" @endphp
                       @php $pending = isset($entitlements[$year]) ? $entitlements[$year]->pending : "" @endphp
                       @php $used = isset($entitlements[$year]) ? $entitlements[$year]->used : "" @endphp
                       @php $type = isset($entitlements[$year]) ? $entitlements[$year]->type : "Calendar" @endphp
                       <tr>
                           <td>{!! Form::input('number', 'year[]', $year, ['class' => 'form-control', 'readonly']) !!}</td>
                           <td>{!! Form::input('number', 'entitlement[]', $days, ['class' => 'form-control']) !!}</td>
                           <td>{!! Form::select('type[]', $types, $type, ['class' => 'form-control']) !!}</td>
{{--                           <td>{!! Form::input('number', 'pending[]', $pending, ['class' => 'form-control']) !!}</td>--}}
                           <td>{!! Form::input('number', 'used[]', $used, ['class' => 'form-control']) !!}</td>
                       </tr>
                   @endforeach
                   <tr>
                       <td colspan="5">{!! Form::submit("Submit", ['class' => 'btn btn-success btn-sm']) !!}</td>
                   </tr>
                   </tbody>
                </table>
                {!! Form::close() !!}
            </div>
        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();
    };

    pagefunction();

</script>