@php $height = isset($height) ? $height : "150px" @endphp
@php $width = isset($width) ? $width : "auto" @endphp
@php $padding = isset($padding) ? $padding : "auto" @endphp
@php $class = isset($class) ? $class : "" @endphp
@php $headerClass = isset($headerClass) ? $headerClass : "" @endphp
@php $headerColor = isset($headerColor) ? $headerColor : "auto" @endphp
@php $bodyColor = isset($bodyColor) ? $bodyColor : "auto" @endphp
<article class="col-sm-12 col-md-{{ $col }} col-lg-{{ $col }}">

    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-chart-id-{{ $id }}"
         data-widget-fullscreenbutton="false" data-widget-editbutton="false"
         data-widget-sortable="false">
        <!-- widget options:
            usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">


            data-widget-editbutton="false"
            data-widget-togglebutton="false"
            data-widget-deletebutton="false"
            data-widget-fullscreenbutton="false"
            data-widget-custombutton="false"
            data-widget-collapsed="true"
            data-widget-sortable="false"

        -->
        <header>
            @if (isset($titleHref))
                <h2><a href="{{ $titleHref }}">{{ $title }}</a></h2>
            @else
                <h2>{{ $title }}</h2>
            @endif
        </header>

        <!-- widget div-->
        <div>

            <!-- widget edit box -->
            <div class="jarviswidget-editbox">
                <!-- This area used as dropdown edit box -->
                <input class="form-control" type="text">
            </div>
            <!-- end widget edit box -->

            <!-- widget content -->
            <div class="widget-body">

                <div id="revenue_by_country" class="vector-map" style="height: 300px !important;"></div>
                <div id="heat-fill">
                    <span class="fill-a">0</span>

                    <span class="fill-b">{{ $maxRevenue }}</span>
                </div>

                <div style="height: 160px; overflow: auto;">
                    <table class="table table-striped table-hover table-condensed">
                        <thead>
                        <tr>
                            <th style="width: 20%">{{ trans('page.country') }}</th>
                            <th style="width: 20%">{{ trans('page.revenue') }}</th>
                            <th style="width: 20%">{{ $chart[0]['pax'] }}</th>
                            <th style="width: 20%">{{ trans('page.yield') }}</th>
                            <th>{{ trans('page.share') }}</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($chart as $i => $each)
                            @if ($i == 0)
                                @continue
                            @endif

                            <tr>
                                <td>
                                    <a href="javascript:void(0);"><img src="{{ asset("/assets/img/icons/flags/24/{$each['country']}.png") }}" />
                                        {{ $each['abbr'] }}
                                    </a>
                                </td>
                                <td>{{ number_format($each['revenue']) }}</td>
                                <td>{{ number_format($each['pax']) }}</td>
                                <td>{{ number_format($each['yield']) }}</td>
                                <td>
                                    <div class="sparkline display-inline" data-sparkline-type='pie' data-sparkline-piecolor='["#57889C", "#E979BB"]' data-sparkline-offset="90" data-sparkline-piesize="23px">
                                        {{ 100 - number_format($each['share'], 1).",".number_format($each['share'], 1) }}
                                    </div>

                                    <div style="display: inline-block; margin-left: 20px;">{{ number_format($each['share'], 1) }}%</div>
                                </td>
                            </tr>
                        @endforeach

                        </tbody>
                    </table>
                </div>
                {{--<div id="chart_revenue_by_country" style="height: {{ $height }}; display: block; margin-bottom: 10px">--}}
                {{--<div class="col-md-12 widget_countries {{ $class }}" style="width: {{ $width }}; padding: {{ $padding }};">--}}

            </div>
        </div>

    </div>

</article>

