<!-- PUNCTUALITY BY STATIONS -->
<div class="jarviswidget jarviswidget-color-blueDark" id="wid-punctuality-stations" data-widget-editbutton="false" data-widget-fullscreenbutton="true">
    <!-- widget options:
    usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    data-widget-colorbutton="false"
    data-widget-editbutton="false"
    data-widget-togglebutton="false"
    data-widget-deletebutton="false"
    data-widget-fullscreenbutton="false"
    data-widget-custombutton="false"
    data-widget-collapsed="true"
    data-widget-sortable="false"

    -->
    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>
        <h2>@lang("content.punctuality_by_station")</h2>

    </header>

    <!-- widget div-->
    <div>

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding">

            <div class="table-responsive">

                @php $futureDates = strtotime($dateFrom) > strtotime(date("Y-m-d")) @endphp

                <table class="table table-bordered table-hover" id="punctuality-by-station">
                    <thead>
                    <tr>
                        <th data-right></th>
                        <th rowspan="2" class="text-center" style="width: 70px !important;">@lang("content.total_flights")</th>

                        @if (!$futureDates && isset($categories) && count($categories))
                            @foreach($categories as $category)
                                <th colspan="{{ $category == "above_60_mins" ? 3 : 2 }}" class="text-center" style="width: 19% !important;">{{ trans("content.{$category}") }}</th>
                            @endforeach
                        @endif
                    </tr>
                    <tr>
                        <th data-center>@lang("content.station")</th>

                        @if (!$futureDates && isset($categories) && count($categories))
                            @foreach($categories as $category)
                                @if($category == "above_60_mins")
                                    <th class="text-center" style="width: 11% !important;">@lang("content.percentage")</th>
                                    <th class="text-center" style="width: 4% !important;">%</th>
                                @else
                                    <th class="text-center" style="width: 11% !important;">@lang("content.percentage"), %</th>
                                @endif
                                <th class="text-center" style="width: 4% !important;">@lang("content.flights")</th>
                            @endforeach
                        @endif
                    </tr>
                    </thead>

                    <tbody>
                    @if (isset($foundAirports) && count($foundAirports) && count($airportsByCategory))
                        @foreach($foundAirports as $airport)
                            <tr>
                                <td data-center style="font-weight: bold">{{ $airport }}</td>
                                <td data-right style="font-weight:bold;">{{ $airportsByCategory[$airport] }}</td>

                                @if (!$futureDates)
                                    @foreach($categories as $i => $category)

                                        @if (!isset($totalByCategory[$category]))
                                            @php $totalByCategory[$category] = 0 @endphp
                                        @endif

                                        @php $bgClass = getPunctualityBgClass($category) @endphp
                                        @php $currentAirport = isset($airportsByCategory[$i][$airport]) ? $airportsByCategory[$i][$airport] : false @endphp

                                        @if ($currentAirport)
                                            @if($category == "above_60_mins")
                                                <td style="border-right: 0;">
                                                    <div class="col-md-12 progress no-padding no-margin">
                                                        <div class="progress-bar {{ $bgClass }} {{ $labelClass }}" aria-valuetransitiongoal="{{ $currentAirport->percentage }}" aria-valuenow="{{ $currentAirport->percentage }}" style="width: {{ $currentAirport->percentage }}%;"></div>
                                                    </div>
                                                </td>
                                                <td>{{ $currentAirport->percentage }}%</td>
                                            @else
                                                <td style="">
                                                    <div class="col-md-12 progress no-padding no-margin">
                                                        @php $labelClass = $currentAirport->percentage < 15 ? "color-black" : "" @endphp
                                                        <div class="progress-bar {{ $bgClass }} {{ $labelClass }}" aria-valuetransitiongoal="{{ $currentAirport->percentage }}" aria-valuenow="{{ $currentAirport->percentage }}" style="width: {{ $currentAirport->percentage }}%;">{{ $currentAirport->percentage }}%</div>
                                                    </div>
                                                </td>
                                            @endif

                                            <td data-right>{{ $currentAirport->count }}</td>
                                        @endif

                                    @endforeach
                                @endif
                            </tr>
                        @endforeach
                    @endif
                    <tr class="bg-success">
                        @include("home.handling.total-result", ["futureDates" => $futureDates])
                    </tr>
                    </tbody>
                </table>

            </div>
        </div>
        <!-- end widget content -->

    </div>
    <!-- end widget div -->

</div>
<!-- PUNCTUALITY TABLE END -->