<article class="col-sm-12 col-md-12 col-lg-12">

    <!-- PUNCTUALITY BY AIRLINES -->
    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-punctuality-airlines" data-widget-editbutton="false" data-widget-fullscreenbutton="true">
        <!-- widget options:
        usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

        data-widget-colorbutton="false"
        data-widget-editbutton="false"
        data-widget-togglebutton="false"
        data-widget-deletebutton="false"
        data-widget-fullscreenbutton="false"
        data-widget-custombutton="false"
        data-widget-collapsed="true"
        data-widget-sortable="false"

        -->
        <header>
            <span class="widget-icon"> <i class="fa fa-table"></i> </span>

            <h2>@lang("content.punctuality_by_airlines")</h2>

        </header>

        <!-- widget div-->
        <div>

            <!-- widget edit box -->
            <div class="jarviswidget-editbox">
                <!-- This area used as dropdown edit box -->

            </div>
            <!-- end widget edit box -->

            <!-- widget content -->
            <div class="widget-body no-padding">

                <div class="table-responsive">

                    @php $futureDates = strtotime($dateFrom) > strtotime(date("Y-m-d")) @endphp

                    <table class="table table-bordered table-hover" id="punctuality-by-airlines">
                        <thead>
                        <tr>
                            <th data-right></th>
                            <th rowspan="2" class="text-center" style="width: 70px !important;">@lang("content.total")<br/>@lang("content.flights")</th>
                            @if (!$futureDates && isset($categories) && count($categories))
                                @foreach($categories as $category)
                                    @if($category == "above_60_mins")
                                        <th colspan="3" class="text-center" style="width: 19% !important;">{{ trans("content.{$category}") }}</th>
                                    @else
                                        <th colspan="2" class="text-center" style="width: 15% !important;">{{ trans("content.{$category}") }}</th>
                                    @endif
                                @endforeach
                            @endif
                        </tr>
                        <tr>
                            <th data-center>@lang("content.airline")</th>
                            @if (!$futureDates && isset($categories) && count($categories))
                                @foreach($categories as $category)
                                    @if($category == "above_60_mins")
                                        <th class="text-center" style="width: 11% !important;">@lang("content.percentage")</th>
                                        <th class="text-center" style="width: 4% !important;">%</th>
                                    @else
                                        <th class="text-center" style="width: 11% !important;">@lang("content.percentage"), %</th>
                                    @endif

                                    <th class="text-center" style="width: 4% !important;">@lang("content.flights")</th>
                                @endforeach
                            @endif
                        </tr>
                        </thead>

                        <tbody>
                        @if (isset($airlinesObj) && count($airlinesObj) && $airlinesByCategory && count($airlinesByCategory))
                            @foreach($airlinesObj as $airline)
                                @php $code = getAirlineCode($airline) @endphp
                                @if (!isset($airlinesByCategory[$code]) || $airlinesByCategory[$code] == 0)
                                    @continue
                                @endif

                                @php  $picture = $airline->picture ? asset("storage/airlines/img/{$airline->picture}") : asset("/assets/img/default-airline-picture.png"); @endphp

                                <tr>
                                    <td data-center style="font-weight: 500">
                                        <img class='fleetwatch-airline-logo'
                                             src='{{ $picture }}'/>
                                    </td>

                                    <td data-right style="font-weight:bold;">{{ $airlinesByCategory[$code] }}</td>

                                    @if (!$futureDates)
                                        @foreach($categories as $i => $category)
                                            @php $bgClass = getPunctualityBgClass($category) @endphp
                                            @php $currentAirline = isset($airlinesByCategory[$i][$code]) ? $airlinesByCategory[$i][$code] : false @endphp
                                            @if ($currentAirline)
                                                @if($category == "above_60_mins")
                                                    <td style="border-right: 0;">
                                                        <div class="col-md-12 progress no-padding no-margin">
                                                            <div class="progress-bar {{ $bgClass }} {{ $labelClass }}"
                                                                 aria-valuetransitiongoal="{{ $currentAirline->percentage }}"
                                                                 aria-valuenow="{{ $currentAirline->percentage }}"
                                                                 style="width: {{ $currentAirline->percentage }}%;"></div>
                                                        </div>
                                                    </td>
                                                    <td>{{ $currentAirline->percentage }}%</td>
                                                @else
                                                    <td style="">
                                                        <div class="col-md-12 progress no-padding no-margin">
                                                            @php $labelClass = $currentAirline->percentage < 15 ? "color-black" : "" @endphp
                                                            <div class="progress-bar {{ $bgClass }} {{ $labelClass }}"
                                                                 aria-valuetransitiongoal="{{ $currentAirline->percentage }}"
                                                                 aria-valuenow="{{ $currentAirline->percentage }}"
                                                                 style="width: {{ $currentAirline->percentage }}%;">{{ $currentAirline->percentage }}
                                                                %
                                                            </div>
                                                        </div>
                                                    </td>
                                                @endif

                                                <td data-right>{{ $currentAirline->count }}</td>
                                            @endif
                                        @endforeach
                                    @endif
                                </tr>
                            @endforeach
                        @endif

                        <tr class="bg-success">
                            @include("home.handling.total-result")
                        </tr>

                        </tbody>
                    </table>

                </div>
            </div>
            <!-- end widget content -->

        </div>
        <!-- end widget div -->

    </div>
    <!-- PUNCTUALITY TABLE END -->

</article>
