@if (isset($id))
    @php $id           =  $id @endphp
    @php $editable     =  'disabled' @endphp
@else
    @php $id           =  'new' @endphp
    @php $editable     =  '' @endphp
@endif

@php $hidden           =  isset($hidden) ? 'hidden' : '' @endphp
@php $column_id        =  isset($column_id) ? $column_id : NULL @endphp
@php $chart_id         =  isset($chart_id) ? $chart_id : NULL @endphp
@php $chart_type_id    =  isset($chart_type_id) ? $chart_type_id : NULL @endphp
@php $type             =  isset($type) ? $type : NULL @endphp
@php $height           =  isset($height) ? $height : NULL @endphp
@php $report_period_id =  isset($report_period_id) ? $report_period_id : NULL @endphp
@php $date_from        =  isset($date_from) ? $date_from : NULL @endphp
@php $date_to          =  isset($date_to) ? $date_to : NULL @endphp



<div class="form-group chart {{ $editable }} {{ $hidden }}" style="padding: 10px 5px; margin: 0 !important;" data-order="{{ $order }}">
    {!! Form::open(['method' => 'POST', 'class' => 'form-inline', 'url' => url("home/config/{$id}") ]) !!}
    <div class="col-md-12">
        <div class="form-group">
            {!! Form::hidden('column_id', $column_id) !!}
            {!! Form::hidden('order', $order) !!}
            <label class="control-label">Chart</label>
            {!! Form::select('chart_id', $charts, $chart_id, ['class'=>'form-control singleselect', 'id'=>'chart']) !!}
        </div>

        <div class="form-group margin_right_10">
            <label class="control-label">@lang("content.type")</label>
            {!! Form::select('chart_type_id', $chart_types, $chart_type_id, ['class'=>'form-control singleselect', 'id'=>'chart_type']) !!}
        </div>

        {!! Form::label('height', 'Height') !!}

        {!! Form::text('height', $height, ['class' => 'form-control width-50']) !!}
    </div>
    <div class="col-md-12" style="margin-top: 10px">

        <div class="form-group margin_right_10">
            <label class="control-label">@lang("content.period")</label>
            {!! Form::select("report_period_id", $periods, $report_period_id, ["class"=>"form-control singleselect"]) !!}
        </div>

        <div class="form-group margin_right_10">
            <label class="control-label">From
                {!! Form::text('date_from', $date_from, ['class' => 'form-control dateFrom input-date-small']) !!}
            </label>
        </div>

        <div class="form-group margin_right_10">
            <label class="control-label">To
                {!! Form::text('date_to', $date_to, ['class' => 'form-control dateTo input-date-small']) !!}
            </label>
        </div>
    </div>
    <div class="col-md-8" style="margin-top: 10px">

        <div class="form-group margin_right_10">
            <label class="control-label">@lang("content.type")</label>
            {!! Form::select("type", $types, $type, ["class"=>"form-control form-control singleselect"]) !!}
        </div>

        <div class="form-group" style="float: right">
            @if ($editable)
                <input type="submit" name="edit" class="btn btn-primary" value="Save Changes" />
                <input type="submit" name="insert" style="display: none" class="btn btn-success" value="Add New Chart" />
            @else
                <input type="submit" name="edit" style="display: none" class="btn btn-primary" value="Save Changes" />
                <input type="submit" name="insert" class="btn btn-success" value="Add New Chart" />
            @endif
        </div>
    </div>

    {!! Form::close() !!}

    {!! Form::open(['method' => 'DELETE', 'class' => 'form-inline', 'url' => url("home/config/{$id}") ]) !!}
    <div class="col-md-4" style="margin-top: 10px">
        <input type="submit" name="delete" class="btn btn-warning" value="Delete" />
    </div>
    {!! Form::close() !!}


</div>

