<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-sm-12">

            <div class="bg-color-white padding-10 bordered" style="border-bottom: 0">
                {!! Form::open(['method' => 'GET', 'url' => url('home/dashboard'), 'class' => 'form-inline']) !!}

                <div class="form-group">
                    <label class="sr-only" for="dateFrom">Show From</label>
                    {!! Form::input('text', 'dateFrom', \request("dateFrom"), ['class'=>'form-control input-sm date', "placeholder" => "Date From"]) !!}
                </div>
                <div class="form-group">
                    {!! Form::input('text', 'dateTo', \request("dateTo"), ['class'=>'form-control input-sm date', "placeholder" => "To"]) !!}
                </div>

                {!! Form::submit("Submit", ['name' => "submit", 'class' => "btn btn-primary"]) !!}

                <div class="btn-group hidden-phone pull-right">
                    <a class="btn dropdown-toggle btn-xs btn-default" data-toggle="dropdown"><i class="fa fa-cog"></i> More <span class="caret"> </span> </a>
                    <ul class="dropdown-menu pull-right">
                        <li>
                            <a href="javascript:void(0);"><i class="fa fa-file-text-alt"></i> Export to PDF</a>
                        </li>
                        <li>
                            <a href="javascript:void(0);"><i class="fa fa-question-sign"></i> Help</a>
                        </li>
                    </ul>
                </div>

                {!! Form::close() !!}

            </div>

            <!-- new widget -->
            <div class="jarviswidget" id="wid-id-0" data-widget-togglebutton="false" data-widget-editbutton="false" data-widget-fullscreenbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
                <!-- widget options:
                usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                data-widget-colorbutton="false"
                data-widget-editbutton="false"
                data-widget-togglebutton="false"
                data-widget-deletebutton="false"
                data-widget-fullscreenbutton="false"
                data-widget-custombutton="false"
                data-widget-collapsed="true"
                data-widget-sortable="false"

                -->
                <header>
                    <span class="widget-icon"> <i class="glyphicon glyphicon-stats txt-color-darken"></i> </span>
                    <h2>Live Feeds </h2>

                    <ul class="nav nav-tabs pull-right in" id="myTab">

                        <li class="active">
                            <a data-toggle="tab" href="#s0"><i class="fa fa-euro"></i> <span class="hidden-mobile hidden-tablet">Dashboard</span></a>
                        </li>

                        @foreach($charts as $i => $each)
                            <li>
                                <a data-toggle="tab" href="#s{{ $i }}"><i class="fa fa-dollar"></i> <span class="hidden-mobile hidden-tablet">Dashboard</span></a>
                            </li>
                        @endforeach
                    </ul>

                </header>

                <!-- widget div-->
                <div class="no-padding">
                    <!-- widget edit box -->
                    <!-- end widget edit box -->

                    <div class="widget-body">
                        <!-- content -->
                        <div id="myTabContent" class="tab-content">
                            {{--@foreach($charts as $i => $columnCharts)--}}

                                {{--@if ($i == 0)--}}
                                <div class="tab-pane fade active in" id="s1">

                                        @php $details = isset($seatFactorsChart['details']) ? $seatFactorsChart['details'] : null @endphp
                                        @php $chart = $details ? $details->chart : null @endphp

                                        @if ($details)
                                            <div class="col-xs-12 col-sm-12 col-md-8 col-lg-8">

                                                <header>
                                                    <h5>
                                                        <a target="_blank" href="{{ route("homepage")."#". url("chart/search?chart={$details->chart_id}") }}">@lang("content.seat_factors")</a>
                                                    </h5>
                                                </header>

                                                <div id="seat_factors_daily" class="chart-large txt-color-blue"></div>
                                                {{--<canvas id="{{ $columnCharts['div_id'] }}" height="80px"></canvas>--}}
                                            </div>
                                        @endif

                                        <div class="col-xs-12 col-sm-12 col-md-4 col-lg-4 show-stats">

                                            @if (isset($punctualityChart['details']))
                                                <h5>
                                                    <a target="_blank" href="{{ route("homepage")."#". url("chart/search?chart={$punctualityChart['details']->chart_id}") }}">Punctuality</a>
                                                </h5>
                                            @endif

                                            @if (isset($punctualityChart['data']) && isset($punctualityChart["keys"]))
                                                <div class="row">
                                                    @foreach($punctualityChart["data"][$punctualityChart["keys"][1]] as $j => $value)
                                                        @php $color = $value > 90 ? "bg-color-green" : ($value > 75 ? "bg-color-orange" : "bg-color-red") @endphp
                                                        <div class="col-xs-6 col-sm-6 col-md-12 col-lg-12">
                                                            <span class="text"> {{ $punctualityChart["data"][$punctualityChart["keys"][0]][$j] }} <span class="pull-right">{{ $value }}%</span> </span>

                                                            <div class="progress">
                                                                <div class="progress-bar {{ $color }}" style="width: {{ $value }}%;"></div>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            @endif

                                        </div>

                                    @if ($seatFactorsChart && isset($seatFactorsChart['data']) && isset($seatFactorsChart["keys"]))
                                        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                                            <div class="show-stat-microcharts">

                                            @foreach($seatFactorsChart["data"][$seatFactorsChart["keys"][1]] as $j => $value)
                                                <div class="col-xs-12 col-sm-4 col-md-4 col-lg-4">
                                                    <div class="easy-pie-chart txt-color-orangeDark" data-percent="{{ $value }}" data-pie-size="50">
                                                        <span class="percent percent-sign">{{ $value }}</span>
                                                    </div>
                                                    <span class="easy-pie-title"> {{ $seatFactorsChart["data"][$seatFactorsChart["keys"][0]][$j] }} <i class="fa fa-caret-up icon-color-bad"></i> </span>
                                                    <ul class="smaller-stat hidden-sm pull-right">
                                                        <li>
                                                            <span class="label bg-color-greenLight"><i class="fa fa-caret-up"></i> {{ rand(50,99) }}%</span>
                                                        </li>
                                                        <li>
                                                            <span class="label bg-color-blueLight"><i class="fa fa-caret-down"></i> {{ rand(20, 45) }}%</span>
                                                        </li>
                                                    </ul>
                                                </div>
                                            @endforeach
                                            </div>
                                        </div>
                                    @endif

                                </div>

                             </div>
                        <!-- end content -->
                        </div>

                    </div>
                    <!-- end widget div -->
                </div>
                <!-- end widget -->
        </article>

    </div>


    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
            <!-- new widget -->
            <div class="col-md-4">
                <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-3" data-widget-colorbutton="false">

                    <header>
                        <span class="widget-icon"> <i class="fa fa-calendar"></i> </span>
                        <h2> My Events </h2>
                        <div class="widget-toolbar">
                            <!-- add: non-hidden - to disable auto hide -->
                            <div class="btn-group">
                                <button class="btn dropdown-toggle btn-xs btn-default" data-toggle="dropdown">
                                    Showing <i class="fa fa-caret-down"></i>
                                </button>
                                <ul class="dropdown-menu js-status-update pull-right">
                                    <li>
                                        <a href="javascript:void(0);" id="mt">@lang("content.month")</a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0);" id="ag">Agenda</a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0);" id="td">Today</a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </header>

                    <!-- widget div-->
                    <div>
                        <!-- widget edit box -->
                        <div class="jarviswidget-editbox">

                            <input class="form-control" type="text">

                        </div>
                        <!-- end widget edit box -->

                        <div class="widget-body no-padding">
                            <!-- content goes here -->
                            <div class="widget-body-toolbar">

                                <div id="calendar-buttons">

                                    <div class="btn-group">
                                        <a href="javascript:void(0)" class="btn btn-default btn-xs" id="btn-prev"><i class="fa fa-chevron-left"></i></a>
                                        <a href="javascript:void(0)" class="btn btn-default btn-xs" id="btn-next"><i class="fa fa-chevron-right"></i></a>
                                    </div>
                                </div>
                            </div>
                            <div id="calendar"></div>

                            <!-- end content -->
                        </div>

                    </div>
                    <!-- end widget div -->
                </div>
            </div>
            <!-- end widget -->

            @if (isset($countryChart['data']))
                @include('home/homepage/revenue_by_country', ['chart' => $countryChart['data'], "col" => "8", "id" => "0-0", 'titleHref' => url("chart/search?chart={$countryChart['details']->chart_id}"), "title" => $countryChart['title'] ])
            @endif
        </article>

    </div>

</section>




<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        var barOptions = GetChartJsBarOptions();

        var lineOptions = GetChartJsLineOptions();

        var ctx, myNewChart, chartData;

        var colors = [
            "211,139,155",
            "68,148,210",
            "51,127,105",
            "50, 147, 50",
        ];


        // load all flot plugins
        loadScript("<?php echo ASSETS_URL; ?>/js/plugin/flot/jquery.flot.cust.min.js", function(){
            loadScript("<?php echo ASSETS_URL; ?>/js/plugin/flot/jquery.flot.resize.min.js", function(){
                loadScript("<?php echo ASSETS_URL; ?>/js/plugin/flot/jquery.flot.time.min.js", function(){
                    loadScript("<?php echo ASSETS_URL; ?>/js/plugin/flot/jquery.flot.tooltip.min.js", generatePageGraphs);
                });
            });
        });

        function generatePageGraphs() {

            var data = [], seat_factors_daily = $("#seat_factors_daily"),
                $UpdatingChartColors = seat_factors_daily.css('color');

            // setup control widget

            // setup plot
            var options = {
                yaxis: {
                    min: 0,
                    max: 100
                },
                xaxis: {
                    min: 0,
                    max: 30
                },
                colors: [$UpdatingChartColors],
                series: {
                    lines: {
                        lineWidth: 1,
                        fill: true,
                        fillColor: {
                            colors: [{
                                opacity: 0.4
                            }, {
                                opacity: 0
                            }]
                        },
                        steps: false

                    }
                }
            };

            var data = {!! json_encode([$seatFactorsDaily]) !!};

            $.plot(seat_factors_daily, data, options);
        }

     /*
     chartData = {
            labels: json_encode($seatFactorsDaily["Date/Period"]) ,
            datasets: [
                {
                    label: " $each["keys"][0] ",
                    backgroundColor: "rgba(" + colors[index] +", 0.5)",
                    hoverBackgroundColor: "rgba(" + colors[index] +", 0.8)",
                    borderColor: "rgba(" + colors[index] +", 1)",
                    pointBackgroundColor: "rgba(" + colors[index] +", 0.8)",
                    pointBorderColor: "#fff",
                    pointHoverBackgroundColor: "#fff",
                    pointHoverBorderColor: "rgba(" + colors[index] +", 1)",
                    borderWidth: 2,
                    pointBorderWidth: 1,
                    pointRadius: 3,
                    data:  json_encode($seatFactorsDaily["Percentage, %"])
                }
            ]
        };

        var minOptions = lineOptions;
        minOptions['scales'] = {
            yAxes: [{
                ticks: {
                    max: 100,
                    min: 0,
                }
            }]
        };

        ctx = document.getElementById("seat_factors_daily").getContext("2d");
        new Chart(ctx, { type: 'line', data: chartData, options: lineOptions });
        */



        var data_array = {!! json_encode($chartArray) !!};

        loadScript("<?php echo ASSETS_URL ?>/js/plugin/vectormap/jquery-jvectormap-1.2.2.min.js", function(){
            loadScript("<?php echo ASSETS_URL ?>/js/plugin/vectormap/jquery-jvectormap-world-mill-en.js", renderVectorMap)
        });


        function renderVectorMap() {
            $('#revenue_by_country').vectorMap({
                map: 'world_mill_en',
                backgroundColor: '#fff',
                regionStyle: {
                    initial: {
                        fill: '#c4c4c4'
                    },
                    hover: {
                        "fill-opacity": 1
                    }
                },
                series: {
                    regions: [{
                        values: data_array,
                        scale: ['#60c5ed', '#0f232b'],
                        normalizeFunction: 'polynomial'
                    }]
                },
                onRegionLabelShow: function (e, el, code) {
                    if (typeof data_array[code] == 'undefined') {
                        e.preventDefault();
                    } else {
                        var countrylbl = data_array[code];
                        el.html(el.html() + '(Revenue: ' + countrylbl + ')');
                    }
                }
            });
        }


        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");

        /*
         * FULL CALENDAR JS
         */

        // Load Calendar dependency then setup calendar

        loadScript("<?php echo ASSETS_URL; ?>/js/plugin/moment/moment.min.js", function(){
            loadScript("<?php echo ASSETS_URL; ?>/js/plugin/fullcalendar/jquery.fullcalendar.min.js", setupCalendar);
        });

        function setupCalendar() {

            if ($("#calendar").length) {
                var date = new Date();
                var d = date.getDate();
                var m = date.getMonth();
                var y = date.getFullYear();

                calendar = $('#calendar').fullCalendar({

                    editable: true,
                    draggable: true,
                    selectable: false,
                    selectHelper: true,
                    unselectAuto: false,
                    disableResizing: false,
                    height: "auto",

                    header: {
                        left: 'title', //,today
                        center: 'prev, next, today',
                        right: 'month, agendaWeek, agenDay' //month, agendaDay,
                    },

                    select: function (start, end, allDay) {
                        var title = prompt('Event Title:');
                        if (title) {
                            calendar.fullCalendar('renderEvent', {
                                        title: title,
                                        start: start,
                                        end: end,
                                        allDay: allDay
                                    }, true // make the event "stick"
                            );
                        }
                        calendar.fullCalendar('unselect');
                    },

                    events: [{
                        title: 'All Day Event',
                        start: new Date(y, m, 1),
                        description: 'long description',
                        className: ["event", "bg-color-greenLight"],
                        icon: 'fa-check'
                    }, {
                        title: 'Long Event',
                        start: new Date(y, m, d - 5),
                        end: new Date(y, m, d - 2),
                        className: ["event", "bg-color-red"],
                        icon: 'fa-lock'
                    }, {
                        id: 999,
                        title: 'Repeating Event',
                        start: new Date(y, m, d - 3, 16, 0),
                        allDay: false,
                        className: ["event", "bg-color-blue"],
                        icon: 'fa-clock-o'
                    }, {
                        id: 999,
                        title: 'Repeating Event',
                        start: new Date(y, m, d + 4, 16, 0),
                        allDay: false,
                        className: ["event", "bg-color-blue"],
                        icon: 'fa-clock-o'
                    }, {
                        title: 'Meeting',
                        start: new Date(y, m, d, 10, 30),
                        allDay: false,
                        className: ["event", "bg-color-darken"]
                    }, {
                        title: 'Lunch',
                        start: new Date(y, m, d, 12, 0),
                        end: new Date(y, m, d, 14, 0),
                        allDay: false,
                        className: ["event", "bg-color-darken"]
                    }, {
                        title: 'Birthday Party',
                        start: new Date(y, m, d + 1, 19, 0),
                        end: new Date(y, m, d + 1, 22, 30),
                        allDay: false,
                        className: ["event", "bg-color-darken"]
                    }, {
                        title: 'Smartadmin Open Day',
                        start: new Date(y, m, 28),
                        end: new Date(y, m, 29),
                        className: ["event", "bg-color-darken"]
                    }],

                    eventRender: function (event, element, icon) {
                        if (!event.description == "") {
                            element.find('.fc-title').append("<br/><span class='ultra-light'>" + event.description + "</span>");
                        }
                        if (!event.icon == "") {
                            element.find('.fc-title').append("<i class='air air-top-right fa " + event.icon + " '></i>");
                        }
                    }
                });

            };

            /* hide default buttons */
            $('.fc-toolbar .fc-right, .fc-toolbar .fc-center').hide();

        }

        // calendar prev
        $('#calendar-buttons #btn-prev').click(function () {
            $('.fc-prev-button').click();
            return false;
        });

        // calendar next
        $('#calendar-buttons #btn-next').click(function () {
            $('.fc-next-button').click();
            return false;
        });

        // calendar today
        $('#calendar-buttons #btn-today').click(function () {
            $('.fc-button-today').click();
            return false;
        });

        // calendar month
        $('#mt').click(function () {
            $('#calendar').fullCalendar('changeView', 'month');
        });

        // calendar agenda week
        $('#ag').click(function () {
            $('#calendar').fullCalendar('changeView', 'agendaWeek');
        });

        // calendar agenda day
        $('#td').click(function () {
            $('#calendar').fullCalendar('changeView', 'agendaDay');
        });

    };

    var pagedestroy = function(){
        // destroy vector map objects
        $("#revenue_by_country").find('*').addBack().off().remove();
    };

    loadScript("<?php echo ASSETS_URL; ?>/js/plugin/chartjs/chart.min.js", function(){
        loadScript("{{ asset("/assets/js/views/user/homepage.js") }}", pagefunction);
    });

</script>




