

<?php require_once(public_path("smart/inc/init.php")); ?>

<style>
    label, label.control-label{
        color: #000;
    }
    .chart {
        height: auto;
    }
</style>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => 'Homepage', 'moduleName' => 'Charts'])

            <div>
                @include('home/form/add-chart', ['hidden' => true, 'order' => 0])

                @foreach($column_charts as $i => $column)
                    <div class="col-md-4 chart-container" data-column_id = "{{ $i }}">
                        <div class="chart-header">COLUMN-{{ $i }}</div>
                        @if (count($column))
                            @foreach($column as $j => $each)
                                @include('home/form/add-chart', ['order' => $j + 1] + $each->getAttributes())
                            @endforeach
                        @endif
                        <div>
                            <a name="add" data-ignore='true' class="btn btn-success">@lang("content.add")</a>
                        </div>
                    </div>
                @endforeach

            </div>

        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        $(document).on('click', 'a[name=add]', function () {
            var _this = $(this), parent = _this.parent(), chart_container = parent.parent('.chart-container'), column_id,
                    last_chart,
                    chart = parent.prev('.chart'), copy = chart_container.parent().find('.chart.hidden').clone(), order;

            column_id = chart_container.attr('data-column_id');
            /*
             copy_selects.each(function () {
             value = $(this).find("option:first").val();
             $(this).val(value);
             });
             */
            last_chart = chart_container.find('.chart').last();
            if (last_chart.length) {
                order = last_chart.attr('data-order');
                order++;
            }
            else {
                order = 1;
            }
            copy.attr('data-order', order);
            copy.find("input[name=order]").val(order);
            copy.find("input[name=column_id]").val(column_id);
            parent.before(copy);

            copy.removeClass('hidden');
        });


        ApplyInputSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");

    };

    pagefunction();

</script>

