<?php require_once(public_path("smart/inc/init.php")); ?>

<!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-sm-12">

            <div class="bg-color-white padding-10 bordered" style="margin-bottom: 10px;">
                {!! Form::open(['method' => 'GET', 'url' => url("home/dashboard"), 'class' => 'form-inline']) !!}

                @if (env(MULTIPLE_AIRLINE))
                    <div class="form-group margin-right-13">
                        <label>@lang("content.airline")</label>
                        <div class="btn-group">
                            {!! Form::select('airline[]', $airlines, $selectedAirlines, ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'airline']) !!}
                        </div>
                    </div>
                @endif

                <div class="form-group margin-right-13">
                    <label>@lang("content.airport")</label>
                    <div class="btn-group">
                        {!! Form::select('airport[]', $airports, $selectedAirports, ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'airport']) !!}
                    </div>
                </div>

                <div class="form-group margin-right-13">
                    <label for="dateFrom">@lang("content.from")</label>
                    <div class="btn-group">
                        {!! Form::input('text', 'dateFrom', $dateFrom, ['class'=>'form-control input-sm date', "placeholder" => "Date From"]) !!}
                    </div>
                </div>
                <div class="form-group margin-right-13">
                    <label for="dateTo">@lang("content.to")</label>
                    <div class="btn-group">
                        {!! Form::input('text', 'dateTo',$dateTo, ['class'=>'form-control input-sm date', "placeholder" => "To"]) !!}
                    </div>
                </div>

                {!! Form::submit("Submit", ['name' => "submit", 'class' => "btn btn-primary"]) !!}

                {!! Form::close() !!}

            </div>

            @include("home.handling.punctuality-by-stations")

        </article>

        <div class="clearfix"></div>

        @if (env(MULTIPLE_AIRLINE))
            @include("home.handling.punctuality-by-airlines")
        @else
            @if (count($flightsByDelayCode))
                <article class="col-sm-12 col-md-12 col-lg-6">
                    {{--DELAY TABLE--}}
                    @include("report.layouts.punctuality-delay-table")
                </article>
            @endif
            @if (isset($flightsByDelayCodeChart["delay"]) && count($flightsByDelayCodeChart["delay"]))
                <article class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
                    {{--DELAY CHART--}}
                    @include("report.layouts.punctuality-delay-chart")
                </article>
            @endif
        @endif

        <div class="clearfix"></div>

        @include("home.handling.chart-pax-by-airport")

        @if (env(MULTIPLE_AIRLINE))
            <div class="clearfix"></div>

            @include("home.handling.chart-pax-by-airline")
        @endif

        {{--Airline Dashboard Tables--}}
        @if ($airlineModule)
            <div class="clearfix"></div>

            <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                @include("report.layouts.pax-flight-number-table")
            </article>

            @include("report.layouts.pax-sector-table")
        @endif
    </div>

</section>

<link rel="stylesheet" href="{{ asset("/assets/css/morris.css") }}"/>

<script type="text/javascript">

    pageSetUp();

    pagefunction = function(){

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#punctuality-by-station");

        ApplyTableFilter("#punctuality-by-airlines");

        var barOptions = GetChartJsBarOptions();

        // CHART PAX BY AIRPORT
        @if (count($paxByAirports["airport"]))
            var chartPaxByAirport = {
                labels: {!! json_encode($paxByAirports["airport"]) !!},
                datasets: [
                    {
                        label: "PAX (Departures)",
                        backgroundColor: "rgba(211,139,155,0.2)",
                        borderColor: "rgba(211,139,155,0.8)",
                        pointBackgroundColor: "rgba(211,139,155,1)",
                        pointBorderColor: "#fff",
                        pointHoverBackgroundColor: "#fff",
                        pointHoverBorderColor: "rgba(211,139,155,1)",
                        borderWidth: 2,
                        pointBorderWidth: 1,
                        pointRadius: 3,
                        data: {!! json_encode($paxByAirports[DEPARTURE]) !!}

                    },
                ]
            };

            var ctx1 = document.getElementById("chart_pax_by_airport").getContext("2d");
            new Chart(ctx1, {
                type: 'horizontalBar',
                data: chartPaxByAirport,
                options: barOptions
            });
        @endif
        // END CHART

        @if (count($paxBySectorMorris))
            var chartPaxBySector = {
                    labels: {!! json_encode($sectorLabels) !!},
                    datasets: [
                        {
                            // label: "PAX (Arrivals)",
                            backgroundColor: "rgba(211,139,155,0.2)",
                            borderColor: "rgba(211,139,155,0.8)",
                            pointBackgroundColor: "rgba(211,139,155,1)",
                            pointBorderColor: "#fff",
                            pointHoverBackgroundColor: "#fff",
                            pointHoverBorderColor: "rgba(211,139,155,1)",
                            borderWidth: 2,
                            pointBorderWidth: 1,
                            pointRadius: 3,
                            data: {!! json_encode($paxBySectorMorris) !!}

                        },
                    ]
                };

            var ctx1a = document.getElementById("chart_pax_by_sector").getContext("2d");
            new Chart(ctx1a, {
                type: 'bar',
                data: chartPaxBySector,
                options: barOptions
            });
        @endif

        @if (count($paxBySectorSFMorris))
            var chartPaxBySectorSF = {
                    labels: {!! json_encode($sectorLabels) !!},
                    datasets: [
                        {
                            // label: "PAX (Arrivals)",
                            backgroundColor: "rgba(68,148,210,0.2)",
                            borderColor: "rgba(68,148,210,0.8)",
                            pointBackgroundColor: "rgba(68,148,210,1)",
                            pointBorderColor: "#fff",
                            pointHoverBackgroundColor: "#fff",
                            pointHoverBorderColor: "rgba(68,148,210,1)",
                            borderWidth: 2,
                            pointBorderWidth: 1,
                            pointRadius: 3,
                            data: {!! json_encode($paxBySectorSFMorris) !!}

                        },
                    ]
                };

            var ctx1b = document.getElementById("chart_pax_by_sector_sf").getContext("2d");
            new Chart(ctx1b, {
                type: 'horizontalBar',
                data: chartPaxBySectorSF,
                options: barOptions
            });
        @endif

        // CHART PAX BY AIRLINE
         @if (env(MULTIPLE_AIRLINE) && count($paxByAirlines["airline"]))
             var chartPaxByAirline = {
                labels: {!! json_encode($paxByAirlines["airline"]) !!},
                datasets: [
                    {
                        label: "PAX (Arrivals)",
                        backgroundColor: "rgba(68,148,210,0.2)",
                        borderColor: "rgba(68,148,210,0.8)",
                        pointBackgroundColor: "rgba(68,148,210,1)",
                        pointBorderColor: "#fff",
                        pointHoverBackgroundColor: "#fff",
                        pointHoverBorderColor: "rgba(68,148,210,1)",
                        borderWidth: 2,
                        pointBorderWidth: 1,
                        pointRadius: 3,
                        data: {!! json_encode($paxByAirlines[ARRIVAL]) !!}

                    },
                    {
                        label: "PAX (Departures)",
                        backgroundColor: "rgba(211,139,155,0.2)",
                        borderColor: "rgba(211,139,155,0.8)",
                        pointBackgroundColor: "rgba(211,139,155,1)",
                        pointBorderColor: "#fff",
                        pointHoverBackgroundColor: "#fff",
                        pointHoverBorderColor: "rgba(211,139,155,1)",
                        borderWidth: 2,
                        pointBorderWidth: 1,
                        pointRadius: 3,
                        data: {!! json_encode($paxByAirlines[DEPARTURE]) !!}

                    },

                ]
            };

            var ctx2 = document.getElementById("chart_pax_by_airline").getContext("2d");
            new Chart(ctx2, {
                type: 'horizontalBar',
                data: chartPaxByAirline,
                options: barOptions
            });
        @endif

        // donut
        @if (isset($paxByAirportsMorris[TOTAL]))
            if ($('#chart_pax_by_station_totals').length){
                Morris.Donut({
                    element: 'chart_pax_by_station_totals',
                    data: {!! json_encode($paxByAirportsMorris[TOTAL]) !!},
                    formatter: function (x) { return x  } //+ "%"}
                });
            }
        @endif

         // donut
        @if (env(MULTIPLE_AIRLINE) && isset($paxByAirlinesMorris[TOTAL]))
            if ($('#chart_pax_by_airline_totals').length){
                Morris.Donut({
                    element: 'chart_pax_by_airline_totals',
                    data: {!! json_encode($paxByAirlinesMorris[TOTAL]) !!},
                    formatter: function (x) { return x  } //+ "%"}
                });
            }
        @endif

         // CHART DELAY
        @if (!env(MULTIPLE_AIRLINE) && isset($flightsByDelayCodeChart["delay"]) && count($flightsByDelayCodeChart["delay"]))

            var chartDelayData = {
                labels: {!! json_encode($flightsByDelayCodeChart["delay"]) !!},
                datasets: [
                    {
                    label: "Percentage",
                    backgroundColor: [
                        'rgba(0, 202, 14, 0.5)',
                        'rgba(149, 246, 153,0.5)',
                        'rgba(251, 147, 147,0.5)',
                        'rgba(250, 106, 106,0.5)',
                        'rgba(221, 0, 0,0.5)',

                        'rgba(5, 205, 11, 0.5)',
                        'rgba(150, 241, 13,0.5)',
                        'rgba(215, 147, 17,0.5)',
                        'rgba(185, 104, 16,0.5)',
                        'rgba(85, 10, 15,0.5)',

                        'rgba(11, 175, 4, 0.5)',
                        'rgba(34, 245, 3,0.5)',
                        'rgba(115, 17, 7,0.5)',
                        'rgba(158, 16, 6,0.5)',
                        'rgba(298, 5, 10,0.5)'
                    ],
                    hoverBackgroundColor: [
                        'rgba(0, 202, 14, 0.8)',
                        'rgba(149, 246, 153,0.8)',
                        'rgba(251, 147, 147,0.8)',
                        'rgba(250, 106, 106,0.8)',
                        'rgba(221, 0, 0,0.8)',

                        'rgba(5, 205, 11, 0.8)',
                        'rgba(150, 241, 13,0.8)',
                        'rgba(215, 147, 17,0.8)',
                        'rgba(185, 104, 16,0.8)',
                        'rgba(85, 10, 15,0.8)',

                        'rgba(11, 175, 4, 0.8)',
                        'rgba(34, 245, 3,0.8)',
                        'rgba(115, 17, 7,0.8)',
                        'rgba(158, 16, 6,0.8)',
                        'rgba(298, 5, 10,0.8)'
                    ],
                    borderColor: [
                        'rgba(0, 202, 14, 1)',
                        'rgba(149, 246, 153, 1)',
                        'rgba(251, 147, 147, 1)',
                        'rgba(250, 106, 106, 1)',
                        'rgba(221, 0, 0, 1)',

                        'rgba(5, 205, 11, 1)',
                        'rgba(150, 241, 13, 1)',
                        'rgba(215, 147, 17, 1)',
                        'rgba(185, 104, 16, 1)',
                        'rgba(85, 10, 15, 1)',

                        'rgba(11, 175, 4, 1)',
                        'rgba(34, 245, 3, 1)',
                        'rgba(115, 17, 7, 1)',
                        'rgba(158, 16, 6, 1)',
                        'rgba(298, 5, 10, 1)'
                    ],
                    borderWidth: 1,
                    data: {!! json_encode($flightsByDelayCodeChart["value"]) !!}
                    }
                ]
            };

            var ctx2 = document.getElementById("chart_delay").getContext("2d");
            myNewChart_2 = new Chart(ctx2, {
                type: 'doughnut',
                data: chartDelayData,
                options: {
                    legend: {
                        display: true,
                        labels: {
                            fontColor: 'rgb(255, 99, 132)'
                        }
                    }
                },
                animation:{
                    animateScale:false
                }
            });
        @endif
        // END CHART DELAY
    }

    loadScript("<?php echo ASSETS_URL; ?>/js/plugin/chartjs/chart.min.js", function () {
        loadScript("{{ asset("/assets/js/vendor/raphael-min.js") }}", function () {
            loadScript("{{ asset("/assets/js/vendor/morris.min.js") }}", pagefunction);
        });
    });

</script>




