<div class="col-md-12 no-padding margin-bottom-10">
    <a href="{{ route("homepage")."#". url("holiday/create#").rand(0, 1000) }}" class="btn btn-primary">@lang("content.add")</a>
    @if (isset($year) && $year)
        <a href="{{ route("homepage")."#". url("holiday/copy_for_next_year?year=").$year."#".rand(0, 1000) }}" class="btn btn-success">@lang("content.copy_for_next_year")</a>
    @endif
</div>

<div class="clearfix"></div>

@if (!count($data))
    <div class="alert alert-info" role="alert">
        <a href="#" class="alert-link">@lang("content.info")<br/></a>
        @lang("content.found") 0 @lang("content.records")
    </div>
@else
    <div class="jarviswidget jarviswidget-color-blueDark" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

        <header>
            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
            <h2>@lang("content.list")</h2>
        </header>

        <!-- widget div-->
        <div>

            <!-- widget edit box -->
            <div class="jarviswidget-editbox">
                <!-- This area used as dropdown edit box -->

            </div>
            <!-- end widget edit box -->

            <!-- widget content -->
            <div class="widget-body no-padding" style="min-height: 50px !important;">

                <div class="table-responsive editable_div" >

                    <table class="table table-bordered table-hover" style="min-width: 100%">
                        <thead>
                        <tr>
                            <th>No</th>
                            <th>@lang("content.name")</th>
{{--                            <th>@lang("content.abbr")</th>--}}
                            <th>@lang("content.date")</th>
                            <th>@lang("content.all_stations")</th>
{{--                            <th>@lang("content.notes")</th>--}}
                            <th data-center>@lang("content.created")</th>
                            <th data-center>@lang("content.updated")</th>
                            <th style="min-width: 140px;">@lang("content.actions")</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($data as $i => $each)
                            <tr>
                                <td data-center>{{ $i + 1 }}</td>
                                <td>{{ $each->name }}</td>
{{--                                <td>{{ $each->abbr }}</td>--}}
                                <td>{{ $each->fixed_date && $each->fixed_date != EMPTY_DATE ? date("d.m.Y", strtotime($each->fixed_date)) : "" }}</td>
                                <td class="text-center">
                                    @if ($each->all_stations)
                                        <i class="fa fa-check color-green"></i>
                                    @else
                                        @foreach($each->holidayAirports as $item)
                                            {{ $item->airport->iata }},
                                        @endforeach
                                    @endif
                                </td>
{{--                                <td>{{ $each->notes }}</td>--}}

                                <td>{{ date("Y-m-d", strtotime($each->created_at)) }}</td>
                                <td>{{ date("Y-m-d", strtotime($each->updated_at)) }}</td>
                                <td>
                                    @if (!$each->deleted_at)
                                        <div class="btn-group">
                                            <a target="_blank" href="{{ route("homepage")."#". url("holiday/{$each->id}/edit") }}" class="btn btn-warning">@lang("content.edit")</a>
                                            <a href="{{ route("homepage")."#". url("holiday/delete/{$each->id}") }}" class="btn btn-danger">@lang("content.delete")</a>
                                        </div>
                                    @endif
                                </td>
                            </tr>
                        @endforeach

                        </tbody>

                    </table>

                </div>

            </div>

        </div>

    </div>
@endif