<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <ul id="tabStations" class="nav nav-tabs bordered">
                <li class="active">
                    <a href="#all" role="tab" data-toggle="tab">@lang("content.all")</a>
                </li>

                @foreach(array_keys($byYears) as $each)
                    <li class="">
                        <a href="#y_{{ $each }}" role="tab" data-toggle="tab">{{ $each }}</a>
                    </li>
                @endforeach
            </ul>

            @php $active = 0 @endphp
            <div id="tabContent" class="tab-content padding-10 background-white">

                <div class="tab-pane active" id="all">
                    @include("holiday.layouts.index-holiday-tab", ["data" => $holidays])
                </div>

                @foreach($byYears as $year => $data)
                    <div class="tab-pane" id="y_{{ $year }}">
                        @include("holiday.layouts.index-holiday-tab", ["data" => $data, "year" => $year])
                    </div>
                @endforeach

            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter(".table");
    }

    pagefunction();

</script>