<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 */
{{--use App\Models\Module;--}}
{{--use App\Models\Department;--}}

{{--$modules = Module::with('permission')->get();--}}
{{--$homeModules = Module::where("department_id", "=", "0")->get();--}}
{{--$adminModules = Module::whereNull("department_id")->get();--}}
{{--$departments = Department::with(["module", "subDepartment"])->where("is_menu", true)->get();--}}

?>

<nav class="navbar navbar-default">
    <div class="container-fluid" id="navbar_div">
        <div class="navbar-header">
            <button type="button" class="navbar-toggle" data-toggle="collapse"
                    data-target="#bs-example-navbar-collapse-1">
                <span class="sr-only">Toggle navigation</span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
            </button>
        </div>

        <!-- Collect the nav links, forms, and other content for toggling -->
        <div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
            <ul class="nav navbar-nav">
                @if ( isset($auth) && is_object($auth) && $auth->check() && $auth->user()->user_access_type_id == 1)
                    <li class="dropdown">
                        <a href="{{ route("homepage") }}" {!! ($homeModules->count()) ? 'class="dropdown-toggle" data-toggle="dropdown"' : "" !!}>{{ trans("menu.home")  }} {!! ($homeModules->count()) ? '<span class="caret"></span>' : "" !!}</a>
                        @if ($homeModules->count())
                            <ul class="dropdown-menu">
                                @foreach ($homeModules as $homeModule)
                                    <li><a href="{{ url($homeModule->link) }}">{!! $homeModule->name !!}</a></li>
                                @endforeach
                            </ul>
                        @endif
                    </li>
                    <li class="dropdown">
                        <a href="#" class="dropdown-toggle" data-toggle="dropdown">{{ trans("menu.user")  }} <span
                                    class="caret"></span></a>
                        <ul class="dropdown-menu">
                            @if (checkIfCrew($auth->user()))
                                <li><a href="{{ url("/crew/profile?id=". $auth->user()->id) }}">{{ trans("menu.profile")  }}</a></li>
                            @else
                                <li><a href="{{ url("user/{$auth->user()->id}") }}">{{ trans("menu.profile")  }}</a></li>
                            @endif

                            <li><a href="{{ url("error/user-report") }}">{{ trans("menu.report_an_error")  }}</a></li>
                            <li><a href="{{ url("auth/logout") }}">{{ trans("menu.logout")  }}</a></li>

                        </ul>
                    </li>
                    @if (in_array($auth->user()->user_role_id, [SUPER_ADMIN, ROLE_ADMIN, ROLE_DEPARTMENT_ADMIN]))
                        <li class="dropdown">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">{{ trans("menu.admin")  }} <span
                                        class="caret"></span></a>
                            @if ($adminModules->count())
                                <ul class="dropdown-menu">
                                    @foreach ($adminModules as $adminModule)
                                        @if ($auth->user()->user_role_id == ROLE_DEPARTMENT_ADMIN && $adminModule->id == 17)
                                            @continue
                                        @endif
                                        <li>
                                            <a href="{{ url($adminModule->link) }}">{{ trans("menu.{$adminModule->lang}")  }}</a>
                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                        </li>
                    @endif

                    @if ($departments->count())
                        @foreach ($departments as $k => $department)
                            <li class="dropdown" {!!  $k == count($departments)-1 ? 'style="margin-right: 0"' : '' !!}>
                                <a href="#" class="dropdown-toggle" data-toggle="dropdown">{{ trans("menu.{$department->lang}")  }} <span class="caret"></span></a>

                                @php $maxPerColumn = 8 @endphp
                                @php $counter = 2 + $department->module->count() + ($department->has_subdepartment ? $department->subDepartment()->count() : 0) @endphp
                                @php $columns = ceil($counter / $maxPerColumn) @endphp
                                @php $colSplit = ceil(12 / $columns) @endphp
                                @php $count = 0 @endphp
                                <ul class="dropdown-menu {{ $counter > 7 ? 'multi-column columns-'.$columns : '' }}" role="menu">
                                    {{--<div class="row">--}}
                                    <div class="col-sm-{{ $colSplit }}" style="padding: 0">

                                        <ul class="multi-column-dropdown">
                                            @if ($department->module->count())
                                                @foreach ($department->module as $i => $module)
                                                    @php $count++; @endphp
                                                    {{--Check If User Has Permission to Access Modules--}}
                                                    @if (isset($userModules[$module->id]))
                                                        <li>
                                                            <a href="{{ url($module->link) }}">{{ trans("menu.{$module->lang}")  }}
                                                                @if (date("Y-m-d", strtotime(" + 3 days", strtotime($module->created_at))) >= date('Y-m-d') )
                                                                    <span class="label label-warning label-as-badge">New</span>
                                                                @endif
                                                            </a>
                                                        </li>
                                                    @endif

                                                    {{--@include('layouts.multiple-column-nav')--}}

                                                    @if ($count > 0 && ($count % $maxPerColumn) == 0 )
                                                    </ul>
                                                </div>
                                                <div class="col-sm-{{ $colSplit }}" style="padding: 0">
                                                    <ul class="multi-column-dropdown">
                                                        @endif

                                                        @endforeach
                                                        @endif
                                                        @if ($department->has_subdepartment)
                                                            @foreach($department->subDepartment as $subDepartment)
                                                                @php $count++; @endphp
                                                                <li>
                                                                    <a href="{{ url("department/employees?departmentId={$department->id}&subdepartmentId={$subDepartment->id}") }}">{{ trans("menu.{$subDepartment->lang}")  }}</a>
                                                                </li>

                                                                {{--@include('layouts.multiple-column-nav')--}}
                                                                @if ($count > 0 && ($count % $maxPerColumn) == 0 )
                                                    </ul>
                                                </div>
                                                <div class="col-sm-{{ $colSplit }}" style="padding: 0">
                                                    <ul class="multi-column-dropdown">
                                                        @endif

                                                        @endforeach
                                                        @endif
                                                        <li><a class="ajaxCall"
                                                               href="{{ url("department/employees?departmentId={$department->id}") }}">{{ trans("menu.employees")  }}</a>
                                                        </li>
                                                        @php $count++ @endphp
                                                        {{--@include('layouts.multiple-column-nav')--}}
                                                        @if ($count > 0 && ($count % $maxPerColumn) == 0 )
                                                    </ul>
                                                </div>
                                                <div class="col-sm-{{ $colSplit }}" style="padding: 0">
                                                    <ul class="multi-column-dropdown">
                                                        @endif

                                                        @if ($department->name == "CEO")
                                                            <li><a class="ajaxCall" href="{{ url("department/organization/{$department->id}?structure=A") }}">{{ trans("menu.structure_scope", ['name' => trans('page.directors')])  }}</a>
                                                            </li>
                                                            <li><a class="ajaxCall" href="{{ url("department/organization/{$department->id}?structure=B") }}">{{ trans("menu.structure_scope", ['name' => trans('page.all_direct_reportees')])  }}</a>
                                                            </li>
                                                        @endif

                                                        <li><a class="ajaxCall" href="{{ url("department/organization/{$department->id}") }}">{{ trans("menu.structure")  }}</a>
                                                        </li>
                                                        @php $count++ @endphp
                                                    </ul>
                                                </div>
                                                {{--</div>--}}
                                            </ul>
                                        </li>
                                    @endforeach
                                @endif


                    @php $user = $auth->user() @endphp
                    @php $picture = !is_null($user->thumb) ? '/storage/users/'.$user->thumb : '/assets/img/default-user-picture.png' @endphp
                    @php $currentLangSrc = getCurrentLanguageImgSrc() @endphp
                    @php $currentLocal = getCurrentLanguageLocale(true) @endphp
                    <li style="float: right; margin-left: 20px" class="text-right">

                        <!-- Split button -->
                        <div class="btn-group img-select" style="float: left; margin-top: 13px;">
                            <button style="color: white;" type="button"
                                    class="btn btn-transparent btn-sm  dropdown-toggle" data-toggle="dropdown"
                                    aria-haspopup="true" aria-expanded="false">
                                {{ $currentLocal }}
                            </button>
                            <ul class="dropdown-menu">
                                <li><a href="{{ route('lang.switch', "ru") }}">RU - {{ trans('menu.russian') }}</a></li>
                                <li><a href="{{ route('lang.switch', "en") }}">EN - English</a></li>
                            </ul>
                        </div>

                        {{--<a target="_blank" style="padding: 0; margin: 15px 0; float: left;" href="http://www.aviation-bis.com/login.php?key=1234adfoi24jlkvsd3$^$"><span class="label label-website">{{ trans('menu.website') }}</span></a>--}}
                        <a style="padding: 0; margin: 15px 20px; float: left;"
                           href="{!! \route("homepage")."#". url('fleetwatch/index') !!}"><span
                                    class="label label-fleetwatch">{{ trans('menu.fleetwatch') }}</span></a>
                        <a style="padding: 0; margin: 10px 0 0 0; float: left;"
                           href="{!! \route("homepage")."#". url("user/{$user->id}/edit?s=".rand(100, 999)) !!}"><img
                                    src="{!! $picture !!}"
                                    class="img-thumbnail thumb_report_prev"/></a>
                        <a style="padding: 0; margin: 15px; float: left;"
                           href="{!! \route("homepage")."#". url("auth/logout") !!}">{{ trans('menu.logout') }}</a>
                    </li>
                @endif
            </ul>
        </div>
    </div>
</nav>
