<?php

//initilize the page
require_once(public_path("smart/inc/init.php"));

//require UI configuration (nav, ribbon, etc.)
require_once(public_path("smart/inc/config.ui.php"));

include_once(public_path("smart/inc/user_variables.php"));


/*---------------- PHP Custom Scripts ---------

YOU CAN SET CONFIGURATION VARIABLES HERE BEFORE IT GOES TO NAV, RIBBON, ETC.
E.G. $page_title = "Custom Title" */

$page_title = "Flight Schedule Upload";

/* ---------------- END PHP Custom Scripts ------------- */

//include header
//you can add your custom css in $page_css array.
//Note: all css files are inside css/ folder
$page_css[] = "your_style.css";

$no_main_header = true;

$page_body_prop = array("id"=>"extr-page", "class"=>"animated fadeInDown");

include(public_path("smart/inc/header.php"));

?>


<!-- ==========================CONTENT STARTS HERE ========================== -->
<!-- possible classes: minified, no-right-panel, fixed-ribbon, fixed-header, fixed-width-->
<header id="header" class="no-padding" >
    <!--<span id="logo"></span>-->

    <div id="logo-group"  style="height: 60px; width: 100%; padding: 0 15px;" class="flightTrackerBackground">
        <h2 class="flightTracker color-white">Flight Schedule Upload</h2>
    {{--<span> <img style="max-height: 70px" src="{{ $logo }}"  alt="Aviation-BIS"> </span>--}}
    {{--        <h2><strong>{{ $logo_text }}</strong></h2>--}}
    <!-- END AJAX-DROPDOWN -->
    </div>

</header>

<div id="main" role="main">

    <!-- MAIN CONTENT -->
    <div id="content" class="">

        <!-- widget grid -->
        <section id="widget-grid" class="">

            <!-- row -->
            <div class="row">

                @include("template.flash-message")

                @php $iataCode = "" @endphp

                <div class="col-md-12">

                        {!! Form::open(["class" => "form-horizontal", 'method'=>'POST', 'files' => true]) !!}
                        {{--<div class="col-md-12">
                            <div class="form-group col-md-6">
                                <label class="col-md-4 control-label">Airlines</label>
                                <div class="col-md-8">
                                    {!! Form::select("airline_id", $airlines, \request("airline_id"), ["class"=>"form-control input-sm floatOnly", "id" => "airline_id"]) !!}
                                </div>
                            </div>
                        </div>--}}

                        <div class="col-md-12">
                            <div class="form-group col-md-6">
                                <label class="col-md-4 control-label">@lang("content.template_name")</label>
                                <div class="col-md-8">
                                    {!! Form::text("template_name", \request("template_name"), ["class"=>"form-control input-sm floatOnly", 'required']) !!}
                                </div>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group col-md-6">
                                <label class="col-md-4 control-label" for="timezone">@lang("content.timezone")</label>
                                <div class="col-sm-6">
                                    <label>{!! Form::select('timezone', getScheduleTimings(), null, ['class'=>'form-control']) !!}</label>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group col-md-6">
                                <label class="col-md-4 control-label" for="type">@lang("content.type")</label>
                                <div class="col-sm-6">
                                    <label>{!! Form::select('type', getTemplateTypes(), null, ['class'=>'form-control', 'required']) !!}</label>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group col-md-6">
                                <label class="col-md-4 control-label">@lang("content.excel_file")</label>
                                <div class="col-md-8">
                                    <input type="file" id="1" class="btn btn-default icon-file" name='file' required />
                                </div>
                            </div>
                        </div>

                        @if(env(MULTIPLE_AIRLINE))

        {{--                        <div class="col-md-12">--}}
        {{--                            <div class="form-group col-md-6">--}}
        {{--                                <label class="col-md-4 control-label color-blue" for="airline">@lang("content.airline")</label>--}}
        {{--                                <div class="col-sm-6">--}}
        {{--                                    <label>{!! Form::select('airline', $airlines, null, ['class'=>'form-control', 'id'=>'airline']) !!}</label>--}}
        {{--                                </div>--}}
        {{--                            </div>--}}
        {{--                        </div>--}}
                        <div class="" style="display: inline-block;border: 1px solid #1520b9;padding: 10px 0;width: 100%;">



                            <div class="col-md-12">
                                <div class="form-group col-md-12">
                                    <label class="col-md-2 control-label color-blue" for="remove_other_flights">@lang("content.remove_all_flights")*</label>
                                    <div class="col-md-10">
                                        <label>{!! Form::checkbox('remove_other_flights', 1, null, ['class'=>'form-control']) !!}</label>
                                        <label class="color-red">Remove all flights for the selected airline and selected airports if not found in the schedule</label>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group col-md-12">
                                    <label class="col-md-2 control-label color-blue" for="airport">@lang("content.airport")</label>
                                    <div class="col-sm-10">
                                        <label class="margin-bottom-10"> {!! Form::select('airport[]', $airports, [], ['multiple' => "multiple", 'class'=>'multiselect_search', 'id'=>'airport']) !!}</label>
                                        <label class="color-red"><strong>CAUTION</strong> Only select an airport if you require the selected airport/s schedule to be removed only and not all the airports</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endif


                        <div class="col-md-12">
                            <div class="form-group col-md-6">
                                <label class="col-md-4 control-label"></label>
                                <div class="col-md-8">
                                    <button type="submit" name="click" class="btn btn-primary">@lang("content.upload")</button>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-12" style="margin-top: 10px;">

                            <table class="table table-bordered table-hover">
                                <thead>
                                <tr>
                                    <th colspan="15">Type - FLT No
                                        {{--<label>{!! Form::radio("type", 1, null, ["class" => "margin-right-10", 'required']) !!}</label>--}}
                                    </th>
                                </tr>

                                <tr>
                                    <th class="color-red">@lang("content.flt_no")</th>
                                    <th class="color-red">@lang("content.eff_date")</th>
                                    <th>@lang("content.end_date")</th>
                                    <th>@lang("content.freq")(@lang("content.days"))</th>
                                    <th class="color-red">@lang("content.origin")</th>
                                    <th class="color-red">@lang("content.dep_time")(UTC)</th>
                                    <th class="color-red">@lang("content.destn")</th>
                                    <th class="color-red">@lang("content.arr_time")(UTC)</th>
                                    <th>@lang("content.ac_type")</th>
                                    <th data-center>@lang("content.ac")</th>
                                    <th data-center>CFG-C</th>
                                    <th data-center>CFG-Y</th>
                                    <th data-center>BKD-C</th>
                                    <th data-center>BKD-Y</th>
                                    <th data-center>@lang("content.notes")</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr>
                                    <td>IB1</td>
                                    <td>2023-01-01</td>
                                    <td>2023-03-31</td>
                                    <td>1234567</td>
                                    <td>AAA</td>
                                    <td>01:10</td>
                                    <td>BBB</td>
                                    <td>03:00</td>
                                    <td>{{ $iataCode }}320</td>
                                    <td>EC-ABC</td>
                                    <td>14</td>
                                    <td>160</td>
                                    <td>10</td>
                                    <td>120</td>
                                    <td>Ferry</td>
                                </tr>
                                <tr>
                                    <td>IB2</td>
                                    <td>2023-01-01</td>
                                    <td></td>
                                    <td></td>
                                    <td>BBB</td>
                                    <td>02:20</td>
                                    <td>CCC</td>
                                    <td>04:00</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                </tbody>
                            </table>

                        </div>

                        <div class="col-md-12" style="margin-top: 10px;">

                            <table class="table table-bordered table-hover">
                                <thead>
                                <tr>
                                    <th colspan="16">Type - Airline - FLT No
                                        {{--<label>{!! Form::radio("type", 2, null, ["class" => "margin-right-10", 'required']) !!}</label>--}}
                                    </th>
                                </tr>

                                <tr>
                                    <th class="color-red">@lang("content.airline")</th>
                                    <th class="color-red">@lang("content.flt_no")</th>
                                    <th class="color-red" style="min-width: 100px;">@lang("content.eff_date")</th>
                                    <th>@lang("content.end_date")</th>
                                    <th>@lang("content.freq")(@lang("content.days"))</th>
                                    <th class="color-red">@lang("content.origin")</th>
                                    <th class="color-red">@lang("content.dep_time")(UTC)</th>
                                    <th class="color-red">@lang("content.destn")</th>
                                    <th class="color-red">@lang("content.arr_time")(UTC)</th>
                                    <th>@lang("content.ac_type")</th>
                                    <th data-center>@lang("content.ac")</th>
                                    <th data-center>CFG-C</th>
                                    <th data-center>CFG-Y</th>
                                    <th data-center>BKD-C</th>
                                    <th data-center>BKD-Y</th>
                                    <th data-center>@lang("content.notes")</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr>
                                    <td>IB</td>
                                    <td>3</td>
                                    <td>2023-01-01</td>
                                    <td>2023-03-31</td>
                                    <td>357</td>
                                    <td>CCC</td>
                                    <td>01:10</td>
                                    <td>DDD</td>
                                    <td>03:00</td>
                                    <td>{{ $iataCode }}733</td>
                                    <td>EC-ABC</td>
                                    <td>16</td>
                                    <td>149</td>
                                    <td>12</td>
                                    <td>130</td>
                                    <td>FERRY</td>
                                </tr>
                                <tr>
                                    <td>IB</td>
                                    <td>1234</td>
                                    <td>2023-01-01</td>
                                    <td></td>
                                    <td></td>
                                    <td>DDD</td>
                                    <td>01:10</td>
                                    <td>EEE</td>
                                    <td>03:00</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                </tbody>
                            </table>

                        </div>


                        {!! Form::close() !!}

                    </div>

            </div>

        </section>

    </div>

</div>

<script type="text/javascript">
    var baseUrl = "{{ url('/') }}";
    var baseDashboardUrl = "{{ url('home/dashboard') }}";
    var baseHomeUrl = "{{ route("homepage")."#". url('/') }}";
    var AIRLINE = "{{ env("AIRLINE") }}";
    var CARRIER = "{{ env("CARRIER") }}";
    var CURRENT_IATA_CODE = "{{ env("IATA_CODE") }}";
</script>

<?php
//include required scripts
include(public_path("smart/inc/scripts.php"));
?>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        // ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

    };

    pagefunction();

</script>

