<div id="custom-delete-modal" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">
            {!! Form::open(['url' => url('operation/flight-schedule-flights/delete'), 'method' => "post", 'class' => 'form-horizontal', 'id' => 'modal-form']) !!}
            <div class="modal-header">
                {!! Form::hidden("schedule_id", $schedule->id) !!}
                {!! Form::hidden("airline_id", $airline->id) !!}
                {!! Form::hidden("id", null, ['id' => 'flight-schedule-flight-id']) !!}

                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title" id="modal_title">Delete Flights</h4>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <div class="col-md-6 col-md-offset-3" id="new_values">New Values</div>
                    <div class="col-md-3 previous">Previous Values</div>
                </div>
                <div class="form-group flight-number-group">
                    <label class="col-md-3 control-label">@lang("content.flight_number")</label>
                    <div class="col-md-6">
                        {!! Form::select("flight_number", $flightNumbers, null, ['class' => 'form-control singleselect_search', 'id' => 'flight_number']) !!}
                    </div>
                    <div class="col-md-3 previous">
                        {!! Form::text("flight_number_prev", null, ['class' => 'form-control', 'id' => 'flight_number_prev', 'disabled']) !!}
                    </div>
                </div>

                <div class="form-group add-flt-no-group">
                    <label for="add_flt_no" class="col-md-3 control-label">Add Flight Number</label>
                    <div class="col-md-6">
                        {!! Form::checkbox("add_flt_no", null, false, ['class' => 'form-control', 'id' => 'add_flt_no']) !!}
                    </div>
                </div>

                <div id="add-flt-no-container" style="display: none">
                    <div class="form-group">
                        <label class="col-md-3 control-label color-red">New Flight Number*</label>
                        <div class="col-md-6">
                            {!! Form::text("flt_no", null, ['class' => 'form-control', 'id' => 'flt_no']) !!}
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-3 control-label color-red">From/To*</label>
                        <div class="col-md-3">
                            {!! Form::text("departure_airport", null, ['class' => 'form-control', 'maxlength' => 3, 'id' => 'departure_airport']) !!}
                        </div>
                        <div class="col-md-3">
                            {!! Form::text("arrival_airport", null, ['class' => 'form-control', 'maxlength' => 3, 'id' => 'arrival_airport']) !!}
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label" id="eff_date_label">Effective Date</label>
                    <div class="col-md-6">
                        {!! Form::text("eff_date", null, ['class' => 'form-control date', 'required', 'id' => 'eff_date']) !!}
                    </div>
                    <div class="col-md-3 previous">
                        {!! Form::text("eff_date_prev", null, ['class' => 'form-control',  'id' => 'eff_date_prev', 'disabled']) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label" id="dis_date_label">Discontinue Date</label>
                    <div class="col-md-6">
                        {!! Form::text("dis_date", null, ['class' => 'form-control date', 'required', 'id' => 'dis_date']) !!}
                    </div>
                    <div class="col-md-3 previous">
                        {!! Form::text("dis_date_prev", null, ['class' => 'form-control', 'id' => 'dis_date_prev', 'disabled']) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label">@lang("content.frequency")</label>
                    <div class="col-md-6">
                        {!! Form::select("days[]", $weekDays, null, ['multiple'=>'multiple', 'class' => 'form-control multiselect', 'id' => 'days']) !!}
                    </div>
                    <div class="col-md-3 previous">
                        {!! Form::text("days_prev", null, ['class' => 'form-control', 'id' => 'days_prev', 'disabled']) !!}
                    </div>
                </div>
                <div class="" id="addition-edit-fields">
                    <div class="form-group">
                        <label class="col-md-3 control-label">Departure Time</label>
                        <div class="col-md-6">
                            {!! Form::text("dep_time", null, ['class' => 'form-control timepicker', 'required', 'id' => 'dep_time']) !!}
                        </div>
                        <div class="col-md-3 previous">
                            {!! Form::text("dep_time", null, ['class' => 'form-control', 'id' => 'dep_time_prev', 'disabled']) !!}
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-3 control-label">Arrival Time</label>
                        <div class="col-md-6">
                            {!! Form::text("arr_time", null, ['class' => 'form-control timepicker', 'required', 'id' => 'arr_time']) !!}
                        </div>
                        <div class="col-md-3 previous">
                            {!! Form::text("arr_time", null, ['class' => 'form-control', 'id' => 'arr_time_prev', 'disabled']) !!}
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-3 control-label">@lang("content.aircraft_type")</label>
                        <div class="col-md-6">
                            {!! Form::select("aircraft_type", $aircraftTypes, null, ['class' => 'form-control singleselect_search', 'id' => 'aircraft_type']) !!}
                        </div>
                        <div class="col-md-3 previous">
                            {!! Form::text("aircraft_type_prev", null, ['class' => 'form-control', 'id' => 'aircraft_type_prev', 'disabled']) !!}
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-3 control-label">@lang("content.aircraft")</label>
                        <div class="col-md-6">
                            {!! Form::select("aircraft", $aircraftList, null, ['class' => 'form-control singleselect_search', 'id' => 'aircraft']) !!}
                        </div>
                        <div class="col-md-3 previous">
                            {!! Form::text("aircraft_prev", null, ['class' => 'form-control', 'id' => 'aircraft_prev', 'disabled']) !!}
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="btn-group" id="create-group">
                    {!! Form::submit('Create', ['name' => 'create', 'class' => 'btn btn-success']) !!}
                    <button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>
                </div>
                <div class="btn-group" id="delete-group">
                    {!! Form::submit('Delete', ['name' => 'delete', 'class' => 'btn btn-danger']) !!}
                    <button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>
                </div>
                <div class="btn-group" id="edit-group">
                    {!! Form::submit('Save Changes', ['name' => 'edit', 'class' => 'btn btn-warning']) !!}
                    <button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>
                </div>
            </div>
            {!! Form::close() !!}
        </div>
    </div>
</div>