@if (count($list))

    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>
        <h2>@lang("content.list")</h2>
    </header>

    <!-- widget div-->
    <div>

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="min-height: 50px !important;">

            <div class="table-responsive">

                <table class="table table-bordered table-hover" id="flight-schedule-table" style="min-width: 100% !important;">
                    <thead>
                    <tr>
                        <th rowspan="2">No</th>
                        <th rowspan="2">@lang("content.template")</th>
                        @if (env(CARRIER) == HANDLING)
                            <th rowspan="2" style="max-width: 20%;">@lang("content.airlines")</th>
                        @endif
                        <th colspan="2">@lang("content.period")</th>
                        <th rowspan="2">@lang("content.created")</th>
                        <th colspan="2">@lang("content.last_updated")</th>
                        <th rowspan="2">@lang("content.status")</th>
                        <th rowspan="2">@lang("content.actions")</th>
                    </tr>

                    <tr>
                        <th style="min-width: 60px">@lang("content.from")</th>
                        <th style="min-width: 60px">@lang("content.to")</th>

                        <th>@lang("content.user")</th>
                        <th>@lang("content.date")</th>
                    </tr>

                    </thead>
                    <tbody>
                    @foreach($list as $i => $each)

                        <tr>
                            <td>{{ $i + 1 }}</td>
                            <td>
                                <a href="{{ route("homepage")."#".url("handling-flight-schedule-airlines/{$each->id}") }}">{{ $each->name }}</a>
                            </td>

                            @if (env(CARRIER) == HANDLING)
                            <td>
                                @foreach($each->airlines as $airline)
                                    @if($airline->airline)
                                        @php $picture = $airline->airline->picture ? asset("storage/airlines/img/{$airline->airline->picture}") : asset("/assets/img/default-airline-picture.png") @endphp
                                        <a href="{{ route("homepage")."#".url("handling-flight-schedule-flights/{$each->id}?airline_id={$airline->airline->id}") }}">
                                            <img class="flight-schedule-img"
                                                 src="{{ $picture }}"/>
                                        </a>
                                    @endif
                                @endforeach
                            </td>
                            @endif

                            <td>{{ baseDateFormat($each->date_from) }}</td>
                            <td>{{ baseDateFormat($each->date_to) }}</td>
                            <td>{{ baseDateFormat($each->created_at, true) }}</td>
                            <td>{{ $each->user ? $each->user->first_name." ".$each->user->last_name : "-" }}</td>
                            <td>{{ baseDateFormat($each->updated_at, true) }}</td>
                            <td>{!! $each->deleted_at ? "<span class='label label-danger'>".trans("content.removed")."</span>" : "" !!} </td>
                            <td>
                                <div class="btn-group">
                                    <a class="btn btn-danger" href="{{ route("homepage")."#".url("handling-flight-schedule/destroy/{$each->id}") }}">@lang("content.delete")</a>
                                    @if (Auth::user()->user_role_id == ROLE_SUPER_ADMIN || in_array(Auth::user()->id, [531]) )
                                        <button data-sch_id="{{ $each->id }}" class="btn btn-warning permanent_deletion">@lang("content.permanent_deletion")</button>

                                        {!! Form::text('delete_from', null, ['class'=>'form-control dateFrom delete_from', 'placeholder'=>'From']) !!}
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>

            </div>

        </div>
        <!-- end widget content -->

    </div>
    <!-- end widget div -->

</div>

@endif
