<?php
/**
 * Created by PhpStorm.
 * User: dimmer
 */
?>

<?php require_once(public_path("smart/inc/init.php")); ?>

<!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        @include("template.message")

        <article class="col-md-12">

            <div class="col-md-12 no-padding margin-bottom-10">
                <a href="{{ route("homepage")."#handling-flight-schedule/create?s=".rand(100, 999)}}" class="btn btn-primary">@lang("content.create_schedule")</a>
                <a target="_blank" href="{{ url("handling-flight-schedule-upload") }}" class="btn btn-success">@lang("content.upload_schedule")</a>
            </div>

            <div class="clearfix"></div>

            <ul id="tabStations" class="nav nav-tabs bordered">
                <li class="active">
                    <a href="#active" role="tab" data-toggle="tab">@lang("content.active")</a>
                </li>

                <li class="">
                    <a href="#inactive" role="tab" data-toggle="tab">@lang("content.inactive")</a>
                </li>

{{--                <li class="">--}}
{{--                    <a href="#inactive" role="tab" data-toggle="tab">@lang("content.airlines")</a>--}}
{{--                </li>--}}
            </ul>

            @php $active = 0 @endphp
            <div id="tabContent" class="tab-content padding-10 background-white">


                <div class="tab-pane active" id="active">
                    @include("handling-flight-schedule.schedule-list", ["list" => $schedules])
                </div>

                <div class="tab-pane" id="inactive">
                    @include("handling-flight-schedule.schedule-list", ["list" => $inactiveSchedules])
                </div>

{{--                <div class="tab-pane active" id="airlines">--}}
{{--                </div>--}}

            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter(".table");

        $(".permanent_deletion").on("click", function () {
            var _this = $(this), scheduleID = _this.data("sch_id"),
                _from = _this.next(".delete_from").val();


            var request = $.ajax({
                type: "GET",
                dataType: "json",
                url: baseUrl + "/fix/delete-schedule/" + scheduleID,
                data: {
                    date: _from,
                }
            });

            request.done(function (data) {
                alert(data.message);

                if (data.success){
                    location.reload();
                    return false;
                }
            });
        })

    };

    pagefunction();

</script>

