<?php
/**
 * Created by PhpStorm.
 * User: dimmer
 */
?>

<?php require_once(public_path("smart/inc/init.php")); ?>

<!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        @include("template.message")

        <article class="col-md-12" style="background-color: #ffffff;">
            @if ($airlineModule = airlineModule())
                @php $picture = getAirlineLogo(null, true) @endphp
            @else
                @php $picture = $airline && $airline->picture ? asset("storage/airlines/img/{$airline->picture}") : asset("/assets/img/default-airline-picture.png") @endphp
            @endif

            <img src="{{ $picture }}" style="max-height: 80px; padding: 10px;" />

            <div class="col-md-12" style="margin:10px 0 20px 0; padding: 0">
                <button type="button" class="btn btn-primary modal-action-btn" data-action="create"
                        data-url="{{ url('handling-flight-schedule-flights/create') }}"
                        data-toggle="modal" data-target="#custom-delete-modal">@lang("content.create_new_schedule")</button>
            </div>

            <div class="clearfix"></div>

            @php $active = 0 @endphp
            <ul id="tabStations" class="nav nav-tabs bordered">
            @foreach($groupedFlights as $station => $flights)
                <li class="{{ !$active++ ? "active" : "" }}"><a href="#{{ $station }}" role="tab" data-toggle="tab">{{ $station }}</a></li>
            @endforeach
            </ul>

            @php $active = 0 @endphp
            <div id="tabContent" class="tab-content padding-10" style="">
            @foreach($groupedFlights as $station => $flights)

                <div class="tab-pane {{ !$active++ ? "active" : "" }}" id="{{ $station }}">

                    <div class="col-md-12 form-inline" style="margin: 10px 0 20px 0">
                        <label class="control-label" style="margin-right: 20px">
                            {!! Form::checkbox("select_all", "1", false, ['class' => 'form-control select-all']) !!}
                            @lang("content.select_all")
                        </label>
                        @if ($station == "DELETED")
                            <button type="button" class="btn btn-success confirmation-modal-action-btn" data-action="restore-selected"
                                    data-url="{{ url("handling-flight-schedule-flights/restore-selected") }}"
                                    data-toggle="modal" data-target="#confirmation-modal">@lang("content.restore") @lang("content.selected_schedules")</button>
                        @else
                            <button type="button" class="btn btn-warning confirmation-modal-action-btn" data-action="delete-selected"
                                    data-url="{{ url("handling-flight-schedule-flights/delete-selected") }}"
                                    data-toggle="modal" data-target="#confirmation-modal">@lang("content.delete") @lang("content.selected_schedules")</button>
                        @endif
                    </div>

                    <div class="clearfix"></div>

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-{{ $station }}" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>@lang("content.schedule")</h2>
                        </header>

                        <!-- widget div-->
                        <div>

                            <!-- widget edit box -->
                            <div class="jarviswidget-editbox">
                                <!-- This area used as dropdown edit box -->

                            </div>
                            <!-- end widget edit box -->

                            <!-- widget content -->
                            <div class="widget-body no-padding" style="min-height: 50px !important;">

                                <div class="table-responsive">

                                    <table class="table table-bordered table-hover" id="table-{{ $station }}">
                                        <thead>
                                        <tr>
                                            <th rowspan="2">SEL</th>
                                            <th rowspan="2">NO</th>
                                            <th rowspan="2">@lang("content.flt_no")</th>
                                            <th rowspan="2">@lang("content.eff_date")</th>
                                            <th rowspan="2">@lang("content.end_date")</th>
                                            <th rowspan="2">@lang("content.freq") (@lang("content.days"))</th>
                                            <th rowspan="2">@lang("content.orgin")</th>
                                            <th rowspan="2">@lang("content.dep_time")(UTC)</th>
                                            <th rowspan="2">@lang("content.destn")</th>
                                            <th rowspan="2">@lang("content.arr_time")(UTC)</th>
                                            <th rowspan="2">@lang("content.ac_type")</th>
                                            <th rowspan="2">@lang("content.ac")</th>
                                            <th colspan="2">@lang("content.last_updated")</th>
                                            <th rowspan="2">@lang("content.actions")</th>

                                        </tr>
                                        <tr>
                                            <th>@lang("content.user")</th>
                                            <th>@lang("content.date")</th>
                                        </tr>

                                        </thead>
                                        <tbody>
                                            @foreach($flights as $i => $flight)
                                                @php $class = "" //$flight->deleted_at ? "color-white bg-color-red" : "" @endphp
                                                @php $flightNumber = $flight->flightNumber @endphp
                                                @php $flightNumberAirline = $flightNumber && $flightNumber->airline ? getAirlineCode($flightNumber->airline)."-" : "" @endphp
                                                @php $flightNumberAirline .= $flightNumber ? $flightNumber->flight_number : "-" @endphp

                                                @php $aircraftType = getFlightAircraftType($flight, false, true) @endphp
                                                @php $aircraft = getFlightAircraft($flight) @endphp

                                                @php $depTime = date("H:i", strtotime($flight->departure_time)) @endphp
                                                @php $arrTime = date("H:i", strtotime($flight->arrival_time)) @endphp
                                                <tr class="{{ $class }}" data-id="{{ $flight->id }}">
                                                    <td>
                                                        {!! Form::checkbox("selected", "1", false, ['class' => 'form-control flight', "data-id" => $flight->id ]) !!}
                                                    </td>
                                                    <td>{{ $i + 1 }}</td>
                                                    <td>{{ $flightNumberAirline }}</td>
                                                    <td>{{ $flight->effective_date }}</td>
                                                    <td>{{ $flight->discontinue_date }}</td>
                                                    <td>{{ $flight->days }}</td>
                                                    <td>{{ $flightNumber && $flightNumber->departureAirport ? $flightNumber->departureAirport->iata : "-" }}</td>
                                                    <td>{{ $depTime }}</td>
                                                    <td>{{ $flightNumber && $flightNumber->arrivalAirport ? $flightNumber->arrivalAirport->iata : "-" }}</td>
                                                    <td>{{ $arrTime }}</td>
                                                    <td>{{ $aircraftType }}</td>
                                                    <td>{{ $aircraft }}</td>
                                                    <td>{{ $flight->updated_by ? $flight->updatedBy->user_full_name : $flight->updated_by }}</td>
                                                    <td>{{ $flight->updated_at ? baseDateFormat($flight->updated_at, true) : ""}}</td>
                                                    <td>
                                                        <div class="btn-group">
                                                        @if ($flight->deleted_at)
                                                            <button type="button" class="btn btn-success confirmation-modal-action-btn" data-action="restore"
                                                                    data-url="{{ url("handling-flight-schedule-flights/restore/{$flight->id}") }}"
                                                                    data-toggle="modal" data-target="#confirmation-modal">@lang("content.restore_schedule")</button>
                                                        @else
                                                            <button type="button" class="btn btn-primary modal-action-btn"
                                                                    data-action="edit" data-id="{{ $flight->id }}" data-days="{{ $flight->days }}"

                                                                    data-aircraft_type="{{ $aircraftType }}"
                                                                    data-aircraft_type_id="{{ $flight->aircraft_type_id }}"
                                                                    data-aircraft="{{ $aircraft }}"
                                                                    data-aircraft_id="{{ $flight->aircraft_id }}"

                                                                    data-flight_number="{{ $flightNumber ? $flightNumber->flight_number : "-" }}"
                                                                    data-flight_number_id="{{ $flightNumber ? $flightNumber->id : null }}"
                                                                    data-dep_time="{{ $depTime }}" data-arr_time="{{ $arrTime }}"
                                                                    data-eff_date="{{ $flight->effective_date }}" data-dis_date="{{ $flight->discontinue_date }}"
                                                                    data-url="{{ url('handling-flight-schedule-flights/flights/edit') }}"
                                                                    data-toggle="modal" data-target="#custom-delete-modal">@lang("content.edit_schedule")</button>

                                                            <button type="button" class="btn btn-danger modal-action-btn"
                                                                    data-action="delete" data-id="{{ $flight->id }}" data-days="{{ $flight->days }}"

                                                                    data-aircraft_type="{{ $aircraftType }}"
                                                                    data-aircraft_type_id="{{ $flight->aircraft_type_id }}"
                                                                    data-aircraft="{{ $aircraft }}"
                                                                    data-aircraft_id="{{ $flight->aircraft_id }}"

                                                                    data-flight_number="{{ $flightNumber ? $flightNumber->flight_number : "-" }}"
                                                                    data-flight_number_id="{{ $flightNumber ? $flightNumber->id : null }}"
                                                                    data-dep_time="{{ $depTime }}" data-arr_time="{{ $arrTime }}"
                                                                    data-eff_date="{{ $flight->effective_date }}" data-dis_date="{{ $flight->discontinue_date }}"
                                                                    data-url="{{ url('handling-flight-schedule-flights/flights/delete') }}"
                                                                    data-toggle="modal" data-target="#custom-delete-modal">@lang("content.delete_flights")</button>

                                                            <button type="button" class="btn btn-warning confirmation-modal-action-btn" data-action="delete"
                                                                    data-url="{{ url("handling-flight-schedule-flights/delete/{$flight->id}") }}"
                                                                    data-toggle="modal" data-target="#confirmation-modal">@lang("content.delete_schedule")</button>
                                                        @endif
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>

                                </div>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>

                </div>
            @endforeach
            </div>

        </article>

    </div>

    {{--Modal CRUD FLIGHT--}}
    @include("handling-flight-schedule.templates.flight-crud")

    {{--Modal Confirmation--}}
    @include("handling-flight-schedule.templates.confirmation")


</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        @foreach($groupedFlights as $station => $flights)
            ApplyTableFilter("#table-{{ $station }}");
        @endforeach

        $('#confirmation-form').submit(function() {
            // Coding
            $('#confirmation-modal').modal('toggle');
            return false;
        });

        var confirmation_modal = $(document).find("#confirmation-modal"),
            tabContent = $(document).find("#tabContent"),
            confirmation_text = confirmation_modal.find(".confirmation-text"),
            flight_schedule_ids = confirmation_modal.find("#flight_schedule_ids");


        $(document).on("click", ".select-all:checkbox", function () {

            var selectAll = $(this).is(":checked"),
                active_tab = tabContent.find(".tab-pane.active"),
                checkboxes = active_tab.find(".flight:checkbox");

            $.each(checkboxes, function () {
                if (selectAll){
                    $(this).prop("checked", true);
                }
                else {
                    $(this).prop("checked", false);
                }
            });

        });

        $(document).on("click", ".confirmation-modal-action-btn", function () {
            var id = $(this).data('id'),
                url = $(this).data('url'),
                action = $(this).data('action'),
                active_tab = tabContent.find(".tab-pane.active"),
                selected_checkboxes = active_tab.find(".flight:checkbox:checked"),
                schedule_ids = ""
                ;

            $("#confirmation-form").attr("action", url);

            switch (action) {
                case "delete-selected":
                    confirmation_text.text("Are you sure you want to remove selected schedules?");
                    if (active_tab.length){

                        $.each(selected_checkboxes, function () {
                            schedule_ids += $(this).data("id").toString() + ","
                        });

                        flight_schedule_ids.val(schedule_ids);
                    }
                    break;
                case "restore-selected":
                    confirmation_text.text("Are you sure you want to restore selected schedules?");
                    if (active_tab.length){

                        $.each(selected_checkboxes, function () {
                            schedule_ids += $(this).data("id").toString() + ","
                        });

                        flight_schedule_ids.val(schedule_ids);
                    }
                    break;
                case "delete":
                    confirmation_text.text("Are you sure you want to remove the schedule?");
                    break;
                case "restore":
                    confirmation_text.text("Are you sure you want to restore the schedule?");
                    break;
            }
        });


        $('#modal-form').submit(function() {
            // Coding
            $('#custom-delete-modal').modal('toggle');
            return false;
        });

        var custom_delete_modal  = $(document).find("#custom-delete-modal"),
            additionalEditFields = custom_delete_modal.find("#addition-edit-fields"),
            aircraftTypeElement  = custom_delete_modal.find("#aircraft_type"),
            aircraftElement  = custom_delete_modal.find("#aircraft"),

            flightNumberElement  = custom_delete_modal.find("#flight_number"),
            create_group    = custom_delete_modal.find("#create-group"),
            edit_group      = custom_delete_modal.find("#edit-group"),
            delete_group    = custom_delete_modal.find("#delete-group"),
            modal_title     = custom_delete_modal.find("#modal_title"),
            daysElement     = custom_delete_modal.find("#days"),
            dis_date_label  = custom_delete_modal.find("#dis_date_label"),
            eff_date_label  = custom_delete_modal.find("#eff_date_label"),
            add_flt_no_container  = custom_delete_modal.find("#add-flt-no-container"),
            previous_fields = custom_delete_modal.find(".previous"),
            flt_no  = custom_delete_modal.find("#flt_no"),
            departure_airport  = custom_delete_modal.find("#departure_airport"),
            flight_number_group = custom_delete_modal.find(".flight-number-group"),
            new_values = custom_delete_modal.find("#new_values"),

            add_flt_no_group = custom_delete_modal.find(".add-flt-no-group"),
            arrival_airport  = custom_delete_modal.find("#arrival_airport");


        $(document).on("click", "#add_flt_no", function () {
            var _this = $(this);
            if (_this.is(":checked")){
                add_flt_no_container.show();
                flt_no.attr("required", "required");
                departure_airport.attr("required", "required");
                arrival_airport.attr("required", "required");
            }
            else {
                add_flt_no_container.hide();
                flt_no.removeAttr("required");
                departure_airport.removeAttr("required");
                arrival_airport.removeAttr("required");
            }
        });

        $(document).on("click", ".modal-action-btn", function () {
            var id = $(this).data('id'),
                effDate = $(this).data('eff_date'),
                disDate = $(this).data('dis_date'),
                depTime = $(this).data('dep_time'),
                arrTime = $(this).data('arr_time'),
                days = $(this).data('days'),
                aircraftType = $(this).data('aircraft_type'),
                aircraftTypeId = $(this).data('aircraft_type_id'),

                aircraft = $(this).data('aircraft'),
                aircraftId = $(this).data('aircraft_id'),

                flightNumber = $(this).data('flight_number'),
                flightNumberId = $(this).data('flight_number_id'),
                url = $(this).data('url'),
                action = $(this).data('action');

            $("#modal-form").attr("action", url);

            $("#flight-schedule-flight-id").val( id );

            $("#eff_date").val( effDate );
            $("#eff_date_prev").val( effDate );

            $("#dis_date").val( disDate );
            $("#dis_date_prev").val( disDate );

            $("#dep_time").val( depTime );
            $("#dep_time_prev").val( depTime );

            $("#arr_time").val( arrTime );
            $("#arr_time_prev").val( arrTime );

            flt_no.val("");
            departure_airport.val("");
            arrival_airport.val("");

            $("#flight_number_prev").val(flightNumber);

            flightNumberElement.val(flightNumberId);
            flightNumberElement.multiselect('refresh');

            $("#aircraft_type_prev").val(aircraftType);
            aircraftTypeElement.val(aircraftTypeId);
            aircraftTypeElement.multiselect('refresh');

            $("#aircraft_prev").val(aircraft);
            aircraftElement.val(aircraftId);
            aircraftElement.multiselect('refresh');

            $("#days_prev").val(days);
            $('option', daysElement).each(function() {
                daysElement.multiselect('deselect', $(this).val());
            });

            days = "" + days + "";
            for (var i = 0, len = days.length; i < len; i++) {
                $('option[value="' + days[i] + '"]', daysElement).prop('selected', true);
            }
            daysElement.multiselect('refresh');

            switch (action){
                case "create":
                    new_values.text("");
                    flight_number_group.show();
                    add_flt_no_group.show();
                    eff_date_label.text("Effective Date");
                    dis_date_label.text("Discontinue Date");
                    additionalEditFields.show();
                    previous_fields.hide();
                    modal_title.text("Create Flights");
                    create_group.show();
                    delete_group.hide();
                    edit_group.hide();
                    break;
                case "edit":
                    new_values.text("New Values");
                    flight_number_group.hide();
                    add_flt_no_group.hide();
                    eff_date_label.text("Effective Date");
                    dis_date_label.text("Discontinue Date");
                    additionalEditFields.show();
                    previous_fields.show();
                    modal_title.text("Edit Flights");
                    edit_group.show();
                    create_group.hide();
                    delete_group.hide();
                    break;
                case "delete":
                    new_values.text("New Values");
                    add_flt_no_group.hide();
                    flight_number_group.hide();
                    eff_date_label.text("Delete From");
                    dis_date_label.text("To");
                    additionalEditFields.hide();
                    previous_fields.show();
                    modal_title.text("Delete Flights");
                    delete_group.show();
                    create_group.hide();
                    edit_group.hide();
                    break;
            }
            // As pointed out in comments,
            // it is superfluous to have to manually call the modal.
            // $('#addBookDialog').modal('show');
        });

    };

    pagefunction();

</script>

