<?php
/**
 * Created by PhpStorm.
 * User: dimmer
 */
?>

<?php require_once(public_path("smart/inc/init.php")); ?>

<!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        @include("template.message")

        <article class="col-md-12">
            <!-- Widget ID (each widget will need unique ID)-->

            <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                <header>
                    <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                    <h2>{{ $schedule->name }}. Period ({{ baseDateFormatYear($schedule->date_from)." - ".baseDateFormatYear($schedule->date_to) }})</h2>
                </header>

                <!-- widget div-->
                <div>

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->

                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body no-padding" style="min-height: 50px !important;">

                        <div class="table-responsive">

                            <table class="table table-bordered table-hover">
                                <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Logo</th>
                                    <th>@lang("content.airline")</th>
                                    <th>IATA</th>
                                    <th>Flights</th>
                                </tr>

                                </thead>
                                <tbody>
                                    @if ($airlineModule = airlineModule())
                                        @php $logo = getAirlineLogo(null, true) @endphp
                                    @endif

                                    @foreach($schedule->airlines as $j => $flightAirline)
                                        @php $flights = $flightAirline->flights($schedule->id, $flightAirline->airline_id) @endphp
                                        @php $airline = $flightAirline->airline @endphp

                                        @php $picture = $airline && $airline->picture ? asset("storage/airlines/img/{$airline->picture}") : asset("/assets/img/default-airline-picture.png") @endphp

                                        <tr>
                                            <td>{{ $j + 1 }}</td>
                                            <td>
                                                <a href="{{ route("homepage")."#".url("handling-flight-schedule-flights/{$schedule->id}?airline_id={$airline->id}") }}">
                                                    @if ($airlineModule)
                                                        <img src="{{ $logo }}" style="max-height: 30px" />
                                                    @else
                                                        <img src="{{ $picture }}" style="max-height: 30px" />
                                                    @endif
                                                </a>
                                            </td>
                                            <td>
                                                <a href="{{ route("homepage")."#".url("handling-flight-schedule-flights/{$schedule->id}?airline_id={$airline->id}") }}">
                                                    {{ $airline ? $airline->airline : "-" }}
                                                </a>
                                            </td>
                                            <td>{{ $airline ? $airline->iata : "-" }}</td>
                                            <td>{{ $flights->count() }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>

                        </div>

                    </div>
                    <!-- end widget content -->

                </div>
                <!-- end widget div -->

            </div>
            <!-- end widget -->

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter(".table");
    };

    pagefunction();

</script>

