@extends($ajaxCall)

@section("content")

<ul class="breadcrumb">
  <li class="active">Forward Revenue</li>
  <li><a href="{!!route("homepage")."#". url("forwardrevenue/report")!!}">Revenue Reports</a></li>
  <li>{!! HTML::link('forwardrevenue/upload', 'Upload Revenue', array('id' => 'linkid'))!!} </li>
</ul>


<div style="margin: 10px 0;">
   <ul class="nav nav-pills">
   <?php $period_labels = array('Yearly', 'Quarterly', 'Monthly', 'Weekly', 'Weekdays', 'Daily'); ?>
   @foreach($period_labels as $index=>$value)
      <li @if($period == $index) class="active" @endif><a href="{!!route("homepage")."#". url("forwardrevenue/{$index}")!!}">{!!$value!!}</a></li>
   @endforeach
    </ul>
</div>


<div class="tabbable"> <!-- Only required for left/right tabs -->
  <ul class="nav nav-tabs">
    <li class="active"><a href="#tab1" data-toggle="tab">Analysis</a></li>
    <li><a href="#tab2" data-toggle="tab" id="graphs">Graphs</a></li>
  </ul>
  <div class="tab-content">
    <div class="tab-pane active" id="tab1">




<div style='margin-top: 20px; width: 100%'>

<table class="table text-center table-striped">

<tr>
    <th rowspan="2" class="text-center" style="vertical-align: middle">TOTAL NETWORK</th>
    <th colspan="3" class="text-center" style="vertical-align: middle">Fligths</th>
    <th colspan='6' class="text-center">@lang("content.outbound")</th>
    <th colspan='6' class="text-center">@lang("content.inbound")</th>
    <th colspan='6' class="text-center">@lang("content.total")</th>
{{--
    <th colspan='4' class="text-center">Revenue Outbound(USD)</th>
    <th colspan='4' class="text-center">Revenue Inbound(USD)</th>
    <th colspan='4' class="text-center">Revenue TOTAL(USD)</th>
--}}
</tr>

<tr>
    <th colspan="3" class="text-center">Capacity</th>
    <th colspan="2" class="text-center">@lang("content.business")</th>
    <th colspan="2" class="text-center">@lang("content.economy")</th>
    <th colspan="2" class="text-center">@lang("content.total")</th>
    <th colspan="2" class="text-center">@lang("content.business")</th>
    <th colspan="2" class="text-center">@lang("content.economy")</th>
    <th colspan="2" class="text-center">@lang("content.total")</th>
    <th colspan="2" class="text-center">@lang("content.business")</th>
    <th colspan="2" class="text-center">@lang("content.economy")</th>
    <th colspan="2" class="text-center">@lang("content.total")</th>
</tr>

<tr>
    <th class="text-center">@lang("content.departure_date")</th>
    <th class="text-center">No</th>
    <th class="text-center">C</th>
    <th class="text-center">Y</th>

    <th class="text-center">PAX</th>
    <th class="text-center">@lang("content.revenue")</th>
    <th class="text-center">PAX</th>
    <th class="text-center">@lang("content.revenue")</th>
    <th class="text-center">SF</th>
    <th class="text-center">Total Revenue</th>
    <th class="text-center">PAX</th>
    <th class="text-center">@lang("content.revenue")</th>
    <th class="text-center">PAX</th>
    <th class="text-center">@lang("content.revenue")</th>
    <th class="text-center">SF</th>
    <th class="text-center">Total Revenue</th>
    <th class="text-center">PAX</th>
    <th class="text-center">@lang("content.revenue")</th>
    <th class="text-center">PAX</th>
    <th class="text-center">@lang("content.revenue")</th>
    <th class="text-center">SF</th>
    <th class="text-center">Total Revenue</th>
{{--
    <th class="text-center">Y</th>
    <th class="text-center">SF</th>
    <th class="text-center">C</th>
    <th class="text-center">Y</th>
    <th class="text-center">SF</th>
    <th class="text-center">C</th>
    <th class="text-center">Y</th>
    <th class="text-center">Inf</th>
    <th class="text-center">Total</th>
    <th class="text-center">C</th>
    <th class="text-center">Y</th>
    <th class="text-center">Inf</th>
    <th class="text-center">Total</th>
    <th class="text-center">C</th>
    <th class="text-center">Y</th>
    <th class="text-center">Inf</th>
    <th class="text-center">Total</th>
--}}
</tr>

<?php


    class Graphs {
        public $data;
        public $title;
        public $div;
    }
    $graphs = array();

    $graphs[0] = new Graphs;
    $graphs[0]->data = "['Date', 'Outbound', 'Inbound', 'Total'], ";
    $graphs[0]->title = "Seat Factors (ETKT)";
    $graphs[0]->div = "chart_sf";

    $graphs[1] = new Graphs;
    $graphs[1]->data = "['Date', 'Business', 'Economy', 'Total'], ";
    $graphs[1]->title = "Revenue (ETKT)";
    $graphs[1]->div = "chart_revenue";


    $graphs[2] = new Graphs;
    $graphs[2]->data = "['Date', 'Outbound', 'Inbound', 'Total'], ";
    $graphs[2]->title = "Economy (ETKT)";
    $graphs[2]->div = "chart_economy";

    $graphs[3] = new Graphs;
    $graphs[3]->data = "['Date', 'Outbound', 'Inbound', 'Total'], ";
    $graphs[3]->title = "Business (ETKT)";
    $graphs[3]->div = "chart_business";

    $graphs[4] = new Graphs;
    $graphs[4]->data = "['Date', 'Outbound PAX', 'Inbound PAX', 'Total PAX', 'Revenue(x1000)'], ";
    $graphs[4]->title = "PAX/Revenue (ETKT)";
    $graphs[4]->div = "chart_pax_revenue";

    $weekday = array('Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun');
    $months = array(1 => "Jan", 2 => "Feb", 3 => "Mar", 4 => "Apr", 5 => "May", 6 => "Jun", 7 => "Jul", 8 => "Aug", 9 => "Sep", 10 => "Oct", 11 => "Nov", 12 => "Dec");


    if ($period == 3)
        $next_period = (int)$period + 2;
    if ($period == 2)
        $next_period = (int)$period + 3;
    else
        $next_period = (int)$period +1;

    $selected_year = date('Y', strtotime($date_from));



?>

@foreach($booked_flights as $index=>$each)

<?php



switch ($period){
        case 0:
            $selected_period = $each->date;
            $from = $each->date.'-01-01';
            $to = $each->date.'-12-31';
            break;
        case 1:
            $selected_period = "Quarter ".$each->date;
            $from = ForwardRevenueController::firstDayOf('quarter',null,$each->date,$selected_year);
            $to = ForwardRevenueController::lastDayOf('quarter',null,$each->date,$selected_year);
            break;
        case 2:
            $selected_period = $months[$each->date];
            $from = ForwardRevenueController::firstDayOf('month',null,$each->date,$selected_year);
            $to = ForwardRevenueController::lastDayOf('month',null,$each->date,$selected_year);
            break;
        case 3:
            $selected_period = "Week ".$each->date;
            $from = ForwardRevenueController::firstDayOf('week',null,$each->date,$selected_year);
            $to = ForwardRevenueController::lastDayOf('week',null,$each->date,$selected_year);
            break;
        case 4:
            $selected_period = $weekday[$each->date].", ".date('M d', strtotime("$date_from + $index days"));
            $from = ForwardRevenueController::firstDayOf('week',null,$each->date,$selected_year);
            $to = ForwardRevenueController::lastDayOf('week',null,$each->date,$selected_year);
          break;
        case 5:
            $selected_period = date('M d, Y', strtotime($each->date));
             $from = $each->date;
            break;
        case 6:
            $selected_period = date('M d, Y', strtotime($each->date));
            break;
        default:
            $selected_period = $each->date;
    }


    if ($period < 4)
        $href =route("homepage")."#". url("forwardrevenue/$next_period/$from/$to");
    else if ($period == 5)
        $href = route("homepage")."#". url("forwardrevenue/$from");
    else
        $href = '#';

    $revenue_out_total = $each->revenue_out_c + $each->revenue_out_y;
    $revenue_in_total = $each->revenue_in_c + $each->revenue_in_y;

    $revenue_c_total = $each->revenue_out_c + $each->revenue_in_c;
    $revenue_y_total = $each->revenue_out_y + $each->revenue_in_y;
    $revenue_total = $revenue_c_total + $revenue_y_total;

    $pax_out_total = $each->pax_out_c + $each->pax_out_y;
    $pax_in_total = $each->pax_in_c + $each->pax_in_y;
    $pax_total = $pax_out_total + $pax_in_total;

    $pax_c_total = $each->pax_out_c + $each->pax_in_c;
    $pax_y_total = $each->pax_out_y + $each->pax_in_y;

   $sf_out = ($flights_config[$index]->config_out != 0) ? number_format(100*$pax_out_total/$flights_config[$index]->config_out) : 0;
    $sf_in = ($flights_config[$index]->config_in != 0) ? number_format(100*$pax_in_total/$flights_config[$index]->config_in) : 0;
    $sf_total = ($flights_config[$index]->config_total != 0) ? number_format(100*$pax_total/$flights_config[$index]->config_total) : 0;
    $graphs[0]->data .= "['".$selected_period."', ".$sf_out.", ".$sf_in.", ".$sf_total."], ";
    $graphs[1]->data .= "['".$selected_period."', ".round($revenue_c_total).", ".round($revenue_y_total).", ".round($revenue_total)."], ";
    $graphs[2]->data .= "['".$selected_period."', ".round($revenue_out_total).", ".round($revenue_in_total).", ".round($revenue_total)."], ";
    $graphs[4]->data .= "['".$selected_period."', ".round($pax_out_total).", ".round($pax_in_total).", ".round($pax_total).", ".round($revenue_total/1000)."], ";


?>

    <tr>
        <td><a href="{!!$href!!}">{!!$selected_period!!}</a></td>
        <td>{!!$flights_config[$index]->flight_count!!}</td>

        <td>{!!$flights_config[$index]->config_c!!}</td>
        <td>{!!number_format($flights_config[$index]->config_y)!!}</td>

        <td>{!!number_format($each->pax_out_c)!!}</td>
        <td>{!!number_format(round($each->revenue_out_c))!!}</td>
        <td>{!!number_format($each->pax_out_y)!!}</td>
        <td>{!!number_format(round($each->revenue_out_y))!!}</td>
        <td>{!!$sf_out!!} %</td>
        <td>{!!number_format(round($revenue_out_total))!!}</td>

        <td>{!!number_format($each->pax_in_c)!!}</td>
        <td>{!!number_format(round($each->revenue_in_c))!!}</td>
        <td>{!!number_format($each->pax_in_y)!!}</td>
        <td>{!!number_format(round($each->revenue_in_y))!!}</td>
        <td>{!!$sf_in!!} %</td>
        <td>{!!number_format(round($revenue_in_total))!!}</td>

        <td>{!!number_format($pax_c_total)!!}</td>
        <td>{!!number_format(round($revenue_c_total))!!}</td>
        <td>{!!number_format($pax_y_total)!!}</td>
        <td>{!!number_format(round($revenue_y_total))!!}</td>
        <td>{!!$sf_total!!} %</td>
        <td>{!!number_format(round($revenue_total))!!}</td>


    </tr>
@endforeach



</table>
</div>

    </div>
    <div class="tab-pane" id="tab2" style="padding:0">
        <div class="col-lg-6" id="chart_pax_revenue" style="padding: 0; height: 400px; width: 50%"></div>
        <div class="col-lg-6" id="chart_revenue" style="padding: 0; height: 400px; width: 50%"></div>
        <div class="col-lg-6" id="chart_sf" style="padding: 0; height: 400px; width: 50%"></div>
        <div class="col-lg-6" id="chart_economy" style="padding: 0; height: 400px; width: 50%"></div>
    </div>
  </div>
</div>





@stop


@section("js_scripts")
<script type="text/javascript" src="https://www.google.com/jsapi"></script>

{{--<script type="text/javascript">
    google.load("visualization", "1", {packages:["corechart"]});
    google.setOnLoadCallback(function() { drawChart([{!!$graphs[0]->data!!}], "{!!$graphs[0]->title!!}", "{!!$graphs[0]->div!!}");});
    google.setOnLoadCallback(function() { drawChart([{!!$graphs[1]->data!!}], "{!!$graphs[1]->title!!}", "{!!$graphs[1]->div!!}");});
    google.setOnLoadCallback(function() { drawChart([{!!$graphs[2]->data!!}], "{!!$graphs[2]->title!!}", "{!!$graphs[2]->div!!}");});
    google.setOnLoadCallback(function() { drawComboChart([{!!$graphs[4]->data!!}], "{!!$graphs[4]->title!!}", "{!!$graphs[4]->div!!}");});

    function drawChart(graph_data, graph_title, graph_div) {

        var data = google.visualization.arrayToDataTable(
          graph_data
        );

        var options = {
            title: graph_title,
            colors:['#0024ff','#ff0000', '#25891a', '#df5f00'],
            titleTextStyle: {color: 'black', fontName: 'Verdana', fontSize: 16},
            curveType: 'function',
            vAxis: {
                gridlines: {count: -1}
            },
            hAxis: {
                slantedText: true,
                slantedTextAngle: 70,
                textStyle: {color: 'black', fontName: 'Verdana', fontSize: 12},
                title: "",
                titleTextStyle: {color: 'black', fontName: 'Verdana', fontSize: 9, italic: 0}
            },
            chartArea: {left:80, top:50,width:'80%', height: '70%'},
            height:380,
            width: 900,
            legend: {
                position: 'right',
                textStyle: {color: 'black', bold: 1, fontSize: 12}
            }
            };

        var chart = new google.visualization.LineChart(document.getElementById(graph_div));

        chart.draw(data, options);
    }

    function drawComboChart(graph_data, graph_title, graph_div) {
      // Some raw data (not necessarily accurate)
        console.log(graph_data);
      var data = google.visualization.arrayToDataTable(
        graph_data
      );

      var options = {
        title : graph_title,
        titleTextStyle: {color: 'black', fontName: 'Verdana', fontSize: 16},
        colors:['#0024ff','#ff0000', '#25891a', '#df5f00'],
        seriesType: "bars",
        series: {3: {type: "line"!!},
        curveType:'function',
        chartArea: {left:80, top:50,width:'80%', height: '70%'},
        height:380,
        width: 900,
        legend: {
            position: 'right',
            textStyle: {color: 'black', bold: 1, fontSize: 12}
        }
      };

      var chart = new google.visualization.ComboChart(document.getElementById(graph_div));
      chart.draw(data, options);
    }

</script>--}}
<script src="/assets/js/views/forwardrevenue/index.js"></script>
@stop