<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => 'Forward Revenue', 'moduleName' => date('d M, Y', strtotime(\request("date_from"))).' >> Flight No.'. \request("flight_number")])

            <div class="tabbable">
                <ul class="nav nav-tabs">
                    <div class="liner"></div>
                    <li class="active">
                        <a href="#tab1" data-toggle="tab" title="welcome">
                            <i class="glyphicon glyphicon-home"></i>
                            <span class="tabText">Analysis</span>
                        </a>
                    </li>

                    {{--<li>--}}
                        {{--<a href="#tab2" data-toggle="tab" title="welcome">--}}
                            {{--<i class="glyphicon glyphicon-home"></i>--}}
                            {{--<span class="tabText">Graphs</span>--}}
                        {{--</a>--}}
                    {{--</li>--}}
                </ul>

                <div class="tab-content padding-10 background-white">

                    <div class="tab-pane active" id="tab1">

                        @include('forwardrevenue/form_period')

                        <div style='margin-top: 20px;'>

                            @php $data1 = ""; $data2 = ""; @endphp

                            @if (count($finalData))
                                <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-10" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
                                    <!-- widget options:
                                    usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                                    data-widget-colorbutton="false"
                                    data-widget-editbutton="false"
                                    data-widget-togglebutton="false"
                                    data-widget-deletebutton="false"
                                    data-widget-fullscreenbutton="false"
                                    data-widget-custombutton="false"
                                    data-widget-collapsed="true"
                                    data-widget-sortable="false"

                                    -->
                                    <header>
                                        <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                                        <h2>@lang("content.list") </h2>

                                    </header>

                                    <!-- widget div-->
                                    <div>

                                        <!-- widget edit box -->
                                        <div class="jarviswidget-editbox">
                                            <!-- This area used as dropdown edit box -->

                                        </div>
                                        <!-- end widget edit box -->

                                        <!-- widget content -->
                                        <div class="widget-body no-padding" style="overflow: auto">

                                            <table class="tablesorter table table-bordered table-striped table-hover">
                                                <thead>
                                                <tr>
                                                    <th>Flight: {{ env("IATA_CODE") ."-". $flightNumber }}</th>
                                                    <th class="text-center">Departure Date: {{ date("M d, Y", strtotime($date)) }}</th>
                                                    <th colspan="2" class="text-center">Capacity</th>
                                                    <th colspan="2" class="text-center">@lang("content.business")</th>
                                                    <th colspan="2" class="text-center">@lang("content.economy")</th>
                                                    <th colspan="2" class="text-center">@lang("content.total")</th>
                                                </tr>

                                                <tr>
                                                    <th class="text-center">№</th>
                                                    <th class="text-center">@lang("content.sales_date")</th>
                                                    <th class="text-center">C</th>
                                                    <th class="text-center">Y</th>

                                                    <th class="text-center">PAX</th>
                                                    <th class="text-center">@lang("content.revenue")</th>
                                                    <th class="text-center">PAX</th>
                                                    <th class="text-center">@lang("content.revenue")</th>
                                                    <th class="text-center">PAX</th>
                                                    <th class="text-center">@lang("content.revenue")</th>
                                                   {{-- <th class="text-center">SF</th>--}}

                                                </tr>
                                                </thead>
                                                <tbody>

                                                <?php

                                                    foreach($finalData as $index => $each) {
                                                        $pax_c = isset($pax_c) ? $pax_c + $each->pax_c : $each->pax_c;
                                                        $pax_y = isset($pax_y) ? $pax_y + $each->pax_y : $each->pax_y;

                                                        $revenue_c = isset($revenue_c) ? $revenue_c + $each->revenue_c : $each->revenue_c;
                                                        $revenue_y = isset($revenue_y) ? $revenue_y + $each->revenue_y : $each->revenue_y;
                                                        ///$sf = ($each->pax_c + $each->pax_y)*100/($finalData[0]->config_c + $finalData[0]->config_y);

                                                        $data1[] = [date('M d, Y', strtotime($each->sales_date)), round($each->revenue_c), round($each->revenue_y), round($each->revenue_c + $each->revenue_y)];
                                                        $data2[] = [date('M d, Y', strtotime($each->sales_date)), round($each->pax_c), round($each->pax_y), round($each->pax_c + $each->pax_y)];
                                                    ?>

                                                    <tr>
                                                        <td>{!!$index+1!!}</td>
                                                        <td>{{ $each->sales_date }}</td>
                                                        <td>@if($index == 0 && isset($finalData[0]->config_c)) {!!$finalData[0]->config_c!!} @endif</td>
                                                        <td>@if($index == 0 && isset($finalData[0]->config_y)) {!!$finalData[0]->config_y!!} @endif</td>
                                                        <td>{!!$each->pax_c!!}</td>
                                                        <td>{!!number_format(round($each->revenue_c))!!}</td>
                                                        <td>{!!$each->pax_y!!}</td>
                                                        <td>{!!number_format(round($each->revenue_y))!!}</td>
                                                        <td>{!!$each->pax_c + $each->pax_y!!}</td>
                                                        <td>{!!number_format(round($each->revenue_c + $each->revenue_y))!!}</td>
                                                        {{--<td>{!!round($sf)!!}</td>--}}
                                                    </tr>

                                                <?php }

                                                //$sf_total = ($pax_c + $pax_y)*100/($finalData[0]->config_c + $finalData[0]->config_y); ////
                                                ?>


                                                <tr>
                                                    <td></td>
                                                    <td>@lang("content.total")</td>
                                                    <td>{{ isset($finalData[0]->config_c) ? $finalData[0]->config_c : "" }}</td>
                                                    <td>{{ isset($finalData[0]->config_y) ? $finalData[0]->config_y : "" }}</td>
                                                    <td>{!!$pax_c!!}</td>
                                                    <td>{!!number_format(round($revenue_c))!!}</td>
                                                    <td>{!!$pax_y!!}</td>
                                                    <td>{!!number_format(round($revenue_y))!!}</td>
                                                    <td>{!!$pax_c + $pax_y!!}</td>
                                                    <td>{!!number_format(round($revenue_c + $revenue_y))!!}</td>
                                                    {{--<td>{!!round($sf_total)!!}</td>--}}
                                                </tr>

                                                </tbody>

                                            </table>

                                        </div>

                                    </div>

                                </div>

                            @endif

                        </div>

                    </div>

                    {{--Graphs Tab Content--}}
                    <div class="tab-pane" id="tab2">
                        <div class="chart_container">
                            <div class="google_chart" style="height: 350px;" id="chart_pax_revenue"></div>
                            <div class="google_chart" style="height: 350px;" id="chart_revenue"></div>
                        </div>
                    </div>

                </div>

            </div>

            <?php
                $graphs[0] = new \App\Classes\Graph("Revenue (ETKT)", "chart_revenue", ['Date', 'Business', 'Economy', 'Total'], $data1);
                $graphs[1] = new \App\Classes\Graph("PAX (ETKT)", "chart_pax_revenue", ['Date', 'PAX C', 'PAX Y', 'Total PAX'], $data2);
            ?>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function () {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter(".table");

    };

    //    loadScript("https://www.google.com/jsapi", function() {
    loadScript("{{ asset("/assets/js/views/forwardrevenue/flightDaily.js") }}", pagefunction);
    //    });

</script>