<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => 'Forward Revenue', 'moduleName' => date('d M, Y', strtotime(\request("date_from")))])

            <div class="tabbable"> <!-- Only required for left/right tabs -->

                <ul class="nav nav-tabs">
                    <div class="liner"></div>
                    <li class="active">
                        <a href="#tab1" data-toggle="tab" title="welcome">
                            <i class="glyphicon glyphicon-home"></i>
                            <span class="tabText">Analysis</span>
                        </a>
                    </li>
                    {{--<li>--}}
                        {{--<a href="#tab2" data-toggle="tab" title="welcome">--}}
                            {{--<i class="glyphicon glyphicon-home"></i>--}}
                            {{--<span class="tabText">Graphs</span>--}}
                        {{--</a>--}}
                    {{--</li>--}}
                </ul>

                <div class="tab-content padding-10 background-white">

                    <div class="tab-pane active" id="tab1">

                        @include('forwardrevenue/form_period')

                        <div class="margin-top-10">

                            @if (count($finalData))

                                <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-10" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
                                    <!-- widget options:
                                    usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                                    data-widget-colorbutton="false"
                                    data-widget-editbutton="false"
                                    data-widget-togglebutton="false"
                                    data-widget-deletebutton="false"
                                    data-widget-fullscreenbutton="false"
                                    data-widget-custombutton="false"
                                    data-widget-collapsed="true"
                                    data-widget-sortable="false"

                                    -->
                                    <header>
                                        <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                                        <h2>@lang("content.list") </h2>

                                    </header>

                                    <!-- widget div-->
                                    <div>

                                        <!-- widget edit box -->
                                        <div class="jarviswidget-editbox">
                                            <!-- This area used as dropdown edit box -->

                                        </div>
                                        <!-- end widget edit box -->

                                        <!-- widget content -->
                                        <div class="widget-body no-padding" style="overflow: auto">

                                            <table id="flightTable" class="table table-striped table-bordered table-hover">
                                                <thead>
                                                <tr>
                                                    <th rowspan="2" class="text-center">№</th>
                                                    <th rowspan="2" class="text-center">@lang("content.flight")</th>
                                                    <th colspan="2" class="text-center">Capacity</th>
                                                    <th colspan="2" class="text-center">@lang("content.business")</th>
                                                    <th colspan="2" class="text-center">@lang("content.economy")</th>
                                                    <th colspan="3" class="text-center">@lang("content.total")</th>
                                                </tr>

                                                <tr>

                                                    <th class="text-center">C</th>
                                                    <th class="text-center">Y</th>

                                                    <th class="text-center">PAX</th>
                                                    <th class="text-center">@lang("content.revenue")</th>
                                                    <th class="text-center">PAX</th>
                                                    <th class="text-center">@lang("content.revenue")</th>
                                                    <th class="text-center">PAX</th>
                                                    <th class="text-center">@lang("content.revenue")</th>
                                                    <th class="text-center">SF</th>
                                                </tr>
                                                </thead>
                                                <tbody>

                                                <?php
                                                $data1 = ""; $data2 = "";$pax_c_total = 0; $pax_y_total = 0;

                                                foreach($finalData as $index => $each){

                                                switch ($period) {
                                                    case 5:
                                                        $selected_period = date('M d, Y', strtotime($each->date));
                                                        $from = $each->date;
                                                        $to = $each->date;
                                                        break;
                                                    case 6:
                                                        $selected_period = $each->date;
                                                        break;
                                                    default:
                                                        $selected_period = $each->date;
                                                }
                                                $pax_c = $each->pax_out_c + $each->pax_in_c;
                                                $pax_y = $each->pax_out_y + $each->pax_in_y;

                                                $pax_c_total = isset($pax_c_total) ? $pax_c_total + $pax_c : $pax_c;
                                                $pax_y_total = isset($pax_y_total) ? $pax_y_total + $pax_y : $pax_y;

                                                $revenue_c = $each->revenue_out_c + $each->revenue_in_c;
                                                $revenue_y = $each->revenue_out_y + $each->revenue_in_y;

                                                $revenue_c_total = isset($revenue_c_total) ? $revenue_c_total + $revenue_c : $revenue_c;
                                                $revenue_y_total = isset($revenue_y_total) ? $revenue_y_total + $revenue_y : $revenue_y;

                                                $flight_config_c = isset($each->config_c) ? $each->config_c : 0;
                                                $flight_config_y = isset($each->config_y) ? $each->config_y : 0;

                                                $flight_config_c_total = isset($flight_config_c_total) ? $flight_config_c_total + $flight_config_c : $flight_config_c;
                                                $flight_config_y_total = isset($flight_config_y_total) ? $flight_config_y_total + $flight_config_y : $flight_config_y;

                                                if ($flight_config_c + $flight_config_y != 0)
                                                    $sf = round(($pax_c + $pax_y) * 100 / ($flight_config_c + $flight_config_y));
                                                else
                                                    $sf = 'N/A';

                                                //$graphs[0]->data .= "['".$selected_period."', ".$sf_out.", ".$sf_in.", ".$sf_total."], ";
                                                $data1[] = ["$selected_period", round($revenue_c), round($revenue_y), round($revenue_c + $revenue_y)];
                                                //$graphs[1]->data .= "['".$selected_period."', ".round($revenue_out_total).", ".round($revenue_in_total).", ".round($revenue_total)."], ";
                                                $data2[] = ["$selected_period", round($pax_c), round($pax_y), round($pax_c + $pax_y), round(($revenue_c + $revenue_y) / 1000)];

                                                ?>
                                                <tr>
                                                    <td>{!!$index+1!!}</td>
                                                    <td>@if(isset($each->departure_date))
                                                            <a href="{!!route("homepage")."#". url("forwardrevenue/flightdailysales?period=7&date_from=$each->departure_date&to_date=$each->departure_date&flight_number=$each->date")!!}" style="color: red">
                                                                {{ $each->flight_departure }}
                                                            </a>
                                                        @else
                                                            <a href="{!!route("homepage")."#". url("forwardrevenue/flightdailysales?period=7&date_from=$dateFrom&to_date=$dateTo&flight_number=$each->date")!!}" style="color: red">
                                                                {{ $each->date }}
                                                            </a>
                                                        @endif
                                                    </td>

                                                    <td>{{ $flight_config_c }}</td>
                                                    <td>{{ $flight_config_y }}</td>
                                                    <td>{{ $pax_c }}</td>
                                                    <td>{{ number_format(round($revenue_c)) }}</td>
                                                    <td>{{ $pax_y }}</td>
                                                    <td>{{ number_format(round($revenue_y)) }}</td>
                                                    <td>{{ $pax_c + $pax_y }}</td>
                                                    <td>{{ number_format(round($revenue_c + $revenue_y)) }}</td>
                                                    <td>{{ $sf }}</td>
                                                </tr>

                                                <?php
                                                }

                                                $sf_total = 'N/A';
                                                if ($flight_config_c_total + $flight_config_y_total != 0)
                                                    $sf_total = round(($pax_c_total + $pax_y_total) * 100 / ($flight_config_c_total + $flight_config_y_total));
                                                ?>

                                                <tr>
                                                    <td class="text-center"></td>
                                                    <td class="text-center">@lang("content.total")</td>
                                                    <td>{{ $flight_config_c_total }}</td>
                                                    <td>{{ $flight_config_y_total }}</td>
                                                    <td>{{ $pax_c_total }}</td>
                                                    <td>{{ number_format(round($revenue_c_total)) }}</td>
                                                    <td>{{ $pax_y_total }}</td>
                                                    <td>{{ number_format(round($revenue_y_total)) }}</td>
                                                    <td>{{ $pax_c_total + $pax_y_total }}</td>
                                                    <td>{{ number_format(round($revenue_c_total + $revenue_y_total)) }}</td>
                                                    <td>{{ $sf_total }}</td>
                                                </tr>
                                                </tbody>
                                            </table>

                                        </div>

                                    </div>

                                </div>

                                <?php
                                $graphs = [];
                                $graphs[0] = new \App\Classes\Graph("Revenue (ETKT)", "chart_revenue", ['Date', 'Business', 'Economy', 'Total'], $data1);
                                $graphs[1] = new \App\Classes\Graph("PAX/Revenue (ETKT)", "chart_pax_revenue", ['Date', 'PAX C', 'PAX Y', 'Total PAX', 'Revenue(x1000)'], $data2);
                                ?>

                            @endif

                        </div>


                    </div>
                    {{--Graphs Tab Content--}}
                    <div class="tab-pane" id="tab2">
                        <div class="chart_container">
                            <div class="google_chart" style="height: 350px;" id="chart_pax_revenue"></div>
                            <div class="google_chart" style="height: 350px;" id="chart_revenue"></div>
                        </div>
                    </div>

                </div>

            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function () {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter(".table");

    };

//    loadScript("https://www.google.com/jsapi", function() {
        loadScript("{{ asset("/assets/js/views/forwardrevenue/flightDaily.js") }}", pagefunction);
//    });

</script>