<?php require_once(public_path("smart/inc/init.php")); ?>

@php $j = 1 @endphp
<!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('forwardbooking.form', ['from' => $date, 'to' => $date])
        </article>

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
            <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-2" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
                <!-- widget options:
                usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                data-widget-colorbutton="false"
                data-widget-editbutton="false"
                data-widget-togglebutton="false"
                data-widget-deletebutton="false"
                data-widget-fullscreenbutton="false"
                data-widget-custombutton="false"
                data-widget-collapsed="true"
                data-widget-sortable="false"

                -->
                <header>
                    <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                    <h2>Daily Report</h2>

                </header>

                <!-- widget div-->
                <div>

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->

                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body no-padding">

                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-hover" id="reportTable">
                                <thead>
                                <tr>
                                    <th colspan="7" class="text-center">Total ({!!date('M d, Y', strtotime($date))!!})
                                    </th>
                                    <th colspan="6" class="text-center">@lang("content.outbound")</th>
                                    <th colspan="6" class="text-center">@lang("content.inbound")</th>
                                </tr>
                                <tr>
                                    <th rowspan="2">@lang("content.route")</th>
                                    <th rowspan="2">A/C</th>
                                    <th colspan="2">@lang("content.config")</th>
                                    <th colspan="2">PAX</th>
                                    <th rowspan="2">SF</th>

                                    <th rowspan="2">@lang("content.flight_number")</th>
                                    <th colspan="2">@lang("content.config")</th>
                                    <th colspan="2">Pax</th>
                                    <th rowspan="2">SF</th>

                                    <th rowspan="2">@lang("content.flight_number")</th>
                                    <th colspan="2">@lang("content.config")</th>
                                    <th colspan="2">PAX</th>
                                    <th rowspan="2">SF</th>
                                </tr>
                                <tr>
                                    <th>C</th>
                                    <th>Y</th>
                                    <th>C</th>
                                    <th>Y</th>

                                    <th>C</th>
                                    <th>Y</th>
                                    <th>C</th>
                                    <th>Y</th>

                                    <th>C</th>
                                    <th>Y</th>
                                    <th>C</th>
                                    <th>Y</th>
                                </tr>
                                </thead>

                                <tbody>

                                @php $chartSF = ["date" => [], "outbound" => [], "inbound" => [], "total" => []] @endphp

                                @foreach($flights as $flight)
                                    <tr>
                                        @php $flightNumbers = $flight->flightNumber->flight_number @endphp

                                        @php $flightIds = [ $flight->id ] @endphp

                                        @if ($flight->flightChild)
                                            @php $flightIds[] = $flight->flightChild->id @endphp
                                            @php $flightNumbers .= '/'.$flight->flightChild->flightNumber->flight_number @endphp
                                        @endif

                                        @php $url = 'flt_ids[]=' . implode('&amp;flt_ids[]=', array_map('urlencode', $flightIds)); @endphp

                                        <td>
                                            <a href="{{ route("homepage")."#".url("forwardbooking/report-by-flight?date={$date}&{$url}")}}">{{ $flightNumbers }}</a>
                                        </td>

                                        <td>{{ $flight->aircraft->name }}</td>
                                        <td>{{ $flight->capacity_c_total }}</td>
                                        <td>{{ $flight->capacity_y_total }}</td>
                                        <td>{{ $flight->pax_c_total }}</td>
                                        <td>{{ $flight->pax_y_total }}</td>
                                        <td>{{ $flight->sf_total }}%</td>
                                        <td>{{ $flight->flightNumber->flight_number }}</td>
                                        <td>{{ $flight->capacity_c }}</td>
                                        <td>{{ $flight->capacity_y }}</td>
                                        @if ($flight->pax_c_actual || $flight->pax_y_actual)
                                            <td class="pax_actual">{{ $flight->pax_c_actual }}</td>
                                            <td class="pax_actual">{{ $flight->pax_y_actual }}</td>
                                        @else
                                            <td>{{ $flight->pax_c_booked }}</td>
                                            <td>{{ $flight->pax_y_booked }}</td>
                                        @endif
                                        <td>{{ $flight->sf }}%</td>

                                        @php $sf_inbound = 0 @endphp

                                        @if ($flight->flightChild)
                                            @php $flightChild = $flight->flightChild @endphp
                                            <td>{{ $flightChild->flightNumber->flight_number }}</td>
                                            <td>{{ $flightChild->capacity_c }}</td>
                                            <td>{{ $flightChild->capacity_y }}</td>
                                            @if ($flightChild->pax_c_actual || $flightChild->pax_y_actual)
                                                <td class="pax_actual">{{ $flightChild->pax_c_actual }}</td>
                                                <td class="pax_actual">{{ $flightChild->pax_y_actual }}</td>
                                            @else
                                                <td>{{ $flightChild->pax_c_booked }}</td>
                                                <td>{{ $flightChild->pax_y_booked }}</td>
                                            @endif
                                            <td>{{ $flightChild->sf }}%</td>
                                            @php $sf_inbound = $flightChild->sf @endphp
                                        @else
                                            <td class="no_inbound"></td>
                                            <td class="no_inbound"></td>
                                            <td class="no_inbound"></td>
                                            <td class="no_inbound"></td>
                                            <td class="no_inbound"></td>
                                            <td class="no_inbound"></td>
                                        @endif

                                        @php $chartSF["flight_number"][] = $flightNumbers @endphp
                                        @php $chartSF["sf_inbound"][] = $sf_inbound @endphp
                                        @php $chartSF["sf_outbound"][] = $flight->sf @endphp
                                        @php $chartSF["sf_total"][] = $flight->sf_total @endphp
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>

            <h4 class="col-md-12" style="margin: 0 0 15px 0; padding: 0">
                <span class="crewroster_item"><span class="flight_color pax_actual"></span> PAX ACT</span>
                <span class="crewroster_item"><span class="flight_color no_inbound"></span> No Inbound Flight</span>
            </h4>

        </article>

        <article class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
            <!-- Widget ID (each widget will need unique ID)-->
            <div class="jarviswidget" id="wid-chart-id-chart-1"
                 data-widget-fullscreenbutton="false" data-widget-editbutton="false"
                 data-widget-sortable="false">
                <!-- widget options:
                    usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    data-widget-colorbutton="false"
                    data-widget-editbutton="false"
                    data-widget-togglebutton="false"
                    data-widget-deletebutton="false"
                    data-widget-fullscreenbutton="false"
                    data-widget-custombutton="false"
                    data-widget-collapsed="true"
                    data-widget-sortable="false"

                -->
                <header>
                    <h2>@lang("content.seat_factors")</h2>
                </header>

                <!-- widget div-->
                <div>

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->
                        <input class="form-control" type="text">
                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body">
                        <!-- this is what the user will see -->
                        <canvas id="chart_sf" style="height: 150px;"></canvas>
                    </div>
                    <!-- end widget content -->

                </div>
                <!-- end widget div -->

            </div>
        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function () {

        ApplyFormSubmit();

        ApplyTableFilter("#reportTable");

        ApplyValidationDateFormats();

        Apply_Multiselect();

        var lineOptions = GetChartJsLineOptions();

        // Chart PAX/REVENUE
        var chartSFData = {
            labels: {!! json_encode($chartSF["flight_number"]) !!},
            datasets: [
                {
                    label: "PAX (Outbound)",
                    backgroundColor: "rgba(211,139,155,0.2)",
                    borderColor: "rgba(211,139,155,0.8)",
                    pointBackgroundColor: "rgba(211,139,155,1)",
                    pointBorderColor: "#fff",
                    pointHoverBackgroundColor: "#fff",
                    pointHoverBorderColor: "rgba(211,139,155,1)",
                    borderWidth: 2,
                    pointBorderWidth: 1,
                    pointRadius: 3,
                    data: {!! json_encode($chartSF["sf_outbound"]) !!}



                },
                {
                    label: "PAX (Inbound)",
                    backgroundColor: "rgba(68,148,210,0.2)",
                    borderColor: "rgba(68,148,210,0.8)",
                    pointBackgroundColor: "rgba(68,148,210,1)",
                    pointBorderColor: "#fff",
                    pointHoverBackgroundColor: "#fff",
                    pointHoverBorderColor: "rgba(68,148,210,1)",
                    borderWidth: 2,
                    pointBorderWidth: 1,
                    pointRadius: 3,
                    data: {!! json_encode($chartSF["sf_inbound"]) !!}



                }
                , {
                    label: "PAX Total",
                    backgroundColor: "rgba(51,127,105,0.2)",
                    borderColor: "rgba(51,127,105,0.8)",
                    pointBackgroundColor: "rgba(51,127,105,1)",
                    pointBorderColor: "#fff",
                    pointHoverBackgroundColor: "#fff",
                    pointHoverBorderColor: "rgba(51,127,105,1)",
                    borderWidth: 2,
                    pointBorderWidth: 1,
                    pointRadius: 3,
                    data: {!! json_encode($chartSF["sf_total"]) !!}



                }
            ]
        };

        var ctx1 = document.getElementById("chart_sf").getContext("2d");
        myNewChart_1 = new Chart(ctx1, {
            type: 'bar',
            data: chartSFData,
            options: lineOptions
        });

        // END CHART PAX/REVENUE
    };

    loadScript("<?php echo ASSETS_URL; ?>/js/plugin/chartjs/chart.min.js", pagefunction);

</script>


