<?php require_once(public_path("smart/inc/init.php")); ?>

@php $j = 1 @endphp

<!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('forwardbooking.form')

        </article>

        <article class="col-xs-12 col-sm-12 col-md-6 col-lg-6">

            <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-2" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
                <!-- widget options:
                usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                data-widget-colorbutton="false"
                data-widget-editbutton="false"
                data-widget-togglebutton="false"
                data-widget-deletebutton="false"
                data-widget-fullscreenbutton="false"
                data-widget-custombutton="false"
                data-widget-collapsed="true"
                data-widget-sortable="false"

                -->
                <header>
                    <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                    <h2>Daily Report</h2>

                </header>

                <!-- widget div-->
                <div>

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->

                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body no-padding">

                        <div class="table-responsive">

                            @php $chart = ["date" => [], "pax_outbound" => [], "pax_inbound" => []] @endphp

                            <table class="table table-striped table-bordered table-hover" style="margin-top: 5px;">
                                <thead>
                                <tr>
                                    <th colspan="4" class="text-center">PAX (Departure
                                        Date: {{ date('M d, Y', strtotime($date))}})
                                    </th>
                                    @foreach($flight_numbers as $i=>$flt_no)
                                        <th colspan="2" class="text-center">{{ $CURRENT_IATA_CODE." ".$flt_no}}</th>
                                    @endforeach
                                </tr>
                                <tr>
                                    <th rowspan="2">Updated Date</th>
                                    <th rowspan="2">A/C</th>
                                    <th colspan="2">@lang("content.config")</th>
                                    <th colspan="2">PAX</th>
                                    @if (count($flight_numbers) > 1)
                                        <th colspan="2">PAX</th>
                                    @endif
                                </tr>
                                <tr>
                                    <th>C</th>
                                    <th>Y</th>

                                    <th>C</th>
                                    <th>Y</th>

                                    @if (count($flight_numbers) > 1)
                                        <th>C</th>
                                        <th>Y</th>
                                    @endif
                                </tr>
                                </thead>

                                <tbody>
                                @forelse($route as $date => $flights)
                                    <tr>
                                        @php $j = 0 @endphp
                                        @foreach($flights as $flight)

                                            @if ($j == 0)
                                                <td>{{$flight['updated_date']}}</td>
                                                <td>{{$flight['aircraft']['name']}}</td>
                                                <td>{{$flight['flight']['capacity_c']}}</td>
                                                <td>{{$flight['flight']['capacity_y']}}</td>
                                            @endif

                                            <td>{{ $flight['pax_c_booked'] }}</td>
                                            <td>{{ $flight['pax_y_booked'] }}</td>

                                            @if ($j == 0)
                                                @php $chart["date"][] = $flight['updated_date'] @endphp
                                                @php $chart["pax_outbound"][] = $flight['pax_c_booked'] + $flight['pax_y_booked'] @endphp
                                            @else
                                                @php $chart["pax_inbound"][] = $flight['pax_c_booked'] + $flight['pax_y_booked'] @endphp
                                            @endif


                                            @php $j++ @endphp
                                        @endforeach
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="10">Flight History Is Empty For This Flight</td>
                                    </tr>
                                @endforelse
                                </tbody>
                            </table>

                        </div>

                    </div>

                </div>

            </div>

        </article>

        <article class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
            <!-- Widget ID (each widget will need unique ID)-->
            <div class="jarviswidget" id="wid-chart-id-chart-1"
                 data-widget-fullscreenbutton="false" data-widget-editbutton="false"
                 data-widget-sortable="false">
                <!-- widget options:
                    usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    data-widget-colorbutton="false"
                    data-widget-editbutton="false"
                    data-widget-togglebutton="false"
                    data-widget-deletebutton="false"
                    data-widget-fullscreenbutton="false"
                    data-widget-custombutton="false"
                    data-widget-collapsed="true"
                    data-widget-sortable="false"

                -->
                <header>
                    <h2>PAX</h2>
                </header>

                <!-- widget div-->
                <div>

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->
                        <input class="form-control" type="text">
                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body">
                        <!-- this is what the user will see -->
                        <canvas id="chart_pax"></canvas>
                    </div>
                    <!-- end widget content -->

                </div>
                <!-- end widget div -->

            </div>
        </article>

    </div>

</section>

<?php

$chart["date"] = array_reverse($chart["date"]);
$chart["pax_outbound"] = array_reverse($chart["pax_outbound"]);
$chart["pax_inbound"] = array_reverse($chart["pax_inbound"]);
?>



{{-- JS scripts section --}}



<script type="text/javascript">

    pageSetUp();

    var pagefunction = function () {

        ApplyFormSubmit();

        ApplyTableFilter("#reportTable");

        ApplyValidationDateFormats();

        Apply_Multiselect();

        var lineOptions = GetChartJsLineOptions();

        // Chart PAX/REVENUE
        var chartData = {
            labels: {!! json_encode($chart["date"]) !!},
            datasets: [
                {
                    label: "PAX (Outbound)",
                    backgroundColor: "rgba(211,139,155,0.2)",
                    borderColor: "rgba(211,139,155,0.8)",
                    pointBackgroundColor: "rgba(211,139,155,1)",
                    pointBorderColor: "#fff",
                    pointHoverBackgroundColor: "#fff",
                    pointHoverBorderColor: "rgba(211,139,155,1)",
                    borderWidth: 2,
                    pointBorderWidth: 1,
                    pointRadius: 3,
                    data: {!! json_encode($chart["pax_outbound"]) !!}



                },
                {
                    label: "PAX (Inbound)",
                    backgroundColor: "rgba(68,148,210,0.2)",
                    borderColor: "rgba(68,148,210,0.8)",
                    pointBackgroundColor: "rgba(68,148,210,1)",
                    pointBorderColor: "#fff",
                    pointHoverBackgroundColor: "#fff",
                    pointHoverBorderColor: "rgba(68,148,210,1)",
                    borderWidth: 2,
                    pointBorderWidth: 1,
                    pointRadius: 3,
                    data: {!! json_encode($chart["pax_inbound"]) !!}



                }
            ]
        };

        var ctx1 = document.getElementById("chart_pax").getContext("2d");
        myNewChart_1 = new Chart(ctx1, {
            type: 'line',
            data: chartData,
            options: lineOptions
        });

        // END CHART PAX/REVENUE
    };

    loadScript("<?php echo ASSETS_URL; ?>/js/plugin/chartjs/chart.min.js", pagefunction);

</script>


