<?php require_once(public_path("smart/inc/init.php")); ?>

@php $j = 1 @endphp

<!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
            @include('forwardbooking.form')
        </article>

        @if (count($groupedFlights))
            <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                <!-- Widget ID (each widget will need unique ID)-->
                <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-2" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
                    <!-- widget options:
                    usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    data-widget-colorbutton="false"
                    data-widget-editbutton="false"
                    data-widget-togglebutton="false"
                    data-widget-deletebutton="false"
                    data-widget-fullscreenbutton="false"
                    data-widget-custombutton="false"
                    data-widget-collapsed="true"
                    data-widget-sortable="false"

                    -->
                    <header>
                        <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                        <h2>@lang("content.daily_report")</h2>

                    </header>

                    <!-- widget div-->
                    <div>

                        <!-- widget edit box -->
                        <div class="jarviswidget-editbox">
                            <!-- This area used as dropdown edit box -->

                        </div>
                        <!-- end widget edit box -->

                        <!-- widget content -->
                        <div class="widget-body no-padding">

                            <div class="table-responsive">
                                <table class="table table-striped table-bordered table-hover" id="reportTable"
                                       style="margin-top: 5px;">
                                    <thead>
                                    <tr>
                                        <th rowspan="3" class="text-center">No</th>
                                        <th rowspan="3" class="text-center">@lang("content.departure_date")</th>
                                        <th colspan="5" class="text-center outbound">@lang("content.outbound")</th>
                                        <th colspan="5" class="text-center inbound">@lang("content.inbound")</th>
                                        <th colspan="5" class="text-center total">@lang("content.total")</th>
                                    </tr>
                                    <tr>
                                        <th colspan="2" class="text-center">@lang("content.capacity")</th>
                                        <th colspan="2" class="text-center">PAX</th>
                                        <th rowspan="2" class="text-center">SF</th>

                                        <th colspan="2" class="text-center">@lang("content.capacity")</th>
                                        <th colspan="2" class="text-center">PAX</th>
                                        <th rowspan="2" class="text-center">SF</th>

                                        <th colspan="2" class="text-center">@lang("content.capacity")</th>
                                        <th colspan="2" class="text-center">PAX</th>
                                        <th rowspan="2" class="text-center">SF</th>
                                    </tr>
                                    <tr>
                                        <th>C</th>
                                        <th>Y</th>
                                        <th>C</th>
                                        <th>Y</th>

                                        <th>C</th>
                                        <th>Y</th>
                                        <th>C</th>
                                        <th>Y</th>

                                        <th>C</th>
                                        <th>Y</th>
                                        <th>C</th>
                                        <th>Y</th>
                                    </tr>
                                    </thead>

                                    @php $chartSF = $chartPax = ["date" => [], "outbound" => [], "inbound" => [], "total" => []] @endphp
                                    @php $i = 1 @endphp

                                    <tbody>
                                    @forelse($groupedFlights as $date => $flight)
                                        <tr>
                                            <td>{!! $i++ !!}</td>
                                            @if (count($sectors))
                                                @php $url = '' @endphp
                                                @foreach($sectors as $sector)
                                                    @php $url .= "flight_number[] =".$sector."&" @endphp
                                                @endforeach
                                                <td class="nowrap">
                                                    <a href="{{ route("homepage")."#".url("forwardbooking/report-by-flight?date={$date}&{$url}") }}">{!! $date !!}</a>
                                                </td>
                                            @else
                                                <td class="nowrap">
                                                    <a href="{{ route("homepage")."#".url("forwardbooking/report-daily?date={$date}") }}">{!! $date !!}</a>
                                                </td>
                                            @endif

                                            @php $chartSF["date"][] = $date; @endphp
                                            @php $chartPax["date"][] = $date; @endphp

                                            @foreach($flight as $type => $each)
                                                <td>{!! $each['capacity']['c'] !!}</td>
                                                <td>{!! $each['capacity']['y'] !!}</td>
                                                <td>{!! $each['pax']['c'] !!}</td>
                                                <td>{!! $each['pax']['y'] !!}</td>
                                                <td>{!! $each['sf']  !!}%</td>
                                                @php $chartSF[$type][]  = $each['sf'] @endphp
                                                @php $chartPax[$type][] = $each['pax']['c'] + $each['pax']['y'] @endphp
                                            @endforeach
                                        </tr>
                                    @empty
                                    @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </article>

            <article class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
                <!-- Widget ID (each widget will need unique ID)-->
                <div class="jarviswidget" id="wid-chart-id-1"
                     data-widget-fullscreenbutton="false" data-widget-editbutton="false"
                     data-widget-sortable="false">
                    <!-- widget options:
                        usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                        data-widget-colorbutton="false"
                        data-widget-editbutton="false"
                        data-widget-togglebutton="false"
                        data-widget-deletebutton="false"
                        data-widget-fullscreenbutton="false"
                        data-widget-custombutton="false"
                        data-widget-collapsed="true"
                        data-widget-sortable="false"

                    -->
                    <header>
                        <h2>@lang("content.seat_factors")</h2>
                    </header>

                    <!-- widget div-->
                    <div>

                        <!-- widget edit box -->
                        <div class="jarviswidget-editbox">
                            <!-- This area used as dropdown edit box -->
                            <input class="form-control" type="text">
                        </div>
                        <!-- end widget edit box -->

                        <!-- widget content -->
                        <div class="widget-body">
                            <!-- this is what the user will see -->
                            <canvas id="chart_sf" style="height: 150px;"></canvas>
                        </div>
                        <!-- end widget content -->

                    </div>
                    <!-- end widget div -->

                </div>
            </article>

            <article class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
                <!-- Widget ID (each widget will need unique ID)-->
                <div class="jarviswidget" id="wid-chart-id-2"
                     data-widget-fullscreenbutton="false" data-widget-editbutton="false"
                     data-widget-sortable="false">
                    <!-- widget options:
                        usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                        data-widget-colorbutton="false"
                        data-widget-editbutton="false"
                        data-widget-togglebutton="false"
                        data-widget-deletebutton="false"
                        data-widget-fullscreenbutton="false"
                        data-widget-custombutton="false"
                        data-widget-collapsed="true"
                        data-widget-sortable="false"

                    -->
                    <header>
                        <h2>PAX</h2>
                    </header>

                    <!-- widget div-->
                    <div>

                        <!-- widget edit box -->
                        <div class="jarviswidget-editbox">
                            <!-- This area used as dropdown edit box -->
                            <input class="form-control" type="text">
                        </div>
                        <!-- end widget edit box -->

                        <!-- widget content -->
                        <div class="widget-body">
                            <!-- this is what the user will see -->
                            <canvas id="chart_pax" style="height: 150px;"></canvas>
                        </div>
                        <!-- end widget content -->

                    </div>
                    <!-- end widget div -->

                </div>
            </article>
        @else
            <div class="clearfix"></div>
            <div class="alert alert-info">
                No Flights Found.
            </div>
        @endif

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function () {

        ApplyFormSubmit();

        ApplyTableFilter("#reportTable");

        ApplyValidationDateFormats();

        Apply_Multiselect();

        var lineOptions = GetChartJsLineOptions(true);

        // Chart PAX/REVENUE
        @if (isset($chartSF))
            var chartPaxRevenue = {
                labels: {!! json_encode($chartSF["date"]) !!},
                datasets: [
                    {
                        label: "PAX (Outbound)",
                        backgroundColor: "rgba(211,139,155,0.2)",
                        borderColor: "rgba(211,139,155,0.8)",
                        pointBackgroundColor: "rgba(211,139,155,1)",
                        pointBorderColor: "#fff",
                        pointHoverBackgroundColor: "#fff",
                        pointHoverBorderColor: "rgba(211,139,155,1)",
                        borderWidth: 2,
                        pointBorderWidth: 1,
                        pointRadius: 3,
                        data: {!! json_encode($chartSF["outbound"]) !!}

                    },
                    {
                        label: "PAX (Inbound)",
                        backgroundColor: "rgba(68,148,210,0.2)",
                        borderColor: "rgba(68,148,210,0.8)",
                        pointBackgroundColor: "rgba(68,148,210,1)",
                        pointBorderColor: "#fff",
                        pointHoverBackgroundColor: "#fff",
                        pointHoverBorderColor: "rgba(68,148,210,1)",
                        borderWidth: 2,
                        pointBorderWidth: 1,
                        pointRadius: 3,
                        data: {!! json_encode($chartSF["inbound"]) !!}

                    }
                    , {
                        label: "PAX Total",
                        backgroundColor: "rgba(51,127,105,0.2)",
                        borderColor: "rgba(51,127,105,0.8)",
                        pointBackgroundColor: "rgba(51,127,105,1)",
                        pointBorderColor: "#fff",
                        pointHoverBackgroundColor: "#fff",
                        pointHoverBorderColor: "rgba(51,127,105,1)",
                        borderWidth: 2,
                        pointBorderWidth: 1,
                        pointRadius: 3,
                        data: {!! json_encode($chartSF["total"]) !!}

                    }
                ]
            };

            var ctx1 = document.getElementById("chart_sf").getContext("2d");
            myNewChart_1 = new Chart(ctx1, {
                type: 'bar',
                data: chartPaxRevenue,
                options: lineOptions
            });
        @endif
        // END CHART PAX/REVENUE

        // CHART REVENUE
        @if (isset($chartPax))
            var chartRevenue = {
                labels: {!! json_encode($chartPax["date"]) !!},
                datasets: [
                    {
                        label: "Revenue (Business)",
                        backgroundColor: "rgba(211,139,155,0.2)",
                        borderColor: "rgba(211,139,155,0.8)",
                        pointBackgroundColor: "rgba(211,139,155,1)",
                        pointBorderColor: "#fff",
                        pointHoverBackgroundColor: "#fff",
                        pointHoverBorderColor: "rgba(211,139,155,1)",
                        borderWidth: 2,
                        pointBorderWidth: 1,
                        pointRadius: 3,
                        data: {!! json_encode($chartPax["outbound"]) !!}

                    },
                    {
                        label: "Revenue (Economy)",
                        backgroundColor: "rgba(68,148,210,0.2)",
                        borderColor: "rgba(68,148,210,0.8)",
                        pointBackgroundColor: "rgba(68,148,210,1)",
                        pointBorderColor: "#fff",
                        pointHoverBackgroundColor: "#fff",
                        pointHoverBorderColor: "rgba(68,148,210,1)",
                        borderWidth: 2,
                        pointBorderWidth: 1,
                        pointRadius: 3,
                        data: {!! json_encode($chartPax["inbound"]) !!}

                    }
                    , {
                        label: "Revenue Total",
                        backgroundColor: "rgba(51,127,105,0.2)",
                        borderColor: "rgba(51,127,105,0.8)",
                        pointBackgroundColor: "rgba(51,127,105,1)",
                        pointBorderColor: "#fff",
                        pointHoverBackgroundColor: "#fff",
                        pointHoverBorderColor: "rgba(51,127,105,1)",
                        borderWidth: 2,
                        pointBorderWidth: 1,
                        pointRadius: 3,
                        data: {!! json_encode($chartPax["total"]) !!}

                    }
                ]
            };

            var ctx2 = document.getElementById("chart_pax").getContext("2d");
            myNewChart_2 = new Chart(ctx2, {
                type: 'line',
                data: chartRevenue,
                options: lineOptions
            });
        @endif
        // END CHART

    };

    loadScript("<?php echo ASSETS_URL; ?>/js/plugin/chartjs/chart.min.js", function () {
        loadScript("{{ asset("assets/js/views/forwardbooking/index.js") }}", pagefunction)
    });

</script>
