<?php require_once(public_path("smart/inc/init.php")); ?>

@php $j = 1 @endphp

<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @if (count($flightNumbers))

                <div class="tabbable"> <!-- Only required for left/right tabs -->

                    <ul class="nav nav-tabs">

                        @foreach($flightNumbers as $i => $flightNumber)
                            <li class="{{ ($i == 0) ? 'active' : ''}}" style="margin: 2px 1px; width: 70px">
                                <a class="text-center" href="#tab{{ $i +1 }}" data-toggle="tab">
                                    {{ $flightNumber }}
                                </a>
                            </li>
                        @endforeach
                    </ul>

                    <div class="tab-content">
                        @foreach($groupedFlights as $k => $flightParentChild)
                            <div class="tab-pane {{ $j == 1 ? 'active' : '' }}" id="tab{{ $j++ }}" style="padding-top: 10px;">
                                <div class="message_box"></div>
                                <div class="col-lg-4 marginBottomRight">
                                    {!! Form::open(['method' => 'GET', 'class' => 'form-inline']) !!}
                                    {!! Form::label('dateFrom', trans("content.from")) !!}
                                    {!! Form::text('dateFrom', \request("dateFrom"), ['class' => 'form-control input-sm dateFrom']) !!}
                                    {!! Form::label('dateTo', trans("content.to")) !!}
                                    {!! Form::text('dateTo', \request("dateTo"), ['class' => 'form-control input-sm dateTo']) !!}
                                    {!! Form::button('Submit', ['type' => 'submit', 'class' => 'btn btn-primary']) !!}
                                    {!! Form::close() !!}
                                </div>

                                <button type="button" class="btn btn-primary save">Save</button>

                                <div class="clearfix"></div>

                                @php $count_flights = count($flightParentChild[0]) @endphp

                                <article class="col-sm-12 col-md-12 col-lg-12">

                                    <!-- Widget ID (each widget will need unique ID)-->
                                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-{{ $i."-".$k }}"
                                         data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                                        <header>
                                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                                            <h2>Flights</h2>

                                        </header>

                                        <!-- widget div-->
                                        <div>

                                            <!-- widget edit box -->
                                            <div class="jarviswidget-editbox">
                                                <!-- This area used as dropdown edit box -->

                                            </div>
                                            <!-- end widget edit box -->

                                            <!-- widget content -->
                                            <div class="widget-body no-padding">

                                                <div class="table-responsive">

                                                    <table class="table table-striped table-bordered table-hover" style="margin-top: 5px;">
                                                        <thead>
                                                        <tr class="flight_number_id">
                                                            @foreach($flightParentChild[0] as $k => $flight)
                                                                @php $flight_number = $flight['flight_number']['flight_number'] @endphp
                                                                <th colspan="9" class="text-center" data-flight_number_id="{{ $flight['flight_number']['id'] }}"
                                                                    data-flight_bound="{!! Outbound_Inbound($count_flights,$flight_number,$k) !!}">{!! $CURRENT_IATA_CODE." ".$flight_number !!}</th>
                                                            @endforeach
                                                        </tr>
                                                        <tr>
                                                            @for($u = 0; $u < $count_flights; $u++)
                                                                <th rowspan="2">@lang("content.departure_date")</th>
                                                                <th rowspan="2">A/C</th>
                                                                <th colspan="2">@lang("content.config")</th>
                                                                <th colspan="2">PAX</th>
                                                                <th rowspan="2">Cancel Flight</th>
                                                                <th rowspan="2">Close Sales</th>
                                                                <th rowspan="2">Remark</th>
                                                            @endfor
                                                        </tr>
                                                        <tr>
                                                            @for($u = 0; $u < $count_flights; $u++)
                                                                <th>C</th>
                                                                <th>Y</th>
                                                                <th>C</th>
                                                                <th>Y</th>
                                                            @endfor
                                                        </tr>
                                                        </thead>

                                                        <tbody>
                                                        @foreach($flightParentChild as $m => $flights)
                                                            <tr>
                                                                @foreach($flights as $n => $flight)
                                                                    @if (!is_null($flight['deleted_at']))
                                                                        @php $style = 'class = "cancelled_flight"'; $style_only = "cancelled_flight" @endphp
                                                                    @elseif(!is_null($flight['closed_sales']))
                                                                        @php $style = 'class = "closed_sales"'; $style_only = "closed_sales" @endphp
                                                                    @else
                                                                        @php $style = ''; $style_only = "" @endphp
                                                                    @endif

                                                                    <td class="flight_id {!!$style_only!!}"
                                                                        data-flight_id="{!!$flight['id']!!}"
                                                                        data-flight_std="{!!$flight['std']!!}">{{ date('M d, Y', strtotime($flight['std'])) }}</td>
                                                                    <td class="aircraft_id {!!$style_only!!}"
                                                                        data-aircraft_id={!!$flight['aircraft']['id']!!}>{!!$flight['aircraft']['name']!!}</td>
                                                                    <td {!! $style !!}>{!! Form::input('text', 'capacity_c[]', $flight['capacity_c'], ['class'=>'forwardbooking_input']) !!}</td>
                                                                    <td {!! $style !!}>{!! Form::input('text', 'capacity_y[]', $flight['capacity_y'], ['class'=>'forwardbooking_input']) !!}</td>
                                                                    <td {!! $style !!}>{!! Form::input('text', 'pax_c_booked[]', $flight['pax_c_booked'], ['class'=>'forwardbooking_input', 'maxlength' => 2, 'tabindex' => ($m + 1)*2 + $n * 100 ]) !!}</td>
                                                                    <td {!! $style !!}>{!! Form::input('text', 'pax_y_booked[]', $flight['pax_y_booked'], ['class'=>'forwardbooking_input', 'maxlength' => 3, 'tabindex' => ($m + 1)*2 + $n * 100 ]) !!}</td>
                                                                    <td {!! $style !!}>{!! Form::checkbox('deleted_at[]','1', is_null($flight['deleted_at']) ? false : true, ['class'=>'cancel_flight', 'disabled' => 'false']) !!}
                                                                        @if(!is_null($flight['deleted_at']))
                                                                            {!!date('M d, Y', strtotime($flight['deleted_at'])) !!}
                                                                        @endif
                                                                    </td>
                                                                    <td {!! $style !!}>{!! Form::checkbox('closed_sales[]','1', is_null($flight['closed_sales']) ? false : true, ['class'=>'closed_sales'] ) !!}
                                                                        @if(!is_null($flight['closed_sales']))
                                                                            {!!date('M d, Y', strtotime($flight['closed_sales'])) !!}
                                                                        @endif
                                                                    </td>
                                                                    <td {!! $style !!}>{!! Form::input('text', 'remark[]',$flight['remark'],['class'=>'forwardbooking_input_long']) !!}</td>
                                                                @endforeach
                                                            </tr>
                                                        @endforeach
                                                        </tbody>
                                                    </table>

                                                </div>

                                            </div>

                                        </div>

                                    </div>

                                </article>
                            </div>

                        @endforeach

                    </div>

                </div>

            @endif

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function () {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();
    };

    loadScript("{{ asset("assets/js/views/forwardbooking/index.js") }}", pagefunction);

</script>

