<?php require_once(public_path("smart/inc/init.php")); ?>

@php $j = 1 @endphp
        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
            @include('forwardbooking.handling.form', ['from' => $from, 'to' => $to, 'url' => url("forwardbooking/handling/report-daily")] )
        </article>

        {{--Arrivals--}}
        <article class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
            <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-rd-2" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
                <!-- widget options:
                usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                data-widget-colorbutton="false"
                data-widget-editbutton="false"
                data-widget-togglebutton="false"
                data-widget-deletebutton="false"
                data-widget-fullscreenbutton="false"
                data-widget-custombutton="false"
                data-widget-collapsed="true"
                data-widget-sortable="false"

                -->
                <header>
                    <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                    <h2>@lang("content.arrivals")</h2>

                </header>

                <!-- widget div-->
                <div>

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->

                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body no-padding">

                        <div class="table-responsive">

                            <table class="table table-striped table-bordered table-hover" id="arrivals-table">

                                <thead>
                                <tr>
                                    <th rowspan="2" class="text-center">No</th>
                                    <th rowspan="2">@lang("content.flight_number")</th>
                                    <th rowspan="2">@lang("content.sector")</th>
                                    <th rowspan="2" style="min-width: 50px;" class="text-center">@lang("content.arrivals")</th>
                                    <th rowspan="2">@lang("content.ac")</th>
                                    <th colspan="3" data-center>@lang("content.capacity")</th>
                                    <th colspan="3" data-center>PAX</th>
                                    <th rowspan="2">SF</th>
                                </tr>
                                <tr>
                                    <th data-center>C</th>
                                    <th data-center>Y</th>
                                    <th>@lang("content.total")</th>
                                    <th data-center>C</th>
                                    <th data-center>Y</th>
                                    <th>@lang("content.total")</th>
                                </tr>
                                </thead>

                                <tbody>

                                @php $k = 0 @endphp
                                @php $chartArrivalsSF =  ["flight_number" => [], "sf"  => []] @endphp
                                @php $chartArrivalsPAX = ["flight_number" => [], "pax" => []] @endphp
                                @php $prevDate = null @endphp
                                @foreach($flights as $flight)

                                    @if ($flight->skip || $flight->type != INBOUND)
                                        @continue
                                    @endif

                                    @php $flightDate = baseDateFormat(getFlightArrivalDate($flight)) @endphp
                                    @php $date = $prevDate == $flightDate ? null : ($prevDate = $flightDate) @endphp

                                    @if ($date)
                                        <tr>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td>{{ $date }}</td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                        </tr>
                                    @endif

                                    <tr>
                                        @php $flightNumberAirline = $flight->flightNumber && $flight->flightNumber->airline ? $flight->flightNumber->airline->iata : "" @endphp
                                        @php $flightNumber = $flight->flightNumber ? $flight->flightNumber->flight_number : "" @endphp
                                        @php $sector = "" @endphp
                                        @if ($flight->flightNumber)
                                            @php $sector .= ($flight->flightNumber->departureAirport ? $flight->flightNumber->departureAirport->iata : "")."-" @endphp
                                            @php $sector .= ($flight->flightNumber->arrivalAirport ? $flight->flightNumber->arrivalAirport->iata : "") @endphp
                                        @endif

                                        <td>{{ ++$k }}</td>
                                        {{--TOTAL--}}
                                        <td>
                                            <a target="_blank" href="{{ url("flight-tracker/{$flight->id}") }}">
                                                <strong>{!! $flightNumberAirline !!}</strong>-{!! $flightNumber !!}
                                            </a>
                                        </td>
                                        <td>{{ $sector }}</td>

                                        <td>{{ baseTimeFormat(getFlightArrivalDate($flight)) }}</td>

                                        <td>{{ $flight->aircraft ? ($flight->aircraft->name ? $flight->aircraft->name : $flight->aircraft->iata_name) : "-" }}</td>

                                        {{--OUTBOUND--}}

                                        <td>{{ $flight->capacity_c }}</td>
                                        <td>{{ $flight->capacity_y }}</td>
                                        <td>{{ $flight->capacity_c + $flight->capacity_y }}</td>

                                        @if ($flight->pax_c_actual || $flight->pax_y_actual)
                                            <td class="pax_actual">{{ $pax_c = ($flight->pax_c_actual ? $flight->pax_c_actual : 0) }}</td>
                                            <td class="pax_actual">{{ $pax_y = ($flight->pax_y_actual ? $flight->pax_y_actual : 0) }}</td>
                                            <td class="pax_actual">{{ $pax_c + $pax_y }}</td>
                                        @else
                                            <td>{{ $pax_c = ($flight->pax_c_booked ? $flight->pax_c_booked : 0) }}</td>
                                            <td>{{ $pax_y = ($flight->pax_y_booked ? $flight->pax_y_booked : 0) }}</td>
                                            <td>{{ $pax_c + $pax_y }}</td>
                                        @endif

                                        <td>{{ $flight->sf ? $flight->sf."%" : "" }}</td>

                                        @php $sf_inbound = 0 @endphp

                                        @php $chartArrivalsSF["flight_number"][] = $flightNumberAirline."-".$flightNumber @endphp
                                        @php $chartArrivalsSF["sf"][]   = $flight->sf > 100 ? 100 : $flight->sf @endphp

                                        @php $chartArrivalsPAX["flight_number"][] = $flightNumberAirline."-".$flightNumber @endphp
                                        @php $chartArrivalsPAX["pax"][] = $pax_c + $pax_y @endphp

                                    </tr>
                                @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>

            <h4 class="col-md-12" style="margin: 0 0 15px 0; padding: 0">
                <span class="crewroster_item"><span class="flight_color pax_actual"></span> PAX ACT</span>
            </h4>

        </article>

        {{--Departures--}}
        <article class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
            <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-rd-2" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
                <!-- widget options:
                usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                data-widget-colorbutton="false"
                data-widget-editbutton="false"
                data-widget-togglebutton="false"
                data-widget-deletebutton="false"
                data-widget-fullscreenbutton="false"
                data-widget-custombutton="false"
                data-widget-collapsed="true"
                data-widget-sortable="false"

                -->
                <header>
                    <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                    <h2>@lang("content.departures")</h2>

                </header>

                <!-- widget div-->
                <div>

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->

                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body no-padding">

                        <div class="table-responsive">

                            <table class="table table-striped table-bordered table-hover" id="departures-table">
                                <thead>
                                <tr>
                                    <th rowspan="2" class="text-center">No</th>
                                    <th rowspan="2">@lang("content.flight_number")</th>
                                    <th rowspan="2">@lang("content.sector")</th>
                                    <th rowspan="2" style="min-width: 50px;" class="text-center">@lang("content.departures")</th>
                                    <th rowspan="2">@lang("content.ac")</th>
                                    <th colspan="3" data-center>@lang("content.capacity")</th>
                                    <th colspan="3" data-center>PAX</th>
                                    <th rowspan="2">SF</th>
                                </tr>
                                <tr>
                                    <th data-center>C</th>
                                    <th data-center>Y</th>
                                    <th>@lang("content.total")</th>
                                    <th data-center>C</th>
                                    <th data-center>Y</th>
                                    <th>@lang("content.total")</th>
                                </tr>
                                </thead>

                                <tbody>
                                @php $k = 0 @endphp
                                @php $chartDeparturesSF =  ["flight_number" => [], "sf" => []] @endphp
                                @php $chartDeparturesPAX = ["flight_number" => [], "pax" => []] @endphp
                                @php $prevDate = null @endphp
                                @foreach($flights as $flight)

                                    @if ($flight->skip || $flight->type != OUTBOUND)
                                        @continue
                                    @endif

                                    @php $flightDate = baseDateFormat(getFlightDepartureDate($flight)) @endphp
                                    @php $date = $prevDate == $flightDate ? null : ($prevDate = $flightDate) @endphp

                                    @php $flightNumberAirline = $flight->flightNumber && $flight->flightNumber->airline ? $flight->flightNumber->airline->iata : "" @endphp
                                    @php $flightNumber = $flight->flightNumber ? $flight->flightNumber->flight_number : "" @endphp
                                    @php $sector = "" @endphp
                                    @if ($flight->flightNumber)
                                        @php $sector .= ($flight->flightNumber->departureAirport ? $flight->flightNumber->departureAirport->iata : "")."-" @endphp
                                        @php $sector .= ($flight->flightNumber->arrivalAirport ? $flight->flightNumber->arrivalAirport->iata : "") @endphp
                                    @endif

                                    @if ($date)
                                        <tr>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td>{{ $date }}</td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                        </tr>
                                    @endif

                                    <tr>
                                        <td>{{ ++$k }}</td>
                                        <td><a target="_blank" href="{{ url("flight-tracker/{$flight->id}") }}"><strong>{!! $flightNumberAirline !!}</strong>-{!! $flightNumber !!}</a></td>
                                        <td>{{ $sector }}</td>
                                        <td>{{ baseTimeFormat(getFlightDepartureDate($flight)) }}</td>
                                        <td>{{ $flight->aircraft ? ($flight->aircraft->name ? $flight->aircraft->name : $flight->aircraft->iata_name) : "-" }}</td>
                                        <td>{{ $flight->capacity_c }}</td>
                                        <td>{{ $flight->capacity_y }}</td>
                                        <td>{{ $flight->capacity_c + $flight->capacity_y }}</td>

                                        @if ($flight->pax_c_actual || $flight->pax_y_actual)
                                            <td class="pax_actual">{{ $pax_c = ($flight->pax_c_actual ? $flight->pax_c_actual : 0) }}</td>
                                            <td class="pax_actual">{{ $pax_y = ($flight->pax_y_actual ? $flight->pax_y_actual : 0) }}</td>
                                            <td class="pax_actual">{{ $pax_c + $pax_y }}</td>
                                        @else
                                            <td>{{ $pax_c = ($flight->pax_c_booked ? $flight->pax_c_booked : 0) }}</td>
                                            <td>{{ $pax_y = ($flight->pax_y_booked ? $flight->pax_y_booked : 0) }}</td>
                                            <td>{{ $pax_c + $pax_y }}</td>
                                        @endif

                                        <td>{{ $flight->sf ? $flight->sf."%" : "" }}</td>
                                    </tr>

                                    @php $chartDeparturesSF["flight_number"][] = $flightNumberAirline."-".$flightNumber @endphp
                                    @php $chartDeparturesSF["sf"][] = $flight->sf > 100 ? 100 : $flight->sf @endphp

                                    @php $chartDeparturesPAX["flight_number"][] = $flightNumberAirline."-".$flightNumber @endphp
                                    @php $chartDeparturesPAX["pax"][] = $pax_c + $pax_y @endphp

                                @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>

            <h4 class="col-md-12" style="margin: 0 0 15px 0; padding: 0">
                <span class="crewroster_item"><span class="flight_color pax_actual"></span> PAX ACT</span>
                {{--<span class="crewroster_item"><span class="flight_color no_inbound"></span> No Arrivals Flight</span>--}}
            </h4>

        </article>

        <div class="clearfix"></div>

        {{--Arrivals Chart--}}
        <article class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
            <!-- Widget ID (each widget will need unique ID)-->
            <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-chart-1" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
                <!-- widget options:
                    usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    data-widget-colorbutton="false"
                    data-widget-editbutton="false"
                    data-widget-togglebutton="false"
                    data-widget-deletebutton="false"
                    data-widget-fullscreenbutton="false"
                    data-widget-custombutton="false"
                    data-widget-collapsed="true"
                    data-widget-sortable="false"

                -->
                <header>
                    <h2>@lang("content.seat_factors") (@lang("content.arrivals")), %</h2>
                </header>

                <!-- widget div-->
                <div>

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->
                        <input class="form-control" type="text">
                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body">
                        <!-- this is what the user will see -->
                        <canvas id="chart_arrivals_sf" style="height: 250px !important;"></canvas>
                    </div>
                    <!-- end widget content -->

                </div>
                <!-- end widget div -->

            </div>
        </article>

        {{--Departures Chart--}}
        <article class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
            <!-- Widget ID (each widget will need unique ID)-->
            <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-chart-1" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
                <!-- widget options:
                    usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    data-widget-colorbutton="false"
                    data-widget-editbutton="false"
                    data-widget-togglebutton="false"
                    data-widget-deletebutton="false"
                    data-widget-fullscreenbutton="false"
                    data-widget-custombutton="false"
                    data-widget-collapsed="true"
                    data-widget-sortable="false"

                -->
                <header>
                    <h2>@lang("content.seat_factors") (@lang("content.departures")), %</h2>
                </header>

                <!-- widget div-->
                <div>

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->
                        <input class="form-control" type="text">
                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body">
                        <!-- this is what the user will see -->
                        <canvas id="chart_departures_sf" style="height: 250px;"></canvas>
                    </div>
                    <!-- end widget content -->

                </div>
                <!-- end widget div -->

            </div>
        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function () {

        ApplyFormSubmit();

        ApplyTableFilter("#arrivals-table");

        ApplyTableFilter("#departures-table");

        ApplyValidationDateFormats();

        Apply_Multiselect();

        @if (ghaModule())
            ApplyOperationsFormFilter({!! json_encode($flightNumbers) !!}, {!! json_encode(\request("flightNumber")) !!}, {!! json_encode($sectors) !!}, {!! json_encode($sectorsByAirlines) !!}, {!! json_encode(\request("sector")) !!});
        @endif

        var lineOptions = GetChartJsLineOptions();

        // Chart Arrivals SF
        @if (isset($chartArrivalsSF))
            {{ debug($chartArrivalsSF) }}

            var chartArrivalsSFData = {
            labels: {!! json_encode($chartArrivalsSF["flight_number"]) !!},
            datasets: [
                {
                    label: "SF (Arrivals), %",
                    backgroundColor: "rgba(68,148,210,0.2)",
                    borderColor: "rgba(68,148,210,0.8)",
                    pointBackgroundColor: "rgba(68,148,210,1)",
                    pointBorderColor: "#fff",
                    pointHoverBackgroundColor: "#fff",
                    pointHoverBorderColor: "rgba(68,148,210,1)",
                    borderWidth: 2,
                    pointBorderWidth: 1,
                    pointRadius: 3,
                    data: {!! json_encode($chartArrivalsSF["sf"]) !!}
                },
            ]
        };

        new Chart(document.getElementById("chart_arrivals_sf").getContext("2d"), {
            type: 'bar',
            data: chartArrivalsSFData,
            options: lineOptions
        });
        @endif
        // END CHART

        // Chart Arrivals SF
        @if (isset($chartArrivalsPAX2))
            var chartArrivalsPAXData = {
            labels: {!! json_encode($chartArrivalsPAX["flight_number"]) !!},
            datasets: [
                {
                    label: "PAX (Arrivals)",
                    backgroundColor: "rgba(68,148,210,0.2)",
                    borderColor: "rgba(68,148,210,0.8)",
                    pointBackgroundColor: "rgba(68,148,210,1)",
                    pointBorderColor: "#fff",
                    pointHoverBackgroundColor: "#fff",
                    pointHoverBorderColor: "rgba(68,148,210,1)",
                    borderWidth: 2,
                    pointBorderWidth: 1,
                    pointRadius: 3,
                    data: {!! json_encode($chartArrivalsPAX["pax"]) !!}
                },
            ]
        };

        new Chart(document.getElementById("chart_arrivals_pax").getContext("2d"), {
            type: 'bar',
            data: chartArrivalsPAXData,
            options: lineOptions
        });
        @endif
        // END CHART

        // Chart Departures SF
        @if (isset($chartDeparturesSF))
            {{ debug($chartDeparturesSF) }}

            var chartDeparturesSFData = {
            labels: {!! json_encode($chartDeparturesSF["flight_number"]) !!},
            datasets: [
                {
                    label: "SF (Departures), %",
                    backgroundColor: "rgba(211,139,155,0.2)",
                    borderColor: "rgba(211,139,155,0.8)",
                    pointBackgroundColor: "rgba(211,139,155,1)",
                    pointBorderColor: "#fff",
                    pointHoverBackgroundColor: "#fff",
                    pointHoverBorderColor: "rgba(211,139,155,1)",
                    borderWidth: 2,
                    pointBorderWidth: 1,
                    pointRadius: 3,
                    data: {!! json_encode($chartDeparturesSF["sf"]) !!}
                },
            ]
        };

        new Chart(document.getElementById("chart_departures_sf").getContext("2d"), {
            type: 'bar',
            data: chartDeparturesSFData,
            options: lineOptions
        });
        @endif
        // END CHART

        // Chart Departures SF
        @if (isset($chartDeparturesPAX2))
            var chartDeparturesPAXData = {
            labels: {!! json_encode($chartDeparturesPAX["flight_number"]) !!},
            datasets: [
                {
                    label: "PAX (Departures)",
                    backgroundColor: "rgba(211,139,155,0.2)",
                    borderColor: "rgba(211,139,155,0.8)",
                    pointBackgroundColor: "rgba(211,139,155,1)",
                    pointBorderColor: "#fff",
                    pointHoverBackgroundColor: "#fff",
                    pointHoverBorderColor: "rgba(211,139,155,1)",
                    borderWidth: 2,
                    pointBorderWidth: 1,
                    pointRadius: 3,
                    data: {!! json_encode($chartDeparturesPAX["pax"]) !!}
                },
            ]
        };

        new Chart(document.getElementById("chart_departures_pax").getContext("2d"), {
            type: 'bar',
            data: chartDeparturesPAXData,
            options: lineOptions
        });
        @endif
        // END CHART
    };

    loadScript("<?php echo ASSETS_URL; ?>/js/plugin/chartjs/chart.min.js", pagefunction);

</script>


