<?php require_once(public_path("smart/inc/init.php")); ?>

@php $j = 1 @endphp
<!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
            @include('report.ops-form', [ 'types' => [ ALL => ALL, DEPARTURE => DEPARTURE, ARRIVAL => ARRIVAL],  'enableAirline' => true, 'enableAirport' => true, 'enablePeriod' => true])
        </article>

        <div class="clearfix"></div>

        @if (count($groupedFlights))
            <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                <!-- Widget ID (each widget will need unique ID)-->
                <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-2" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
                    <!-- widget options:
                    usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    data-widget-colorbutton="false"
                    data-widget-editbutton="false"
                    data-widget-togglebutton="false"
                    data-widget-deletebutton="false"
                    data-widget-fullscreenbutton="false"
                    data-widget-custombutton="false"
                    data-widget-collapsed="true"
                    data-widget-sortable="false"

                    -->
                    <header>
                        <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                        <h2>@lang("content.daily_report")</h2>

                    </header>

                    <!-- widget div-->
                    <div>

                        <!-- widget edit box -->
                        <div class="jarviswidget-editbox">
                            <!-- This area used as dropdown edit box -->

                        </div>
                        <!-- end widget edit box -->

                        <!-- widget content -->
                        <div class="widget-body no-padding">

                            <div class="table-responsive">
                                <table class="table table-striped table-bordered table-hover" id="reportTable"
                                       style="margin-top: 5px;"  data-page-length='' data-order='[[1, "asc"], [7, "asc"]]'>
                                    <thead>
                                    <tr>
                                        <th rowspan="3" class="text-center">No</th>
                                        <th rowspan="3" class="text-center">@lang("content.departure_date")</th>
                                        <th colspan="7" class="text-center outbound">@lang("content.departures")</th>
                                        <th colspan="7" class="text-center inbound">@lang("content.arrivals")</th>
                                    </tr>
                                    <tr>
                                        <th colspan="3" class="text-center">@lang("content.capacity")</th>
                                        <th colspan="3" class="text-center">PAX</th>
                                        <th rowspan="2" class="text-center">SF</th>

                                        <th colspan="3" class="text-center">@lang("content.capacity")</th>
                                        <th colspan="3" class="text-center">PAX</th>
                                        <th rowspan="2" class="text-center">SF</th>
                                    </tr>
                                    <tr>
                                        <th>C</th>
                                        <th>Y</th>
                                        <th>@lang("content.total")</th>

                                        <th>C</th>
                                        <th>Y</th>
                                        <th>@lang("content.total")</th>

                                        <th>C</th>
                                        <th>Y</th>
                                        <th>@lang("content.total")</th>

                                        <th>C</th>
                                        <th>Y</th>
                                        <th>@lang("content.total")</th>
                                    </tr>
                                    </thead>

                                    @php $chartSF = $chartPax = ["date" => [], "outbound" => [], "inbound" => [] ] @endphp
                                    @php $i = 1 @endphp

                                    <tbody>
                                    @forelse($groupedFlights as $date => $flight)
                                        <tr>
                                            <td>{!! $i++ !!}</td>
                                            <td class="nowrap"><a href="{{ route("homepage")."#".url("forwardbooking/handling/report-daily?date={$date}") }}">{!! $date !!}</a></td>

                                            @php $chartSF["date"][] = $date; @endphp
                                            @php $chartPax["date"][] = $date; @endphp

                                            @foreach($flight as $type => $each)
                                                <td>{!! $each['capacity']['c'] !!}</td>
                                                <td>{!! $each['capacity']['y'] !!}</td>
                                                <td>{!! $each['capacity']['c'] + $each['capacity']['y'] !!}</td>

                                                <td>{!! $each['pax']['c'] !!}</td>
                                                <td>{!! $each['pax']['y'] !!}</td>
                                                <td>{!! $each['pax']['c'] + $each['pax']['y'] !!}</td>

                                                <td>{!! $each['sf'] !!}%</td>
                                                @php $chartSF[$type][]  = $each['sf'] @endphp
                                                @php $chartPax[$type][] = $each['pax']['c'] + $each['pax']['y'] @endphp
                                            @endforeach
                                        </tr>
                                    @empty
                                    @endforelse
                                    <tr>
                                        <td></td>
                                        <td>@lang("content.total")</td>
                                        <td>{!! $totals['outbound']['capacity']['c'] !!}</td>
                                        <td>{!! $totals['outbound']['capacity']['y'] !!}</td>
                                        <td>{!! $totals['outbound']['capacity']['c'] + $totals['outbound']['capacity']['y'] !!}</td>

                                        <td>{!! $totals['outbound']['pax']['c'] !!}</td>
                                        <td>{!! $totals['outbound']['pax']['y'] !!}</td>
                                        <td>{!! $totals['outbound']['pax']['c'] + $totals['outbound']['pax']['y'] !!}</td>

                                        <td>{!! $totals['outbound']['sf']  !!}%</td>

                                        <td>{!! $totals['inbound']['capacity']['c'] !!}</td>
                                        <td>{!! $totals['inbound']['capacity']['y'] !!}</td>
                                        <td>{!! $totals['inbound']['capacity']['c'] + $totals['inbound']['capacity']['y'] !!}</td>

                                        <td>{!! $totals['inbound']['pax']['c'] !!}</td>
                                        <td>{!! $totals['inbound']['pax']['y'] !!}</td>
                                        <td>{!! $totals['inbound']['pax']['c'] + $totals['inbound']['pax']['y'] !!}</td>

                                        <td>{!! $totals['inbound']['sf']  !!}%</td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </article>

            <article class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
                <!-- Widget ID (each widget will need unique ID)-->
                <div class="jarviswidget" id="wid-chart-id-1"
                     data-widget-fullscreenbutton="false" data-widget-editbutton="false"
                     data-widget-sortable="false">
                    <!-- widget options:
                        usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                        data-widget-colorbutton="false"
                        data-widget-editbutton="false"
                        data-widget-togglebutton="false"
                        data-widget-deletebutton="false"
                        data-widget-fullscreenbutton="false"
                        data-widget-custombutton="false"
                        data-widget-collapsed="true"
                        data-widget-sortable="false"

                    -->
                    <header>
                        <h2>@lang("content.seat_factors"), %</h2>
                    </header>

                    <!-- widget div-->
                    <div>

                        <!-- widget edit box -->
                        <div class="jarviswidget-editbox">
                            <!-- This area used as dropdown edit box -->
                            <input class="form-control" type="text">
                        </div>
                        <!-- end widget edit box -->

                        <!-- widget content -->
                        <div class="widget-body">
                            <!-- this is what the user will see -->
                            <canvas id="chart_sf" style="height: 150px;"></canvas>
                        </div>
                        <!-- end widget content -->

                    </div>
                    <!-- end widget div -->

                </div>
            </article>

            <article class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
                <!-- Widget ID (each widget will need unique ID)-->
                <div class="jarviswidget" id="wid-chart-id-2"
                     data-widget-fullscreenbutton="false" data-widget-editbutton="false"
                     data-widget-sortable="false">
                    <!-- widget options:
                        usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                        data-widget-colorbutton="false"
                        data-widget-editbutton="false"
                        data-widget-togglebutton="false"
                        data-widget-deletebutton="false"
                        data-widget-fullscreenbutton="false"
                        data-widget-custombutton="false"
                        data-widget-collapsed="true"
                        data-widget-sortable="false"

                    -->
                    <header>
                        <h2>PAX</h2>
                    </header>

                    <!-- widget div-->
                    <div>

                        <!-- widget edit box -->
                        <div class="jarviswidget-editbox">
                            <!-- This area used as dropdown edit box -->
                            <input class="form-control" type="text">
                        </div>
                        <!-- end widget edit box -->

                        <!-- widget content -->
                        <div class="widget-body">
                            <!-- this is what the user will see -->
                            <canvas id="chart_pax" style="height: 150px;"></canvas>
                        </div>
                        <!-- end widget content -->

                    </div>
                    <!-- end widget div -->

                </div>
            </article>
        @else
            <div class="clearfix"></div>

            <div class="col-md-12">
                <div class="alert alert-info">
                    @lang("content.total")No Flights Found.
                </div>
            </div>
        @endif

    </div>

</section>



{{-- JS scripts section --}}




<script type="text/javascript">

    pageSetUp();

    var pagefunction = function () {

        ApplyFormSubmit();

        ApplyTableFilter("#reportTable");

        ApplyValidationDateFormats();

        Apply_Multiselect();

        @if (ghaModule())
            ApplyOperationsFormFilter({!! json_encode($flightNumbers) !!}, {!! json_encode(\request("flightNumber")) !!}, {!! json_encode($sectors) !!}, {!! json_encode($sectorsByAirlines) !!}, {!! json_encode(\request("sector")) !!});
        @endif

        var lineOptions = GetChartJsLineOptions(true);

        // Chart PAX/REVENUE
        @if (isset($chartSF))
            var chartSF = {
                labels: {!! json_encode($chartSF["date"]) !!},
                datasets: [
                    {
                        label: "SF (Departures), %",
                        backgroundColor: "rgba(211,139,155,0.2)",
                        borderColor: "rgba(211,139,155,0.8)",
                        pointBackgroundColor: "rgba(211,139,155,1)",
                        pointBorderColor: "#fff",
                        pointHoverBackgroundColor: "#fff",
                        pointHoverBorderColor: "rgba(211,139,155,1)",
                        borderWidth: 2,
                        pointBorderWidth: 1,
                        pointRadius: 3,
                        data: {!! json_encode($chartSF["outbound"]) !!}

                    },
                    {
                        label: "SF (Arrivals), %",
                        backgroundColor: "rgba(68,148,210,0.2)",
                        borderColor: "rgba(68,148,210,0.8)",
                        pointBackgroundColor: "rgba(68,148,210,1)",
                        pointBorderColor: "#fff",
                        pointHoverBackgroundColor: "#fff",
                        pointHoverBorderColor: "rgba(68,148,210,1)",
                        borderWidth: 2,
                        pointBorderWidth: 1,
                        pointRadius: 3,
                        data: {!! json_encode($chartSF["inbound"]) !!}

                    }
                    /*
                    , {
                        label: "SF Total",
                        backgroundColor: "rgba(51,127,105,0.2)",
                        borderColor: "rgba(51,127,105,0.8)",
                        pointBackgroundColor: "rgba(51,127,105,1)",
                        pointBorderColor: "#fff",
                        pointHoverBackgroundColor: "#fff",
                        pointHoverBorderColor: "rgba(51,127,105,1)",
                        borderWidth: 2,
                        pointBorderWidth: 1,
                        pointRadius: 3,
                        data:  json_encode($chartSF["total"])

                    }
                    */
                ]
            };

            var ctx1 = document.getElementById("chart_sf").getContext("2d");
            myNewChart_1 = new Chart(ctx1, {
                type: 'bar',
                data: chartSF,
                options: lineOptions
            });
        @endif
        // END CHART SF

        // CHART PAX
        @if (isset($chartPax))
            var chartPax = {
                labels: {!! json_encode($chartPax["date"]) !!},
                datasets: [
                    {
                        label: "PAX (Departures)",
                        backgroundColor: "rgba(211,139,155,0.2)",
                        borderColor: "rgba(211,139,155,0.8)",
                        pointBackgroundColor: "rgba(211,139,155,1)",
                        pointBorderColor: "#fff",
                        pointHoverBackgroundColor: "#fff",
                        pointHoverBorderColor: "rgba(211,139,155,1)",
                        borderWidth: 2,
                        pointBorderWidth: 1,
                        pointRadius: 3,
                        data: {!! json_encode($chartPax["outbound"]) !!}

                    },
                    {
                        label: "PAX (Arrivals)",
                        backgroundColor: "rgba(68,148,210,0.2)",
                        borderColor: "rgba(68,148,210,0.8)",
                        pointBackgroundColor: "rgba(68,148,210,1)",
                        pointBorderColor: "#fff",
                        pointHoverBackgroundColor: "#fff",
                        pointHoverBorderColor: "rgba(68,148,210,1)",
                        borderWidth: 2,
                        pointBorderWidth: 1,
                        pointRadius: 3,
                        data: {!! json_encode($chartPax["inbound"]) !!}

                    }
                    /*
                    , {
                        label: "PAX (Total)",
                        backgroundColor: "rgba(51,127,105,0.2)",
                        borderColor: "rgba(51,127,105,0.8)",
                        pointBackgroundColor: "rgba(51,127,105,1)",
                        pointBorderColor: "#fff",
                        pointHoverBackgroundColor: "#fff",
                        pointHoverBorderColor: "rgba(51,127,105,1)",
                        borderWidth: 2,
                        pointBorderWidth: 1,
                        pointRadius: 3,
                        data:  json_encode($chartPax["total"])

                    }
                    */
                ]
            };

            var ctx2 = document.getElementById("chart_pax").getContext("2d");
            myNewChart_2 = new Chart(ctx2, {
                type: 'bar',
                data: chartPax,
                options: lineOptions
            });
        @endif
        // END CHART

    };

    loadScript("<?php echo ASSETS_URL; ?>/js/plugin/chartjs/chart.min.js", function () {
        loadScript("{{ asset("assets/js/views/forwardbooking/index.js") }}", pagefunction)
    });

</script>
