{!! Form::open(['method' => 'GET', 'class' => 'form-inline', 'id' => 'formPeriod', 'url' => isset($url) && $url ? $url : url("forwardbooking/handling/report") ]) !!}

    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12" style="margin-bottom: 20px">
        @if (env(MULTIPLE_AIRLINE))
        <div class="form-group marginBottomRight">
            <label>@lang("content.airline")</label>
            <div class="btn-group">
                {!! Form::select('airline[]', $airlines, \request("airline"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'airline']) !!}
            </div>
        </div>
        @endif

        <div class="form-group marginBottomRight">
            <label>@lang("content.airport")</label>
            <div class="btn-group">
                {!! Form::select('airport[]', $airports, \request("airport"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'airport']) !!}
            </div>
        </div>

        <div class="form-group marginBottomRight">
            <label>@lang("content.flight_number")</label>
            <div class="btn-group">
                @if (is_array($flightNumbers))
                    {!! Form::select('flightNumber[]', $flightNumbers, \request("flightNumber"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id' => 'flight_number']) !!}
                @else
                    <select name="flightNumber[]" class="multiselect_search" id="flight_number" multiple>
                        @foreach($flightNumbers as $each)
                            <option value="{{ $each->id }}" {!! \request("flightNumber") && in_array($each->id, \request("flightNumber")) ? "selected" : "" !!} data-airline_id ="{{ $each->airline_id }}">{{ $each->sector }}</option>
                        @endforeach
                    </select>
                @endif
            </div>
        </div>

        <div class="form-group marginBottomRight">
            <label>@lang("content.sector")</label>
            <div class="btn-group">
                @if (is_array($sectors))
                    {!! Form::select('sector[]', $sectors, \request("sector"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id' => 'sector']) !!}
                @else
                    <select name="sector[]" class="multiselect_search" id="sector" multiple>
                        @foreach($sectors as $each)
                            <option value="{{ $each->id }}" {!! \request("sector") && in_array($each->id, \request("sector")) ? "selected" : "" !!} data-airline_id ="{{ $each->airline_id }}">{{ $each->sector }}</option>
                        @endforeach
                    </select>
                @endif
            </div>
        </div>

        <div class="form-group marginBottomRight">
            <label class="control-label" for="from">@lang("content.from")</label>
            {!! Form::input('text', 'from', $from, ['class'=>'form-control dateFrom', 'id' => 'from_date']) !!}
        </div>

        <div class="form-group marginBottomRight">
            <label class="control-label" for="to">@lang("content.to")</label>
            {!! Form::input('text', 'to', $to, ['class'=>'form-control dateTo', 'id'=> 'to_date']) !!}
        </div>

        <div class="form-group marginBottomRight">
            <button type="submit" class="btn btn-primary">@lang("content.submit")</button>
        </div>
    </div>

{!! Form::close() !!}
