@php $postUrl = isset($postUrl) ? $postUrl : URL::full() @endphp
@php $disabled = isset($disabled) ? 'disabled' : '' @endphp
@php $picture = isset($picture) ? $picture : asset("/assets/img/default-user-picture.png") @endphp

<div id="crop-avatar" style="width: 100%;">
    <!-- Current avatar -->
    <div class="avatar-view" title="Change the picture" {{ $disabled }}>
        <img width="100%" src="{{ $picture }}" alt="Picture" class="{{ $disabled }}">
    </div>
    <div style="clear: both; text-align: right; width: 220px">
        {!! Form::open(['files'=>true, 'method' => 'DELETE' ,'url' => $postUrl]) !!}

            {!! Form::submit('Delete',['name' => 'imageDelete', 'class' => 'btn btn-danger', $disabled]) !!}

        {!! Form::close() !!}

        <!-- submit buttons -->
    </div>
    <!-- Cropping modal -->
    @include('user/layouts/crop-modal', ['postUrl' => $postUrl])

    <!-- Loading state -->
    <div class="loading" aria-label="Loading" role="img" tabindex="-1"></div>

    {{--Image Upload And Cropper--}}
    <link rel="stylesheet" href="{{ asset('/assets/cropper/cropper.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('/assets/cropper/cropper-main.css') }}" />
    {{--<script src="{{ asset('/assets/cropper/jquery.min.js') }}"></script>--}}
    {{--<script src="{{ asset('/assets/cropper/bootstrap.min.js') }}"></script>--}}

    {{--Active--}}
    <script src="{{ asset('/assets/cropper/cropper.min.js') }}"></script>
    <script src="{{ asset('/assets/cropper/cropper-main.js?2') }}"></script>
    {{--END--}}

    {{--<script src="{{ asset("/packages/bootstrap/bootstrap.min.js") }}"></script>--}}
    {{----------------------------}}

</div>