@php $postUrl = isset($postUrl) ? $postUrl : URL::full() @endphp
@php $disabled = isset($disabled) ? 'disabled' : '' @endphp
@php $picture = isset($picture) ? asset("storage/airlines/img/{$picture}") : asset("/assets/img/default-airline-picture.png") @endphp

<div id="crop-avatar" style="width: 100%; display: block">
    <!-- Current avatar -->
    <div class="avatar-view airline-view" title="Change the picture" {{ $disabled }}>
        <img width="100%" src="{{ $picture }}" alt="Picture" class="{{ $disabled }}">
    </div>

    <!-- Cropping modal -->
    @include('user/layouts/crop-modal', ['postUrl' => $postUrl])

    <!-- Loading state -->
    <div class="loading" aria-label="Loading" role="img" tabindex="-1"></div>

    {{--Image Upload And Cropper--}}
    <link rel="stylesheet" href="{{ asset('/assets/cropper/cropper.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('/assets/cropper/cropper-main.css?2') }}" />
    {{--<script src="{{ asset('/assets/cropper/jquery.min.js') }}"></script>--}}
    {{--<script src="{{ asset('/assets/cropper/bootstrap.min.js') }}"></script>--}}
    <script src="{{ asset('/assets/cropper/cropper.min.js') }}"></script>
    <script src="{{ asset('/assets/cropper/cropper-airline-main.js') }}"></script>
    {{--<script src="{{ asset("/packages/bootstrap/bootstrap.min.js") }}"></script>--}}
    {{----------------------------}}

</div>
