<?php require_once(public_path("smart/inc/init.php")); ?>

<style type="text/css">
    .form-group {margin-left: 10px}
    .form-group:first-child {margin-left: 0}
    #additional_fields {margin-top: 20px}
</style>

<!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => 'Commercial', 'moduleName' => 'Flight Query'])

            <span id="loading" style="display: none"><img src="{{ asset("/assets/img/2.GIF") }}" alt="loading..."></span>

            <div class="row">
                <form class="form-inline" method="get">
                    <div class="col-sm-12">
                        @if ($errors->all())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                        @endif
                        <div class="form-group marginBottomRight">
                            <label for="flight_type">Flight Type</label>
                            {!! Form::select('flight_type', $flightTypes, \request("flight_type"), ['class'=>'form-control singleselect input-sm', 'id'=>'flight_type']) !!}
                        </div>
                        <div class="form-group marginBottomRight">
                            <label for="aircraft">@lang("content.aircraft")</label>
                            {!! Form::select('aircraft', $aircraft, \request("aircraft"), ['class'=>'form-control singleselect input-sm', 'id'=>'aircraft']) !!}
                        </div>
                        <div class="form-group marginBottomRight">
                            <label>
                                {!! Form::radio("flight_condition", "is_flight_number", (\request("flight_condition") == "is_flight_number")) !!} Flight Number
                            </label>
                            {!! Form::select('n[]', $flightNumbers, \request("n"), ['id' => 'flight_number', 'class' => 'form-control multiselect input-sm', 'multiple' => 'multiple']) !!}
                        </div>

                        <div class="form-group marginBottomRight">
                            <label>
                                {!! Form::radio("flight_condition", "is_airport", (\request("flight_condition") == "is_airport")) !!} Departure Airport
                            </label>
                            {!! Form::select("departure_airport", $departureAirports, \request("departure_airport"), ['id'=>'departure_airport', 'class'=>'form-control singleselect input-sm']) !!}
                        </div>

                        <div class="form-group marginBottomRight">
                            <label for="departure_airport">Arrival Airport</label>
                            {!! Form::select("arrival_airport", $arrivalAirports, \request("arrival_airport"), ['id'=>'arrival_airport', 'class'=>'form-control singleselect input-sm']) !!}
                        </div>

                        <div class="form-group marginBottomRight">
                            <label class="checkbox">
                                {!! Form::checkbox("route", "1", \request("route")) !!} Route
                            </label>
                        </div>

                        <div class="form-group marginBottomRight">
                            <label>Delay</label>
                            {!! Form::checkbox("delay", 1, \request("delay")) !!}
                        </div>

                        <div class="form-group marginBottomRight">
                            <label>
                                {!! Form::radio("period", "period", (\request("period") == "period")) !!} Period
                            </label>
                            {!! Form::select("period_field", ["current_month" => "Current Month", "last_28_days" => "Last 28 Days", "last_90_days" => "Last 90 Days", "last_year" => "Last Year"], \request("period_field"), ['class' => 'form-control multiselect input-sm', 'id' => 'period_field']) !!}
                        </div>
                    </div>

                    <div class="col-sm-12">
                        <div class="form-group marginBottomRight">
                            <label>
                                {!! Form::radio("period", "departure_date", (\request("period") == "departure_date")) !!} Departure Date
                            </label>
                            <label>
                                {!! Form::radio("period", "arrival_date", (\request("period") == "arrival_date")) !!} Arrival Date
                            </label>
                        </div>
                        <div class="form-group marginBottomRight">
                            <label for="from">@lang("content.from")</label>
                            {!! Form::input("text", "from", \request("from"), ["class"=>"form-control input-sm inputDateSmall", "id"=>"from_date"]) !!}
                        </div>
                        <div class="form-group marginBottomRight">
                            <label for="to">@lang("content.to")</label>
                            {!! Form::input("text", "to", \request("to"), ["class"=>"form-control input-sm inputDateSmall", "id"=>"to_date"]) !!}
                        </div>
                        <div class="form-group marginBottomRight">
                            <button type="submit" class="btn btn-primary input-sm">@lang("content.submit")</button>
                        </div>
                </div>
                </form>
            </div>

            <div id="message-block"></div>

            <div>
                @if (isset($flights) && count($flights))
                {{--<div class="alert alert-success">{{ "Found: ". $flights->getTotal().' records.' }}</div>--}}
                <div>
                    <span class="color_item"><span class="flight_color delayed"></span> - Delayed</span>
                </div>

                <table class="table table-bordered table-striped table-hover">
                    <thead>
                        <tr>
                            <th>No.</th>
                            <th>@lang("content.aircraft")</th>
                            <th>@lang("content.flight_number")</th>
                            <th>@lang("content.route")</th>
                            <th>STD</th>
                            <th>ATD</th>
                            <th>STA</th>
                            <th>ATA</th>
                            {{--<th>Duration</th>--}}
                            <th>Rem. Fuel</th>
                        </tr>
                    </thead>
                    <tbody>
                    @php $pagination = \request("page") ? (\request("page") - 1) * $recordsPerPage : 0 @endphp
                    @forelse ($flights as $i=>$flight)
                    <tr class="{{ ($flight->delays) ? "danger" : "" }}">
                        <td>{{ $pagination + $i + 1 }}</td>
                        <td>{{ $flight->aircraft_name }}</td>
                        <td>{{ $flight->flight_number }}</td>
                        <td>{{ $flight->departure_airport . ' - ' . $flight->arrival_airport }}</td>
                        <td>{{ date('M d, Y H:i', strtotime($flight->std)) }}</td>
                        <td>{{ $flight->atd && $flight->atd != EMPTY_DATETIME ? date('M d, Y H:i', strtotime($flight->atd)) : "-" }}</td>
                        <td>{{ date('M d, Y H:i', strtotime($flight->sta)) }}</td>
                        <td>{{ $flight->ata && $flight->ata != EMPTY_DATETIME ? date('M d, Y H:i', strtotime($flight->ata)) : "-" }}</td>
            {{--            <td>{{ $flight->flights_delay_id }}</td>--}}
                        <td>{{ $flight->in_tanks }}</td>
                    </tr>
                    @empty
                    @endforelse
                    </tbody>
                </table>
                {{--{!! $flights->appends($_GET)->render() !!}--}}
                @elseif (is_array($_GET) && count($_GET))
                    <div class="alert alert-info">
                        <h4>No Result!</h4>
                        <p>Not found any flight for given params</p>
                    </div>
                @endif
            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter(".table");
    };

    loadScript("{{ asset("/assets/js/views/flightcrew/index.js") }}", pagefunction);

</script>