<?php require_once(public_path("smart/inc/init.php")); ?>

@php $envAirline = env(AIRLINE) @endphp

<!-- widget grid -->
<section id="widget-grid" class="bg-color-white">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <div class="col-md-12 padding-10">
                <div class="col-md-8 margin-bottom-10" style="display: inline-block">
                    <div style="float: left; margin-right: 10px;">
                        @php $airline = $flight->flightNumber->airline @endphp
                        @if ($airline)
                            <a target="_blank" href="{{ route("homepage")."#". url("/airline/{$airline->id}") }}" class="">
{{--                                <img class='flightTracker-airline-logo' src='{{ url("airline/picture/{$airline->id}") }}'/>--}}
                                <img  class='flightTracker-airline-logo' src='{{ asset("storage/airlines/img/{$airline->picture}") }}'/>
                            </a>
                        @endif
                    </div>
                    <div style="float: left;">
                        <h2 class="flightTracker-airline">Flight Handling Report</h2>
{{--                        <h2 class="flightTracker-airline">{{ $fn1 }}</h2>--}}
                        <h3 class="flightTracker-airline">{{ $fn2." / ".$fn3 }}</h3>
                    </div>
                </div>
                <div class="col-md-4 text-right">
                    <a href="{{ url("flight-view/fhr/excel/{$flight->id}") }}" class="btn btn-primary font-sm">Export to Excel</a>
                </div>
            </div>

            <div class="clearfix"></div>

            <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-reports" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                <header>
                    <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                    <h2>@lang("content.list")</h2>
                </header>

                <!-- widget div-->
                <div>

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->

                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body no-padding" style="min-height: 50px !important;">

                        <div class="table-responsive">

                            @include("flight.reports.ba-fhr-table", ["excludeLogo" => true])

                        </div>

                    </div>

                </div>

            </div>


        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyDateFormats();
        Apply_Multiselect();
        // ApplyTableFilter("#table-reports");

        ApplyFormSubmit();
    }

    pagefunction();

</script>
