@php $excludeLogo = isset($excludeLogo) && $excludeLogo ? $excludeLogo : false @endphp
@php $airline = $flight->flightNumber->airline @endphp
<table class="table table-bordered table-hover" id="table-reports" style="min-width: 100% !important;">
    <thead>
    @if (!$excludeLogo)
        <tr>
            <th>
                @if ($airline)
{{--                    <img class='flightTracker-airline-logo' src='{{ url("airline/picture/{$airline->id}") }}' />--}}
                    <img class='flightTracker-airline-logo' src='{{ public_path("storage/airlines/img/{$airline->thumb}") }}'/>
                @endif
            </th>
        </tr>
        <tr data-center>
            <th colspan="6">FLIGHT HANDLING REPORT</th>
        </tr>
    @endif
    <tr data-center>
        <th class="bg-color-gray" colspan="6">FLIGHT INFORMATION</th>
    </tr>
    </thead>
    <tbody>
    <tr data-center class="bg-color-light-gray">
        <th>DATE</th>
        <th colspan="2">FLT No</th>
        <th>A/C Type</th>
        <th>A/C REG</th>
        <th>ROUTE</th>
    </tr>
    <tr data-center>
        <td>{{ baseDateFormat(getFlightDepartureDate($flight, true), false, ".") }}</td>
        <td colspan="2">{{ getFlightNumber($flight, "") }}</td>
        <td>{{ getFlightAircraftType($flight) }}</td>
        <td>{{ getFlightAircraft($flight) }}</td>
        <td>{{ getFlightSector($flight) }}</td>
    </tr>
    <tr data-center class="bg-color-light-gray">
        <th>CONFIG</th>

        <th>L/F</th>
        <th>BOOKED</th>

        <th>BOARDING GATE</th>
        <th>ARRIVAL ATA</th>
        <th>STD</th>
    </tr>
    <tr data-center>
        @php $capacity = getFlightCapacity($flight) @endphp
        @php $booked = getFlightBookedPax($flight) @endphp
        @php $loadFactor = getFlightLoadFactor($flight) @endphp

        <td>
            @if ($capacity[0])
                <span class="margin-right-20">
                    C{{ $capacity[0] }}
                </span>
            @endif

            <span>Y{{ $capacity[1] ? $capacity[1] : "" }}</span>
        </td>

        <td>{{ $loadFactor ? $loadFactor : "" }}%</td>

        <td>
            @if ($capacity[0] || $booked[0])
                <span class="margin-right-20">C{{ $booked[0] ? $booked[0] : "" }}</span>
            @endif

            <span>Y{{ $booked[1] ? $booked[1] : "" }}</span>
        </td>

        <td>{{ $flight->gate_boarding }}</td>
        <td>
            @if ($flight->flightParent && $flight->flightParent->ata && $flight->flightParent->ata != EMPTY_DATETIME)
                {{ baseDateFormat($flight->flightParent->ata, true, ".") }}
            @endif
        </td>
        <td>{{ baseDateFormat($flight->std, true, ".") }}</td>
    </tr>
    <tr data-center class="bg-color-light-gray">
        <th colspan="3">CHECK-IN AGENTS</th>

        <th>GATE AGENT-1</th>
        <th>GATE AGENT-2</th>
        <th>TRC</th>
    </tr>
    @php $gateAgents = $flightCom ? ($flightCom->gate_staff ? explode("/", $flightCom->gate_staff) : []) : [] @endphp
    @php $ckinStaff = getStaffListBySLA($flight->staffList, "CKIN") @endphp
    @php $gateStaff = getStaffListBySLA($flight->staffList, "GATE") @endphp
    @php $trcStaff = getStaffListBySLA($flight->staffList, "TRC") @endphp

    <tr data-center>
        <td colspan="3">
            @if (count($ckinStaff))
                {{ implode(", ", $ckinStaff) }}
            @else
                {{ $flightCom ? $flightCom->ckin_staff : "" }}
            @endif
        </td>

        <td>{{ isset($gateStaff[0]) ?  $gateStaff[0] : (isset($gateAgents[0]) ? $gateAgents[0] : "") }}</td>
        <td>{{ isset($gateStaff[1]) ?  $gateStaff[1] : (isset($gateAgents[1]) ? $gateAgents[1] : "") }}</td>
        <td>
            @if (count($trcStaff))
                {{ implode(", ", $trcStaff) }}
            @else
                {{ $flightCom ? $flightCom->trc : "" }}
            @endif
        </td>
    </tr>

    <tr data-center>
        <th class="bg-color-gray" colspan="6">BOARDING</th>
    </tr>

    <tr data-center class="bg-color-light-gray">
        <th>GATE OPEN</th>
        <th colspan="3">CREW AT GATE</th>
        <th colspan="2">BOARDING START TIME</th>
    </tr>
    <tr data-center>
        <td>{{ $pts ? baseTimeFormat($pts->gate_open) : "" }}</td>
        <td colspan="3">{{ $pts ? baseTimeFormat($pts->crew_at_gate) : "" }}</td>
        <td colspan="2">{{ $pts ? baseTimeFormat($pts->boarding_start_time) : "" }}</td>
    </tr>

    <tr data-center class="bg-color-light-gray">
        <th>1ST PAX BOARDED AT GATE</th>
        <th colspan="2">LAST PAX BOARDED AT GATE</th>
        <th>1ST PAX ON-BOARD</th>
        <th>LAST PAX ON-BOARD</th>
        <th>GATE SPVR</th>
    </tr>
    <tr data-center>
        <td>{{ $pts ? baseTimeFormat($pts->first_pax_boarded) : "" }}</td>
        <td colspan="2">{{ $pts ? baseTimeFormat($pts->last_pax_boarded) : "" }}</td>
        <td>{{ $pts ? baseTimeFormat($pts->board_pax) : "" }}</td>
        <td>{{ $pts ? baseTimeFormat($pts->all_pax_onboard) : "" }}</td>
        <td>{{ $flightCom ? $flightCom->gate_spvr : "" }}</td>
    </tr>

    <tr data-center>
        <th class="bg-color-gray" colspan="6">RAMP</th>
    </tr>

    <tr data-center class="bg-color-light-gray">
        <th>1ST BAG LOADED</th>
        <th colspan="3">LAST BAG LOADED</th>
        <th>BAG SEARCH STARTED</th>
        <th>BAG SEARCH FINISHED</th>
    </tr>
    <tr data-center>
        <td>{{ $pts ? baseTimeFormat($pts->first_bag_loaded) : "" }}</td>
        <td colspan="3">{{ $pts ? baseTimeFormat($pts->last_bag_loaded) : "" }}</td>
        <td>{{ $pts ? baseTimeFormat($pts->bag_search_started) : "" }}</td>
        <td>{{ $pts ? baseTimeFormat($pts->bag_search_finished) : "" }}</td>
    </tr>

    <tr data-center class="bg-color-light-gray">
        <th>CLEANING STARTED</th>
        <th colspan="3">CLEANING FINISHED</th>
        <th>FUELLING STARTED</th>
        <th>FUELLING FINISHED</th>
    </tr>
    <tr data-center>
        <td>{{ $pts ? baseTimeFormat($pts->cleaners_onboard) : "" }}</td>
        <td colspan="3">{{ $pts ? baseTimeFormat($pts->cleaners_off) : "" }}</td>
        <td>{{ $pts ? baseTimeFormat($pts->fuelling_started) : "" }}</td>
        <td>{{ $pts ? baseTimeFormat($pts->fuelling_finished) : "" }}</td>
    </tr>

    <tr data-center>
        <th class="bg-color-gray" colspan="6">FINALS</th>
    </tr>
    <tr data-center class="bg-color-light-gray">
        <th>ACCEPTED PAX</th>
        <th colspan="2">TTL ON-BOARD</th>
        <th>TTL BAGS ON-BOARD</th>
        <th colspan="2">SPECIALS (PRM/WEAP/CBBG) ETC</th>
    </tr>
    @php $totalOnBoard = getFlightActualPaxTotal($flight); @endphp
    <tr data-center>
        <td>{{ $pts ? $pts->accepted_pax : "" }}</td>
        <td colspan="2">{{ $totalOnBoard ? $totalOnBoard : "" }}</td>
        <td>{{ $flight->baggage_pcs }}</td>
        <td colspan="2">{{ $flightCom ? $flightCom->specials : "" }}</td>
    </tr>

    <tr data-center class="bg-color-light-gray">
        <th>DCT</th>
        <th colspan="2">ATD</th>
        <th>RTG</th>
        <th colspan="2">Delay code and time</th>
    </tr>
    <tr data-center>
        <td>{{ $pts ? baseTimeFormat($pts->all_doors_closed) : "" }}</td>
        <td colspan="2">
            @if ($flight->atd && $flight->atd != EMPTY_DATETIME)
                {{ baseDateFormat($flight->atd, true, ".") }}
            @endif
        </td>
        <td>{{ $pts ? baseTimeFormat($pts->rtg) : "" }}</td>
        <td colspan="2">
            @if ($flight->delaysString && count($flight->delaysString))
                @foreach($flight->delaysString as $each)
                    {{ $each }} |
                @endforeach
            @endif
        </td>
    </tr>

    <tr data-center class="bg-color-gray">
        <th></th>
        <th colspan="5">FEEDBACK - CHECK-IN / GATE / RAMP</th>
    </tr>
    <tr>
        <th>MISSED ARTG -5  EXPLAINATION</th>
        <td colspan="5">{{ $pts ? $pts->missed_artg : "" }}</td>
    </tr>
    <tr>
        <th>DELAY EXPLAINATION</th>
        <td colspan="5">{{ $pts ? $pts->delay : "" }}</td>
    </tr>
    <tr>
        <th>CHECK-IN / TKTG ISSUES</th>
        <td colspan="5">{{ $pts ? $pts->ckn : "" }}</td>
    </tr>
    <tr>
        <th>RAMP/ CREW / DISRUPTIVE PAX ETC</th>
        <td colspan="5">{{ $pts ? $pts->ramp : "" }}</td>
    </tr>
    <tr>
        <th>SAFETY / SECURITY / SYSTEM ISSUES</th>
        <td colspan="5">{{ $pts ? $pts->safety : "" }}</td>
    </tr>
    <tr>
        <th>OTHER</th>
        <td colspan="5">{{ $pts ? $pts->other : "" }}</td>
    </tr>

    @if ($pts)
        <tr class="bg-color-light-gray">
            <th colspan="6">INVOL DENIED BOARDING</th>
        </tr>
        @for($i = 1; $i <= 6; $i++)
            @if ($item = $pts->{"denied_boarding".$i})
                <tr>
                    <td colspan="6">{{ $pts ? $pts->{"denied_boarding".$i} : "" }}</td>
                </tr>
            @endif
        @endfor
    @endif
    </tbody>
</table>
