<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov


 * Project: aviation.dev
 */
?>
<script type="text/template" id="general_tab_template">
    <div class="row" style="margin-bottom: 8px">
        <h3 id="m_dep_airport" class="col-xs-1 pull-left text-warning"><%= departureCityCode %></h3>
        <div id="flight-progress" class="col-xs-10" style="position: relative; top: 10px">
            <div class="progress" style="margin: 22px 0 0 0; height: 13px; padding: 1px">
                <div class="progress-bar progress-bar-success" role="progressbar" aria-valuenow="40" aria-valuemin="0"
                    aria-valuemax="100" style="width: <%= flightBarPosition %>px;">
                </div>
            </div>
            <div style="position: absolute; top: 5px; left: <%= flightPosition %>px">
                <img src="{!! route("homepage")."#". url("/") !!}/assets/img/flight_plane.png" alt="flight icon"/>
            </div>
        </div>
        <h3 id="m_arr_airport" class="col-xs-1 pull-right text-warning"><%= arrivalCityCode %></h3>
        <div class="clearfix"></div>
    </div>
    <div>
        <div class="pull-left">
            <h3 class="text-primary" style="padding-top: 0; margin-top: 0">
                <span class="font14">@lang("content.departure")</span>
                <span id="m_dep_city"><%= departureCity %></span>
            </h3>
        </div>
        <div class="pull-right">
            <h3 class="text-primary text-right" style="padding-top: 0; margin-top: 0">
                <span class="font14">@lang("content.arrival")</span>
                <span id="m_arr_city"><%= arrivalCity %></span>
            </h3>
        </div>
        <div class="clearfix"></div>

        <div class="panel panel-info" style="margin-bottom: 11px">
          <div class="panel-heading" style="padding: 5px 15px"></div>
          <div class="panel-body" style="padding: 0 10px">
            <!-- departure dates table -->
            <table class="table text-center table-condensed">
                <thead>
                    <tr>
                        <th>STD</th>
                        <th>ETD</th>
                        <th>ATD</th>
                        <th>ABN</th>
                        <th>STA</th>
                        <th>ETA</th>
                        <th>ATA</th>
                        <th>TDN</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td id="m_std" class="text-success"><%= std %></td>
                        <td id="m_etd" class="text-danger"><%= etd %></td>
                        <td id="m_atd" class="text-danger"><%= atd %></td>
                        <td id="m_abn" class="text-danger"><%= abn %></td>
                        <td id="m_sta" class="text-success"><%= sta %></td>
                        <td id="m_eta" class="text-danger"><%= eta %></td>
                        <td id="m_ata" class="text-danger"><%= ata %></td>
                        <td id="m_tdn" class="text-danger"><%= tdn %></td>
                    </tr>
                </tbody>
            </table>
          </div>
        </div>

        <!-- pax actually table -->
        <div class="panel panel-info" style="margin-bottom: 11px">
          <div class="panel-heading" style="padding: 5px 15px"></div>
          <div class="panel-body" style="padding: 0 10px">
                <table class="table text-center table-condensed">
                    <thead>
                    <tr>
                        <th style="width: 150px">PAX ACT</th>
                        <th>C</th>
                        <th>Y</th>
                        <th>INF</th>
                        <th style="width: 150px">PAX BKD</th>
                        <th>C</th>
                        <th>Y</th>
                        <th>INF</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td></td>
                        <td id="m_pax_actually_c"><%= pax_actually_c %></td>
                        <td id="m_pax_actually_y"><%= pax_actually_y %></td>
                        <td id="m_pax_actually_inf"><%= pax_actually_inf %></td>
                        <td></td>
                        <td id="m_pax_booked_c"><%= pax_booked_c %></td>
                        <td id="m_pax_booked_y"><%= pax_booked_y %></td>
                        <td id="m_pax_booked_inf"><%= pax_booked_inf %></td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- baggage table -->
        <div class="panel panel-info" style="margin-bottom: 11px">
          <div class="panel-heading" style="padding: 5px 15px"></div>
          <div class="panel-body" style="padding: 0 10px">
            <table class="table text-center table-condensed">
                <thead>
                <tr>
                    <th>BAGGAGE</th>
                    <th>CARGO</th>
                    <th>MAIL</th>
                    <th>@lang("content.total")</th>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <td id="m_baggage">
                        <table class="table table-condensed">
                            <tr>
                                <td style="border-top: none">Allowance</td>
                                <td style="border-top: none">Actual</td>
                                <td style="border-top: none">E.B.</td>
                                <td style="border-top: none">E.B. Revenue</td>
                            </tr>
                            <tr>
                                <td><%= baggage_allowance %></td>
                                <td><%= (baggage) ? baggage : '&mdash;' %></td>
                                <td><%= excess_baggage %></td>
                                <td>$<%= excess_baggage_revenue %></td>
                            </tr>
                        </table>
                    </td>
                    <td id="m_cargo">
                        <table class="table table-condensed">
                            <tr>
                                <td style="border-top: none">Kgs</td>
                                <td style="border-top: none">@lang("content.revenue")</td>
                            </tr>
                            <tr>
                                <td><%= cargo %></td>
                                <td>$<%= cargo_revenue %></td>
                            </tr>
                        </table>
                    </td>
                    <td id="m_mails">
                        <table class="table table-condensed">
                            <tr>
                                <td style="border-top: none">Kgs</td>
                                <td style="border-top: none">@lang("content.revenue")</td>
                            </tr>
                            <tr>
                                <td><%= mail %></td>
                                <td>$<%= mail_revenue %></td>
                            </tr>
                        </table>
                    </td>
                    <td rowspan="2">
                        <div style="font-weight: bold; margin-top: 20px">
                        $<%= total_revenue %>
                        </div>
                    </td>
                </tr>
                </tbody>
            </table>
          </div>
        </div>

        <!-- fuel table -->
        <div class="panel panel-info" style="margin-bottom: 11px">
          <div class="panel-heading" style="padding: 5px 15px"></div>
          <div class="panel-body" style="padding: 0 10px">
            <table class="table text-center table-condensed">
                <thead>
                <tr>
                    <th>FUEL</th>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <td id="m_baggage">
                        <table class="table table-condensed">
                            <tr>
                                <td style="border-top: none">In tanks</td>
                                <td style="border-top: none">Uplifted</td>
                                <td style="border-top: none">@lang("content.departure")</td>
                                <td style="border-top: none">Utilised</td>
                                <td style="border-top: none">@lang("content.arrival")</td>
                            </tr>
                            <tr>
                                <td><%= in_tanks %></td>
                                <td><%= uplifted %></td>
                                <td><%= dep_fuel %></td>
                                <td><%= utilised %></td>
                                <td><%= arr_fuel %></td>
                            </tr>
                        </table>
                    </td>
                </tr>
                </tbody>
            </table>
          </div>
        </div>
    </div>
</script>
