<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov


 * Project: aviation.dev
 */
?>

    <div class="row" style="margin-bottom: 8px;">
        <h4 id="m_dep_airport" data-toggle="tooltip" data-placement="top" data-original-title="<%= departureCity %>" class="col-xs-1 pull-left text-warning"><%= departureCityCode %></h4>
        <div id="flight-progress" class="col-xs-10" style="position: relative; top: 10px;">
            <div class="progress progress-striped" style="margin: 10px 0 0 0; height: 10px; padding: 0px;">
                <div class="progress-bar" role="progressbar" aria-valuenow="40" aria-valuemin="0"
                    aria-valuemax="100" style="width: <%= flightBarPosition %>%;">
                </div>
            </div>
            <div style="position: absolute; bottom: <%= 0 %>px; left: <%= flightPosition %>px; width: 105px !important;">
                <img width="<%= planeWidth %>%" src="{!! asset("/assets/img/planeSomonAir.png") !!}" alt="flight icon"/>
            </div>
        </div>

        <h4 id="m_arr_airport" data-toggle="tooltip" data-placement="top" data-original-title="<%= arrivalCity %>" class="col-xs-1 pull-right text-warning"><%= arrivalCityCode %></h4>
        <div class="clearfix"></div>
    </div>
    <div class="row">
        <div class="clearfix"></div>

        <!-- Departure, Arrival Information -->
        @if ($userModules && in_array(1, $userModules[$module->id]))
        <div class="col-md-12">
            <strong><%= delays %></strong>
        </div>

        <div class="col-md-12">
            <!-- departure dates table -->
            <table class="modal_tab">
                <thead>
                    <tr>
                        <th>STD</th>
                        <th>ETD</th>
                        <th>ATD</th>
                        <th>ABN</th>
                        <th>STA</th>
                        <th>ETA</th>
                        <th>TDN</th>
                        <th>ATA</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td id="m_std" class="text-success"><%= std %></td>
                        <td id="m_etd" class="text-danger"><%= etd %></td>
                        <td id="m_atd" class="text-danger"><%= atd %></td>
                        <td id="m_abn" class="text-danger"><%= abn %></td>
                        <td id="m_sta" class="text-success"><%= sta %></td>
                        <td id="m_eta" class="text-danger"><%= eta %></td>
                        <td id="m_tdn" class="text-danger"><%= tdn %></td>
                        <td id="m_ata" class="text-danger"><%= ata %></td>
                    </tr>

                </tbody>
            </table>
        </div>
        @endif

        <!-- PAX Info -->
        @if ($userModules && in_array(2, $userModules[$module->id]))
        <div class="col-md-12">
            <table class="modal_tab not_alternate">
                <thead>
                    <tr>
                        <th style="width: 150px">PAX ACT</th>
                        <th>C</th>
                        <th>Y</th>
                        <th>INF</th>
                        <th style="width: 150px">PAX BKD</th>
                        <th>C</th>
                        <th>Y</th>
                        <th>INF</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td></td>
                        <td id="m_pax_actually_c"><%= pax_actually_c %></td>
                        <td id="m_pax_actually_y"><%= pax_actually_y %></td>
                        <td id="m_pax_actually_inf"><%= pax_actually_inf %></td>
                        <td></td>
                        <td id="m_pax_booked_c"><%= pax_booked_c %></td>
                        <td id="m_pax_booked_y"><%= pax_booked_y %></td>
                        <td id="m_pax_booked_inf"><%= pax_booked_inf %></td>
                    </tr>
                    </tbody>
                </table>
            </div>
        @endif

        @if ($userModules && in_array(3,$userModules[$module->id]))
        <div class="col-md-12">
           <table class="modal_tab">
                <thead>
                    <tr>
                        <th colspan="4">BAGGAGE</th>
                        <th colspan="2">CARGO</th>
                        <th colspan="2">MAIL</th>
                        <th>@lang("content.total")</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        {{--Baggage--}}
                        <td style="border-top: none">Allowance</td>
                        <td style="border-top: none">Actual</td>
                        <td style="border-top: none">E.B.</td>
                        <td style="border-top: none">E.B. Revenue</td>
                        {{--Cargo--}}
                        <td style="border-top: none">Kgs</td>
                        {{--<td style="border-top: none">Cargo 200</td>--}}
                        <td style="border-top: none">@lang("content.revenue")</td>
                        {{--Mail--}}
                        <td style="border-top: none">Kgs</td>
                        <td style="border-top: none">@lang("content.revenue")</td>
                        {{--Total--}}
                        <td style="border-top: none">USD</td>

                    </tr>
                    <tr>
                        {{--Baggage--}}
                        <td><%= baggage_allowance %></td>
                        <td><%= (baggage) ? baggage : '&mdash;' %></td>
                        <td><%= excess_baggage %></td>
                        <td>$<%= excess_baggage_revenue %></td>
                        {{--Cargo--}}
                        <td><%= cargo %></td>
                        {{--<td><%= eic %></td>--}}
                        <td>$<%= cargo_revenue %></td>
                        {{--Mail--}}
                        <td><%= mail %></td>
                        <td>$<%= mail_revenue %></td>
                        {{--USD--}}
                        <td>$<%= total_revenue %></td>
                    </tr>
                </tbody>
            </table>
        </div>
        @endif

        <!-- Crew Information -->
        <div class="col-md-12">

        @if ($userModules && count(array_intersect([4,5] ,$userModules[$module->id])))
            <div class="col-sm-9"  style="padding: 5px 5px 5px 0" >
                <div class="panel panel-primary modal_tab_panel">
                    <div class="panel-heading">
                        <a style="color: white; font-weight: bold" class="accordion-toggle" data-toggle="collapse" href="#crew_information_panel">
                            CREW INFORMATION: <i class="fa fa-chevron-down"></i>
                        </a>
                    </div>
                    <div class="panel-body collapse in" id="crew_information_panel">
                        <h5 style="margin: 0 0 5px">OPERATION CREW</h5>
                        <table class="table table-bordered table-striped table-hover">
                            @if ($userModules && in_array(5,$userModules[$module->id]))
                                <tr>
                                    <td style="width: 150px"><strong>CAPTAIN(s):</strong></td>
                                    <td id="m_captains"><%= (captains) ? captains : "&mdash;" %></td>
                                    <td style="width: 50px"><strong class="text-warning">STBY</strong></td>
                                    <td style="width: 100px" class="text-warning"><%= (captains_standby) ? captains_standby : "&mdash;" %></td>
                                </tr>
                                <tr>
                                    <td><strong>FIRST OFFICER(s):</strong></td>
                                    <td id="m_first_officers"><%= (first_officers) ? first_officers : "&mdash;" %></td>
                                    <td style="width: 50px"><strong class="text-warning">STBY</strong></td>
                                    <td style="width: 100px" class="text-warning"><%= (first_officers_standby) ? first_officers_standby : "&mdash;" %></td>
                                </tr>
                            @endif

                            @if ($userModules && in_array(4,$userModules[$module->id]))
                                <tr>
                                    <td><strong>CABIN CREW:</strong></td>
                                    <td id="m_cabin_crew"><%= (cabin_crew) ? cabin_crew : "&mdash;" %></td>
                                    <td style="width: 50px"><strong class="text-warning">STBY</strong></td>
                                    <td style="width: 100px" class="text-warning"><%= (cabin_crew_standby) ? cabin_crew_standby : "&mdash;" %></td>
                                </tr>
                                <tr>
                                    <td><strong>CABIN CREW SUP:</strong></td>
                                    <td colspan="3"><%= (cabin_crew_sup) ? cabin_crew_sup : "&mdash;" %></td>
                                </tr>
                            @endif
                        </table>
                        <h5 style="margin: 0 0 5px">DHC</h5>
                        <table class="base not_">
                            @if ($userModules && in_array(5,$userModules[$module->id]))
                                <tr>
                                    <td style="width: 150px"><strong>CAPTAIN(s):</strong></td>
                                    <td id="m_captains_dhc"><%= (captains_dhc) ? captains_dhc : "&mdash;" %></td>
                                </tr>
                                <tr>
                                    <td><strong>FIRST OFFICER(s):</strong></td>
                                    <td id="m_first_officers_dhc"><%= (first_officers_dhc) ? first_officers_dhc : "&mdash;" %></td>
                                </tr>
                            @endif

                            @if ($userModules && in_array(4,$userModules[$module->id]))
                                <tr>
                                    <td><strong>CABIN CREW:</strong></td>
                                    <td id="m_cabin_crew_dhc"><%= (cabin_crew_dhc) ? cabin_crew_dhc : "&mdash;" %></td>
                                </tr>
                            @endif

                        </table>
                    </div>
                </div>
            </div>
            @endif

            <style type="text/css">
                .col-sm-3 .dl-horizontal dt {
                    font-size: 12px;
                    font-weight: normal;
                    margin-bottom: 10px;
                }
            </style>

            <!-- Fuel Information -->
            @if ($userModules && in_array(6,$userModules[$module->id]))
                <div class="col-sm-3" style="padding: 5px 0 5px 5px">
                    <div class="panel panel-primary modal_tab_panel">
                        <div class="panel-heading">
                            <a style="color: white; font-weight: bold" class="accordion-toggle" data-toggle="collapse" href="#fuel_information_panel">
                                FUEL <i class="fa fa-chevron-down"></i>
                            </a>
                        </div>
                        <div class="panel-body collapse in" id="fuel_information_panel">
                            <dl class="dl-horizontal" style="margin-bottom: 0">
                                <dt>In tanks</dt>
                                <dd><%= in_tanks %></dd>
                                <dt>Uplifted</dt>
                                <dd><%= uplifted %></dd>
                                <dt>@lang("content.departure")</dt>
                                <dd><%= dep_fuel %></dd>
                                <dt>Utilised</dt>
                                <dd><%= utilised %></dd>
                                <dt>@lang("content.arrival")</dt>
                                <dd><%= arr_fuel %></dd>
                            </dl>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
