{{--@if (isset($userModules) && isset($module) && isset($userModules[$module->id]) && in_array(10, $userModules[$module->id]))--}}

        <!-- widget div-->
<div class="fleetwatch_form">

    {!! Form::open(['url' => url('flight/add'), 'method' => "post", 'class' => 'form-horizontal', 'id' => 'form_fleetwatch']) !!}

            <!-- widget edit box -->
    <div class="jarviswidget-editbox">
        <!-- This area used as dropdown edit box -->
    </div>
    <!-- end widget edit box -->

    <!-- widget content -->
    <div class="widget-body">

        <ul id="myTab1" class="nav nav-tabs bordered">
            <li class="active">
                <a href="#s1" data-toggle="tab"><i class="fa fa-plane fa-lg"></i> Flight Details</a>
            </li>
            <li>
                <a href="#s2" data-toggle="tab"><i class="fa fa-user fa-lg"></i> Crew</a>
            </li>
            <li>
                <a href="#s3" data-toggle="tab"><i class="fa fa-list fa-lg"></i> MVT</a>
            </li>
        </ul>

        <div id="myTabContent1" class="tab-content padding-10">
            <div class="tab-pane fade in active" id="s1">

                <div class="subcategory_items">

                    <div class="col-md-12 col-lg-12">

                        <div class="form-group col-md-3">
                            <label class="col-md-5 control-label">@lang("content.aircraft")</label>
                            <div class="col-md-7">
                                {!! Form::select('aircraft_id', $aircraft, null, ['class'=>'form-control', 'id'=>'aircraft_id', 'required'=>'required']) !!}
                            </div>
                        </div>

                        <div class="form-group col-md-3">
                            <label class="col-md-5 control-label">Flight No.</label>
                            <div class="col-md-7">
                                {!! Form::select('flight_number_id', $flightsSelectBox, null, ['class'=>'form-control input-sm', 'id'=>'flight_number_id', 'required'=>'required']) !!}
                            </div>
                        </div>

                        <div class="form-group col-md-3">
                            <div class="col-md-6">
                                <label class="checkbox-inline">
                                    {!! Form::checkbox('manual_flt_no', 'value', false, ['id' => 'manual_flt_no']) !!}
                                    Manual Flt No
                                </label>
                            </div>
                            <div class="col-md-6">
                                <label class="checkbox-inline">
                                    {!! Form::checkbox('is_diversion', 'value', false, ['id' => 'is_diversion']) !!}
                                    Diversion
                                </label>
                            </div>
                        </div>

                        <div class="form-group col-md-3" style="display: none" id="diversion_airport_block">
                            <label class="col-md-6 control-label">Diversion Airport</label>
                            <div class="col-md-6 has-warning">
                                {!! Form::select('diversion_airport', $diversionAirports, null, ['class'=>'form-control input-sm', 'id'=>'diversion_airport']) !!}
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12 col-lg-12" style="display: none" id="outbound_flight_number_block">
                        <label class="col-md-6 control-label">Connect to outbound</label>
                        <div class="col-md-6 has-warning">
                            {!! Form::select('outbound_flight_number_id', ["" => "Select Flight Number"], null, ['class'=>'form-control input-sm', 'id'=>'outbound_flight_number_id']) !!}
                        </div>
                    </div>

                    <div id="manual_flt_no_div" class="col-sm-12" style="display: none">

                        <div class="form-group col-md-3">
                            <label class="col-md-5 control-label">@lang("content.flight_number")</label>
                            <div class="col-md-7">
                                {!! Form::text('flt_no', null, ['class' => 'form-control', 'id' => 'flt_no']) !!}
                            </div>
                        </div>

                        <div class="form-group col-md-3">
                            <label class="col-md-5 control-label">Departure Airport</label>
                            <div class="col-md-7">
                                {!! Form::select('departure_airport', $airports, null, ['class' => 'form-control', 'id' => 'departure_airport']) !!}
                            </div>
                        </div>

                        <div class="form-group col-md-3">
                            <label class="col-md-5 control-label">Arrival Airport</label>
                            <div class="col-md-7">
                                {!! Form::select('arrival_airport', $airports, null, ['class' => 'form-control', 'id' => 'arrival_airport']) !!}
                            </div>
                        </div>

                        <div class="form-group col-md-3">
                            <label class="col-md-5 control-label">Flight Type</label>
                            <div class="col-md-7">
                                {!! Form::select('flight_type', $flightTypes, null, ['class' => 'form-control', 'id' => 'flight_type']) !!}
                            </div>
                        </div>

                    </div>

                    <div class="form-group">

                        <div class="form-group col-sm-12 col-md-5">

                            <label class="col-sm-1 control-label">STD</label>
                            <div class="col-sm-5">
                                {!! Form::text('std', null, ['class'=>'form-control input-sm datetimepicker fleetwatch-timing', 'id'=>'std', 'required'=>'required']) !!}
                            </div>

                            <label class="col-sm-1 control-label">PTD</label>
                            <div class="col-sm-5">
                                {!! Form::text('ptd', null, ['class'=>'form-control input-sm datetimepicker fleetwatch-timing', 'id'=>'ptd']) !!}
                            </div>

                        </div>

                        <div class="form-group col-sm-12 col-md-5">

                            <label class="col-sm-1 control-label">ETD</label>
                            <div class="col-sm-5">
                                {!! Form::text('etd', null, ['class'=>'form-control input-sm datetimepicker fleetwatch-timing', 'id'=>'etd']) !!}
                            </div>

                            <label class="col-sm-1 control-label">ATD</label>
                            <div class="col-sm-5">
                                {!! Form::text('atd', null, ['class'=>'form-control input-sm datetimepicker fleetwatch-timing', 'id'=>'atd']) !!}
                            </div>

                        </div>

                        <div class="form-group col-sm-6 col-md-2">
                            <label class="col-sm-2 control-label text-center">ABN</label>
                            <div class="col-sm-10">
                                {!! Form::text('abn', null, ['class'=>'form-control input-sm datetimepicker fleetwatch-timing', 'id'=>'abn']) !!}
                            </div>
                        </div>

                    </div>

                    <div class="form-group has-warning" style="display: none" id="diversion_arrival">
                        <div class="form-group col-md-4 col-lg-3">
                            <label class="col-md-4 control-label">PTA</label>
                            <div class="col-md-8 text-warning">
                                {!! Form::text('diversion_sta', null, ['class'=>'form-control input-sm datetimepicker fleetwatch-timing', 'id'=>'diversion_sta']) !!}
                            </div>
                        </div>
                        <div class="form-group col-md-4 col-lg-3">
                            <label class="col-md-4 control-label">ETA</label>
                            <div class="col-md-8 text-warning">
                                {!! Form::text('diversion_eta', null, ['class'=>'form-control input-sm datetimepicker fleetwatch-timing', 'id'=>'diversion_eta']) !!}
                            </div>
                        </div>
                        <div class="form-group col-md-4 col-lg-3">
                            <label class="col-md-4 control-label">TDN</label>
                            <div class="col-md-8 text-warning">
                                {!! Form::text('diversion_tdn', null, ['class'=>'form-control input-sm datetimepicker fleetwatch-timing', 'id'=>'diversion_tdn']) !!}
                            </div>
                        </div>
                        <div class="form-group col-md-4 col-lg-3">
                            <label class="col-md-4 control-label">ATA</label>
                            <div class="col-md-8 text-warning">
                                {!! Form::text('diversion_ata', null, ['class'=>'form-control input-sm datetimepicker fleetwatch-timing', 'id'=>'diversion_ata']) !!}
                            </div>
                        </div>
                    </div>

                    <div class="form-group has-warning" style="display: none" id="diversion_departure">
                        <div class="form-group col-md-4 col-lg-3">
                            <label class="col-md-4 control-label">PTD</label>
                            <div class="col-md-8 text-warning">
                                {!! Form::text('diversion_std', null, ['class'=>'form-control input-sm datetimepicker fleetwatch-timing', 'id'=>'diversion_std']) !!}
                            </div>
                        </div>
                        <div class="form-group col-md-4 col-lg-3">
                            <label class="col-md-4 control-label">ETD</label>
                            <div class="col-md-8 text-warning">
                                {!! Form::text('diversion_etd', null, ['class'=>'form-control input-sm datetimepicker fleetwatch-timing', 'id'=>'diversion_etd']) !!}
                            </div>
                        </div>
                        <div class="form-group col-md-4 col-lg-3">
                            <label class="col-md-4 control-label">ATD</label>
                            <div class="col-md-8 text-warning">
                                {!! Form::text('diversion_atd', null, ['class'=>'form-control input-sm datetimepicker fleetwatch-timing', 'id'=>'diversion_atd']) !!}
                            </div>
                        </div>
                        <div class="form-group col-md-4 col-lg-3">
                            <label class="col-md-4 control-label">ABN</label>
                            <div class="col-md-8 text-warning">
                                {!! Form::text('diversion_abn', null, ['class'=>'form-control input-sm datetimepicker fleetwatch-timing', 'id'=>'diversion_abn']) !!}
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="form-group col-sm-12 col-md-5">
                            <label class="col-sm-1 control-label">STA</label>
                            <div class="col-sm-5">
                                {!! Form::text('sta', null, ['class'=>'form-control input-sm datetimepicker fleetwatch-timing', 'id'=>'sta', 'required'=>'required']) !!}
                            </div>

                            <label class="col-sm-1 control-label">PTA</label>
                            <div class="col-sm-5">
                                {!! Form::text('pta', null, ['class'=>'form-control input-sm datetimepicker fleetwatch-timing', 'id'=>'pta']) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-12 col-md-5">
                            <label class="col-sm-1 control-label">ETA</label>
                            <div class="col-sm-5">
                                {!! Form::text('eta', null, ['class'=>'form-control input-sm datetimepicker fleetwatch-timing', 'id'=>'eta']) !!}
                            </div>

                            <label class="col-sm-1 control-label">TDN</label>
                            <div class="col-sm-5">
                                {!! Form::text('tdn', null, ['class'=>'form-control input-sm datetimepicker fleetwatch-timing', 'id'=>'tdn']) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-6 col-md-2">
                            <label class="col-sm-2 control-label text-center">ATA</label>
                            <div class="col-sm-10">
                                {!! Form::text('ata', null, ['class'=>'form-control input-sm datetimepicker fleetwatch-timing', 'id'=>'ata']) !!}
                            </div>
                        </div>

                    </div>

                    <hr/>
                    <div class="form-group">
                        <label class="control-label col-sm-2">Delay</label>
                        <div class="col-sm-10">
                            <div class="col-sm-6 item-delay">
                                <label class="col-sm-2 control-label text-center">@lang("content.code")</label>
                                <div class="col-sm-6">
                                    {!! Form::select('delay_id[]', $delays, null, ['class'=>'form-control input-sm delay_id', 'disabled' => 'disabled']) !!}
                                </div>

                                <label class="col-sm-2 control-label text-center">Delay Time</label>
                                <div class="col-sm-2">
                                    {!! Form::text('delay_time[]', null, ['class'=>'form-control input-sm timepicker delay_time',  'style'=>'width:70px', 'disabled' => 'disabled' ]) !!}
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <label class="col-sm-4 control-label text-center">Total Delay:</label>
                                <div class="col-sm-2">
                                    {!! Form::text('delay_total', null, ['class'=>'form-control input-sm', 'id' => 'delay_total', 'style'=>'width:70px', 'disabled' => 'disabled' ]) !!}
                                </div>
                                <div class="btn-group col-sm-6">
                                    <button type="button" class="add-delay-btn btn btn-success btn-sm" disabled>@lang("content.add")</button>
                                    <button type="button" class="remove-delay-btn btn btn-danger btn-sm" disabled>@lang("content.remove")</button>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="form-group alert alert-warning" id="delay_message" style="display: none;">
                        Total Delay Time Exceeded! Please Take Note
                    </div>

                    <div class="form-group">
                        <label class="control-label col-xs-2">Flight Capacity</label>
                        <div class="col-xs-10">
                            <label class="col-xs-1 control-label">C</label>
                            <div class="col-xs-3">
                                {!! Form::text('capacity_c', null, ['class'=>'form-control input-sm', 'id'=>'capacity_c'] ) !!}
                            </div>

                            <label class="col-xs-1 control-label">Y</label>
                            <div class="col-xs-3">
                                {!! Form::text('capacity_y', null, ['class'=>'form-control input-sm', 'id'=>'capacity_y']) !!}
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-xs-2">PAX BKD</label>
                        <div class="col-xs-10">
                            <label class="col-xs-1 control-label">C</label>
                            <div class="col-xs-3">
                                {!! Form::text('pax_c_booked', null, ['class'=>'form-control input-sm', 'id'=>'pax_c_booked'] ) !!}
                            </div>

                            <label class="col-xs-1 control-label">Y</label>
                            <div class="col-xs-3">
                                {!! Form::text('pax_y_booked', null, ['class'=>'form-control input-sm', 'id'=>'pax_y_booked']) !!}
                            </div>

                            <label class="col-xs-1 control-label">INF</label>
                            <div class="col-xs-3">
                                {!! Form::text('pax_inf_booked', null, ['class'=>'form-control input-sm', 'id'=>'pax_inf_booked']) !!}
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-xs-2">PAX ACT</label>
                        <div class="col-xs-10">
                            <label class="col-xs-1 control-label">C</label>
                            <div class="col-xs-3">
                                {!! Form::text('pax_c_actual', null, ['class'=>'form-control input-sm', 'id'=>'pax_c_actual'] ) !!}
                            </div>

                            <label class="col-xs-1 control-label">Y</label>
                            <div class="col-xs-3">
                                {!! Form::text('pax_y_actual', null, ['class'=>'form-control input-sm', 'id'=>'pax_y_actual']) !!}
                            </div>

                            <label class="col-xs-1 control-label">INF</label>
                            <div class="col-xs-3">
                                {!! Form::text('pax_inf_actual', null, ['class'=>'form-control input-sm', 'id'=>'pax_inf_actual']) !!}
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-sm-2">Other Settings</label>
                        <div class="col-sm-10">
                            <div class="col-sm-2">
                                <label class="col-xs-6 control-label">@lang("content.baggage")</label>

                                <div class="col-xs-6">
                                    {!! Form::text('baggage', null, ['class'=>'form-control input-sm', 'id'=>'baggage', 'style' => 'width:60px'] ) !!}
                                </div>
                            </div>

                            <div class="col-sm-2">
                                <label class="col-xs-6 control-label">Cargo</label>

                                <div class="col-xs-6">
                                    {!! Form::text('cargo', null, ['class'=>'form-control input-sm', 'id'=>'cargo', 'style' => 'width:60px']) !!}
                                </div>
                            </div>

                            <div class="col-sm-2">
                                <label class="col-xs-6 control-label">Cargo 200</label>

                                <div class="col-xs-6">
                                    {!! Form::text('eic', null, ['class'=>'form-control input-sm', 'id'=>'eic', 'style' => 'width:60px']) !!}
                                </div>
                            </div>

                            <div class="col-sm-2">
                                <label class="col-xs-6 control-label">Mail</label>

                                <div class="col-xs-6">
                                    {!! Form::text('mail', null, ['class'=>'form-control input-sm', 'id'=>'mail', 'style' => 'width:60px']) !!}
                                </div>
                            </div>

                            <div class="col-sm-2">
                                <label class="col-xs-6 control-label">DE</label>

                                <div class="col-xs-6">
                                    {!! Form::text('deportees', null, ['class'=>'form-control input-sm', 'id'=>'deportees', 'style' => 'width:60px']) !!}
                                </div>
                            </div>

                            <div class="col-sm-2">
                                <label class="col-xs-6 control-label">Gate</label>

                                <div class="col-xs-6">
                                    {!! Form::text('gate_parking', null, ['class'=>'form-control input-sm', 'id'=>'gate_parking', 'style'=>'width: 60px;']) !!}
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-sm-2">Fuel</label>
                        <div class="col-sm-10">
                            <div class="col-sm-2">
                                <label class="col-xs-6 control-label">In Tanks</label>

                                <div class="col-xs-6">
                                    {!! Form::text('in_tanks', null, ['class'=>'form-control input-sm', 'id'=>'in_tanks', 'style' => 'width:80px'] ) !!}
                                </div>
                            </div>

                            <div class="col-sm-2">
                                <label class="col-xs-6 control-label">Uplifted</label>

                                <div class="col-xs-6">
                                    {!! Form::text('uplifted', null, ['class'=>'form-control input-sm', 'id'=>'uplifted', 'style' => 'width:80px']) !!}
                                </div>
                            </div>

                            <div class="col-sm-2">
                                <label class="col-xs-6 control-label">@lang("content.departure")</label>

                                <div class="col-xs-6">
                                    {!! Form::text('departure_fuel', null, ['class'=>'form-control input-sm', 'id'=>'departure_fuel', 'style' => 'width:80px', 'disabled'=>'disabled']) !!}
                                </div>
                            </div>

                            <div class="col-sm-2">
                                <label class="col-xs-6 control-label">Utilised</label>

                                <div class="col-xs-6">
                                    {!! Form::text('utilised', null, ['class'=>'form-control input-sm', 'id'=>'utilised', 'style' => 'width:80px', 'readonly'=>'readonly']) !!}
                                </div>
                            </div>

                            <div class="col-sm-2">
                                <label class="col-xs-6 control-label">@lang("content.arrival")</label>

                                <div class="col-xs-6">
                                    {!! Form::text('arrival_fuel', null, ['class'=>'form-control input-sm', 'id'=>'arrival_fuel', 'style' => 'width:80px']) !!}
                                </div>
                            </div>

                            <div class="col-sm-2">
                                <button type="button" id="update-fuel-btn" class="btn-sm btn btn-success">Update Fuel
                                </button>
                            </div>

                        </div>
                    </div>

                </div>

            </div>

            <div class="tab-pane fade" id="s2">
                <section id="widget-grid" class="">

                    <!-- row -->
                    <div class="row">

                        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                            <div class="jarviswidget jarviswidget-color-darken" id="wid-id-capt" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false" data-widget-fullscreenbutton="false">

                                <header>
                                    <span class="widget-icon"> <i class="fa fa-user"></i> </span>
                                    <h2><strong>Captains</strong></h2>

                                </header>

                                <!-- widget div-->
                                <div>

                                    <!-- widget edit box -->
                                    <div class="jarviswidget-editbox">
                                        <!-- This area used as dropdown edit box -->

                                    </div>
                                    <!-- end widget edit box -->

                                    <!-- widget content -->
                                    <div class="widget-body">

                                        <div class="subcategory_items captains_items">
                                            <div class="form-group">
                                                <label class="control-label col-sm-2">Operating</label>

                                                <div class="col-sm-10">
                                                    <div class="form-inline" id="flight_captains_crew">
                                                                <span class="item marginBottomRight" data-item-number="1">
                                                                    <label>No.1</label>
                                                                    <div class="form-group box-fix">
                                                                        {!! Form::select('captain[]', $captains, null, ['class'=>'form-control input-sm crew', 'data-crew-type' => 'fcm', 'id'=>'captain1'] ) !!}
                                                                    </div>
                                                                    @include('fleetwatch.form_report', ['reportName' => 'captain_report_time', 'reasonName' => 'captain_reason'])
                                                                </span>
                                                        <button type="button" data-field="captain" data-maxAllowed='3'
                                                                class="btn btn-success btn-sm add-person">Add
                                                        </button>
                                                        <button type="button" data-field="captain" data-minAllowed='1'
                                                                class="btn btn-danger btn-sm remove-person">Remove
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label col-sm-2">DHC</label>

                                                <div class="col-sm-10">
                                                    <div class="form-inline" id="flight_captains_dhc_crew">
                                                                <span class="item marginBottomRight" data-item-number="1">
                                                                    <label>No.1</label>
                                                                    <div class="form-group box-fix">
                                                                        {!! Form::select('captain_dhc[]', $captains, null, ['class'=>'form-control input-sm crew', 'data-crew-type' => 'fcm', 'id'=>'captain_dhc1'] ) !!}
                                                                    </div>
                                                                    @include('fleetwatch.form_report', ['reportName' => 'captain_dhc_report_time', 'reasonName' => 'captain_dhc_reason'])
                                                                </span>
                                                        <button type="button" data-field="captain_dhc" data-maxAllowed='5'
                                                                class="btn btn-success btn-sm add-person">Add
                                                        </button>
                                                        <button type="button" data-field="captain_dhc" data-minAllowed='1'
                                                                class="btn btn-danger btn-sm remove-person">Remove
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label col-sm-2">Airport Standby</label>

                                                <div class="col-sm-10">
                                                    <div class="form-inline" id="flight_captain_standby_crew">
                                                                <span class="item marginBottomRight" data-item-number="1">
                                                                    <label>No.1</label>
                                                                    <div class="form-group box-fix">
                                                                        {!! Form::select('captain_standby[]', $captains, null, ['class'=>'form-control input-sm crew', 'data-crew-type' => 'fcm',  'id'=>'captain_standby1'] ) !!}
                                                                    </div>
                                                                    @include('fleetwatch.form_report', ['reportName' => 'captain_standby_report_time', 'reasonName' => 'captain_standby_reason'])
                                                                </span>
                                                        <button type="button" data-field="captain_standby"
                                                                data-maxAllowed='2'
                                                                class="btn btn-success btn-sm add-person">Add
                                                        </button>
                                                        <button type="button" data-field="captain_standby"
                                                                data-minAllowed='1'
                                                                class="btn btn-danger btn-sm remove-person">Remove
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>

                                    </div>
                                    <!-- end widget content -->

                                </div>
                                <!-- end widget div -->

                            </div>

                        </article>

                        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                            <div class="jarviswidget jarviswidget-color-darken" id="wid-id-fo" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false" data-widget-fullscreenbutton="false">

                                <header>
                                    <span class="widget-icon"> <i class="fa fa-user"></i> </span>
                                    <h2><strong>First Officers</strong></h2>

                                </header>

                                <!-- widget div-->
                                <div>

                                    <!-- widget edit box -->
                                    <div class="jarviswidget-editbox">
                                        <!-- This area used as dropdown edit box -->

                                    </div>
                                    <!-- end widget edit box -->

                                    <!-- widget content -->
                                    <div class="widget-body">
                                        <div class="subcategory_items first_officers_items">
                                            <div class="form-group">
                                                <label class="control-label col-sm-2">Operating</label>
                                                <div class="col-sm-10">
                                                    <div class="form-inline" id="flight_first_officers_crew">
                                                                <span class="item marginBottomRight" data-item-number="1">
                                                                    <label>No.1</label>
                                                                    <div class="form-group box-fix">
                                                                        {!! Form::select('first_officer[]', $firstOfficers, null, ['class'=>'form-control input-sm crew', 'data-crew-type' => 'fcm',  'id'=>'first_officer1'] ) !!}
                                                                    </div>
                                                                    @include('fleetwatch.form_report', ['reportName' => 'first_officer_report_time', 'reasonName' => 'first_officer_reason'])
                                                                </span>
                                                        <button type="button" data-field="first_officer" data-maxAllowed = '3' class="btn btn-success btn-sm add-person">@lang("content.add")</button>
                                                        <button type="button" data-field="first_officer" data-minAllowed = '1' class="btn btn-danger btn-sm remove-person">@lang("content.remove")</button>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label col-sm-2">DHC</label>
                                                <div class="col-sm-10">
                                                    <div class="form-inline" id="flight_first_officers_dhc_crew">
                                                                <span class="item marginBottomRight" data-item-number="1">
                                                                    <label>No.1</label>
                                                                    <div class="form-group box-fix">
                                                                        {!! Form::select('first_officer_dhc[]', $firstOfficers, null, ['class'=>'form-control input-sm crew', 'data-crew-type' => 'fcm',  'id'=>'first_officer_dhc1'] ) !!}
                                                                    </div>
                                                                    @include('fleetwatch.form_report', ['reportName' => 'first_officer_dhc_report_time', 'reasonName' => 'first_officer_dhc_reason'])
                                                                </span>
                                                        <button type="button" data-field="first_officer_dhc" data-maxAllowed = '5' class="btn btn-success btn-sm add-person">@lang("content.add")</button>
                                                        <button type="button" data-field="first_officer_dhc" data-minAllowed = '1' class="btn btn-danger btn-sm remove-person">@lang("content.remove")</button>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <label class="control-label col-sm-2">Airport Standby</label>
                                                <div class="col-sm-10">
                                                    <div class="form-inline" id="flight_first_officers_standby_crew">
                                                                <span class="item marginBottomRight" data-item-number="1">
                                                                    <label>No.1</label>
                                                                    <div class="form-group box-fix">
                                                                        {!! Form::select('first_officer_standby[]', $firstOfficers, null, ['class'=>'form-control input-sm crew', 'data-crew-type' => 'fcm', 'id'=>'first_officer_standby1'] ) !!}
                                                                    </div>
                                                                    @include('fleetwatch.form_report', ['reportName' => 'first_officer_standby_report_time', 'reasonName' => 'first_officer_standby_reason'])
                                                                </span>
                                                        <button type="button" data-field="first_officer_standby" data-maxAllowed = '2' class="btn btn-success btn-sm add-person">@lang("content.add")</button>
                                                        <button type="button" data-field="first_officer_standby" data-minAllowed = '1' class="btn btn-danger btn-sm remove-person">@lang("content.remove")</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- end widget content -->

                                </div>
                                <!-- end widget div -->

                            </div>

                        </article>

                        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                            <div class="jarviswidget jarviswidget-color-darken" id="wid-id-cc" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false" data-widget-fullscreenbutton="false">

                                <header>
                                    <span class="widget-icon"> <i class="fa fa-user"></i> </span>
                                    <h2><strong>Cabin Crew</strong></h2>

                                </header>

                                <!-- widget div-->
                                <div>

                                    <!-- widget edit box -->
                                    <div class="jarviswidget-editbox">
                                        <!-- This area used as dropdown edit box -->

                                    </div>
                                    <!-- end widget edit box -->

                                    <!-- widget content -->
                                    <div class="widget-body">
                                        <div class="subcategory_items cabin_crew_items">
                                            <div class="form-group">
                                                <label class="control-label col-sm-2">Operating</label>
                                                <div class="col-sm-10">
                                                    <div class="form-inline" id="flight_cabin_crew_crew">
                                                                <span class="item marginBottomRight" data-item-number="1">
                                                                    <label>PSR</label>
                                                                    <div class="form-group box-fix">
                                                                        {!! Form::select('cabin_crew[]', $cabinCrew, null, ['class'=>'form-control input-sm crew', 'data-crew-type' => 'ccm', 'id'=>'cabin_crew1'] ) !!}
                                                                    </div>
                                                                    @include('fleetwatch.form_report', ['reportName' => 'cabin_crew_report_time', 'reasonName' => 'cabin_crew_reason'])
                                                                </span>
                                                                <span class="item marginBottomRight" data-item-number="2">
                                                                    <label>No.2</label>
                                                                    <div class="form-group box-fix">
                                                                        {!! Form::select('cabin_crew[]', $cabinCrew, null, ['class'=>'form-control input-sm crew', 'data-crew-type' => 'ccm', 'id'=>'cabin_crew2'] ) !!}
                                                                    </div>
                                                                    @include('fleetwatch.form_report', ['reportName' => 'cabin_crew_report_time', 'reasonName' => 'cabin_crew_reason'])
                                                                </span>
                                                                <span class="item marginBottomRight" data-item-number="3">
                                                                    <label>No.3</label>
                                                                    <div class="form-group box-fix">
                                                                        {!! Form::select('cabin_crew[]', $cabinCrew, null, ['class'=>'form-control input-sm crew', 'data-crew-type' => 'ccm', 'id'=>'cabin_crew3'] ) !!}
                                                                    </div>
                                                                    @include('fleetwatch.form_report', ['reportName' => 'cabin_crew_report_time', 'reasonName' => 'cabin_crew_reason'])
                                                                </span>
                                                                <span class="item marginBottomRight" data-item-number="4">
                                                                    <label>No.4</label>
                                                                    <div class="form-group box-fix">
                                                                        {!! Form::select('cabin_crew[]', $cabinCrew, null, ['class'=>'form-control input-sm crew', 'data-crew-type' => 'ccm', 'id'=>'cabin_crew4'] ) !!}
                                                                    </div>
                                                                    @include('fleetwatch.form_report', ['reportName' => 'cabin_crew_report_time', 'reasonName' => 'cabin_crew_reason'])
                                                                </span>
                                                        <button type="button" data-field="cabin_crew" data-maxAllowed = '8' class="btn btn-success btn-sm add-person">@lang("content.add")</button>
                                                        <button type="button" data-field="cabin_crew" data-minAllowed = '4' class="btn btn-danger btn-sm remove-person">@lang("content.remove")</button>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label col-sm-2">DHC</label>
                                                <div class="col-sm-10">
                                                    <div class="form-inline" id="flight_cabin_crew_dhc_crew">
                                                        <span class="item marginBottomRight" data-item-number="1">
                                                            <label>No.1</label>
                                                            <div class="form-group box-fix">
                                                                {!! Form::select('cabin_crew_dhc[]', $cabinCrew, null, ['class'=>'form-control input-sm crew', 'data-crew-type' => 'ccm', 'id'=>'cabin_crew_dhc1'] ) !!}
                                                            </div>
                                                            @include('fleetwatch.form_report', ['reportName' => 'cabin_crew_dhc_report_time', 'reasonName' => 'cabin_crew_dhc_reason'])
                                                        </span>
                                                        <button type="button" data-field="cabin_crew_dhc" data-maxAllowed = '10' class="btn btn-success btn-sm add-person">@lang("content.add")</button>
                                                        <button type="button" data-field="cabin_crew_dhc" data-minAllowed = '1' class="btn btn-danger btn-sm remove-person">@lang("content.remove")</button>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label col-sm-2">Airport Standby</label>
                                                <div class="col-sm-10">
                                                    <div class="form-inline" id="flight_cabin_crew_standby_crew">
                                                                <span class="item marginBottomRight" data-item-number="1">
                                                                    <label>No.1</label>
                                                                    <div class="form-group box-fix">
                                                                        {!! Form::select('cabin_crew_standby[]', $cabinCrew, null, ['class'=>'form-control input-sm crew', 'data-crew-type' => 'ccm', 'id'=>'cabin_crew_standby1'] ) !!}
                                                                    </div>
                                                                    @include('fleetwatch.form_report', ['reportName' => 'cabin_crew_standby_report_time', 'reasonName' => 'cabin_crew_standby_reason'])
                                                                </span>
                                                        <button type="button" data-field="cabin_crew_standby" data-maxAllowed = '2' class="btn btn-success btn-sm add-person">@lang("content.add")</button>
                                                        <button type="button" data-field="cabin_crew_standby" data-minAllowed = '1' class="btn btn-danger btn-sm remove-person">@lang("content.remove")</button>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                    <!-- end widget content -->

                                </div>
                                <!-- end widget div -->

                            </div>

                        </article>
                    </div>

                </section>

            </div>

            <div class="tab-pane fade" id="s3">

                {{--<section id="widget-grid" class="">--}}

                <!----------MVT Message Boxes -------------->
                {{--@if (in_array(11,$userModules[$module->id]))--}}

                <!-- row -->
                <div class="row">

                    <article class="col-xs-12 col-sm-6 col-md-6 col-lg-6">

                        <div class="jarviswidget jarviswidget-color-darken" id="wid-id-dept-mvt" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false" data-widget-fullscreenbutton="false">

                            <header>
                                <span class="widget-icon"> <i class="fa fa-file-text-o"></i> </span>
                                <h2><strong>Departure Message</strong></h2>

                            </header>

                            <!-- widget div-->
                            <div>

                                <!-- widget edit box -->
                                <div class="jarviswidget-editbox">
                                    <!-- This area used as dropdown edit box -->

                                </div>
                                <!-- end widget edit box -->

                                <!-- widget content -->
                                <div class="widget-body">

                                    <div class="col-sm-12">
                                        {!! Form::open(['method' => "POST", 'class' => 'form-horizontal', 'id' => 'departure-message-form']) !!}
                                        <div id="departure-mvt-notification"></div>
                                        <div class="form-group">
                                            <label class="col-sm-12">Required Fields: ATD, ABN, ETA</label>
                                        </div>
                                        <div class="form-group">
                                            {!! Form::textarea("departure_message_mvt", "", ["class" => "form-control", "id" => "departure_message_mvt", "rows" => 12]) !!}<br/>
                                        </div>
                                        <div class="form-group">
                                            {!! Form::hidden('departure_message_subject', "", ['id' => 'departure_message_subject']) !!}
                                            <button type="button" id="send-departure-message-btn" class="btn-sm btn btn-warning">Send Message</button>
                                        </div>
                                        {!! Form::close() !!}
                                    </div>

                                </div>
                            </div>
                        </div>
                    </article>

                    <article class="col-xs-12 col-sm-6 col-md-6 col-lg-6">

                        <div class="jarviswidget jarviswidget-color-darken" id="wid-id-arr-mvt" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false" data-widget-fullscreenbutton="false">

                            <header>
                                <span class="widget-icon"> <i class="fa fa-file-text-o"></i> </span>
                                <h2><strong>Arrival Message</strong></h2>

                            </header>

                            <!-- widget div-->
                            <div>

                                <!-- widget edit box -->
                                <div class="jarviswidget-editbox">
                                    <!-- This area used as dropdown edit box -->

                                </div>
                                <!-- end widget edit box -->

                                <!-- widget content -->
                                <div class="widget-body">

                                    <div class="col-sm-12">
                                        {!! Form::open(['method' => "POST", 'class' => 'form-horizontal', 'id' => 'arrival-message-form']) !!}
                                        <div id="arrival-mvt-notification"></div>
                                        <div class="form-group">
                                            <label class="col-sm-12">Required Fields: TDN, ATA</label>
                                        </div>
                                        <div class="form-group">
                                            {!! Form::textarea("arrival_message_mvt", "", ["class" => "form-control", "id" => "arrival_message_mvt", "rows" => 12]) !!}<br/>
                                        </div>
                                        <div class="form-group">
                                            {!! Form::hidden('arrival_message_subject', "", ['id' => 'arrival_message_subject']) !!}
                                            <button type="button" id="send-arrival-message-btn" class="btn-sm btn btn-warning">Send Message</button>
                                        </div>
                                        {!! Form::close() !!}
                                    </div>

                                </div>
                            </div>
                        </div>

                    </article>

                </div>

                {{--@endif--}}
                {{--</section>--}}

            </div>

        </div>
        <!-- end widget content -->

        <div class="col-md-12" style="margin: 20px 0 0 0;">
            <div class="col-sm-3">
                <input type="hidden" name="flight_id"            id="flight_id" value=""/>
                <input type="hidden" name="diverted_flight"      id="diverted_flight" value=""/>
                <input type="hidden" name="start_visible_period" id="start_visible_period" value=""/>
                <input type="hidden" name="end_visible_period"   id="end_visible_period" value=""/>
                <input type="submit" name="add_flight"           id="flight_add_btn" class="btn btn-primary" value="Add Flight" />
                <input type="submit" name="save_changes"         id="flight_update_btn" style="display: none" class="btn btn-success" value="Save Changes" />
                <input type="submit" name="restore_flight"       id="flight_restore_btn" style="display: none" class="btn btn-primary" value="Restore" />
                <input type="button"                             id="cancel_btn" style="display: none" class="btn btn-warning" value="Cancel" />
            </div>

            <div class="col-sm-9" id="cancel_flight_div" style="display: none">
                <label class="col-sm-2 control-label">Reason</label>
                <div class="col-sm-7">
                    {!! Form::text("cancel_reason", null, ["id" => "cancel_reason", "class" => "form-control input_200", "placeholder" => "Please specify cancellation reason..." ]) !!}
                </div>
                <div class="col-sm-3">
                    <input type="submit" name="cancel_flight" id="flight_cancel_btn" class="btn btn-danger"  value="Cancel The Flight" />
                </div>
            </div>
        </div>

        {!! Form::close() !!}
    </div>
    <!-- end widget div -->

    {{--@endif--}}

</div>
