<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov


 * Project: aviation.dev
 */
?>
<script type="text/template" id="general_tab_template" data-ignore = '1'>
    <div class="flight-info-header" style="margin:0 10px;">
        <h3 id="m_dep_airport" style="width:10%; float: left; text-align: center" data-toggle="tooltip" data-placement="top" data-original-title="<%= departureCity %>" class="text-warning"><%= departureCityCode %></h3>

        <div id="flight-progress" style="position: relative; top: 17px; width: 80%; float: left;">
            <div class="progress progress-striped" style="margin: 10px auto; height: 6px; padding: 0; width: 80%" id="progressbar_container">
                <div class="progress-bar progress-bar-<%= progressStatus %>" role="progressbar" aria-valuenow="40" aria-valuemin="0"
                    aria-valuemax="100" style="width: <%= flightBarPosition %>%;" id="progressbar_line">
                </div>
            </div>
            <div style="position: absolute; top: -4px; width: 50px !important;" id="progressbar_plane">
                <img width="<%= planeWidth %>%" src="<%= planeIcon %>" alt="flight icon"/>
            </div>
        </div>

        <h3 id="m_arr_airport"  style="width:10%; float: left; text-align: center;" data-toggle="tooltip" data-placement="top" data-original-title="<%= arrivalCity %>" class="text-warning"><%= arrivalCityCode %></h3>
        <div class="clearfix"></div>
    </div>
    <div class="row flight-info-body">
        <div class="clearfix"></div>

        <!-- Departure, Arrival Information -->
            <div class="col-sm-12" style="margin: 5px 15px; color: #ffffff; ">
                <strong style="line-height: 1.5em; width: 95%; background-color: #FF0500;"><%= delays %></strong>
            </div>

            <div class="col-sm-12">
                <!-- Departure dates table -->
                <div class="col-xs-3">
                    <h3>@lang("content.departure")</h3>
                    <h4 class="width_130"><span>STD: </span><span class="color-light-blue" id="id=m_std"><%= std %></span></h4>
                    <h4 class="width_130"><span>PTD: </span><span class="color-light-blue"><%= ptd %></span></h4>
                    <h4 class="width_130"><span>ETD: </span><span class="color-light-blue"><%= etd %></span></h4>
                    <h4 class="width_130"><span>ATD: </span><span class="color-light-blue"><%= atd %></span></h4>
                    <h4 class="width_130"><span>ABN: </span><span class="color-light-blue"><%= abn %></span></h4>
                </div>
                <div class="col-xs-3">
                    <h3>@lang("content.arrival")</h3>
                    <h4 class="width_130"><span>STA: </span><span class="color-light-blue"><%= sta %></span></h4>
                    <h4 class="width_130"><span>PTA: </span><span class="color-light-blue"><%= pta %></span></h4>
                    <h4 class="width_130"><span>ETA: </span><span class="color-light-blue"><%= eta %></span></h4>
                    <h4 class="width_130"><span>TDN: </span><span class="color-light-blue"><%= tdn %></span></h4>
                    <h4 class="width_130"><span>ATA: </span><span class="color-light-blue"><%= ata %></span></h4>
                </div>

                <!-- PAX Info -->
                @if (isset($userModules) && isset($module) && $userModules && in_array(2, $userModules[$module->id]))
                    <div class="col-xs-3">
                        <h3>PAX BKD</h3>
                        <h4><span>C: </span><span class="color-light-blue"><%= pax_booked_c %></span></h4>
                        <h4><span>Y: </span><span class="color-light-blue"><%= pax_booked_y %></span></h4>
                        <h4><span>INF: </span><span class="color-light-blue"><%= pax_booked_inf %></span></h4>
                    </div>

                    <div class="col-xs-3">
                        <h3>PAX ACT</h3>
                        <h4><span>C: </span><span class="color-light-blue"><%= pax_actually_c %></span></h4>
                        <h4><span>Y: </span><span class="color-light-blue"><%= pax_actually_y %></span></h4>
                        <h4><span>INF: </span><span class="color-light-blue"><%= pax_actually_inf %></span></h4>
                    </div>
                @endif
            </div>


        @if (isset($userModules) && isset($module) && $userModules && in_array(3,$userModules[$module->id]))
            <div class="clearfix"></div>
            <div class="col-sm-12">
                <div class="col-xs-3">
                    <h3>BAGGAGE</h3>
                    <h4><span>Allowance: </span><span class="color-light-blue"><%= baggage_allowance %></span></h4>
                    <h4><span>Actual: </span><span class="color-light-blue"><%= (baggage) ? baggage : '&mdash;' %></span></h4>
                    <h4><span>Excess: </span><span class="color-light-blue"><%= excess_baggage %></span></h4>
                    <h4><span>Excess Revenue: </span><span class="color-light-blue"><%= excess_baggage_revenue %></span></h4>
                </div>
                <div class="col-xs-3">
                    <h3>CARGO</h3>
                    <h4><span>Kgs: </span><span class="color-light-blue"><%= cargo %></span></h4>
                    <h4><span>Revenue: </span><span class="color-light-blue"><%= cargo_revenue %></span></h4>
                </div>
                <div class="col-xs-3">
                    <h3>MAIL</h3>
                    <h4><span>Kgs: </span><span class="color-light-blue" data-right><%= mail %></span></h4>
                    <h4><span>Revenue: </span><span class="color-light-blue"><%= mail_revenue %></span></h4>
               </div>
                <div class="col-xs-3">
                    <h3>@lang("content.total")</h3>
                    <h4><span>USD: </span><span class="color-light-blue"><%= total_revenue %></span></h4>
                </div>
             </div>
        @endif


        @if (isset($userModules) && isset($module) && $userModules && in_array(6,$userModules[$module->id]))
            <div class="clearfix"></div>
            <div class="col-sm-12">
                <div class="col-xs-12" id="fuel_information_panel">
                    <h3>FUEL</h3>
                    <h4>
                        <span class="col-xs-2">In tanks: <br/><span class="color-light-blue"><%= in_tanks %></span></span>
                        <span class="col-xs-2">Uplifted: <br/><span class="color-light-blue"><%= uplifted %></span></span>
                        <span class="col-xs-2">Departure: <br/><span class="color-light-blue"><%= dep_fuel %></span></span>
                        <span class="col-xs-2">Utilised: <br/><span class="color-light-blue"><%= utilised %></span></span>
                        <span class="col-xs-2">Arrival: <br/><span class="color-light-blue"><%= arr_fuel %></span></span>
                    </h4>
                </div>
            </div>
        @endif

        <!-- Crew Information -->
        @if (isset($userModules) && isset($module) && $userModules && in_array(5,$userModules[$module->id]))
        <div class="clearfix"></div>
            <div class="col-sm-12">
                <div class="col-xs-6">
                    <h3>CAPTAIN(s)</h3>
                    <h4><span>OPT: </span><span class="color-light-blue"><%= (captains) ? captains : "&mdash;" %></span></h4>
                    <h4><span>SBY: </span><span class="color-light-blue"><%= (captains_standby) ? captains_standby : "&mdash;" %></span></h4>
                    <h4><span>DHC: </span><span class="color-light-blue"><%= (captains_dhc) ? captains_dhc : "&mdash;" %></span></h4>
                </div>

                <div class="col-xs-6">
                    <h3>FIRST OFFICER(s)</h3>
                    <h4><span>OPT: </span><span class="color-light-blue"><%= (first_officers) ? first_officers : "&mdash;" %></span></h4>
                    <h4><span>SBY: </span><span class="color-light-blue"><%= (first_officers_standby) ? first_officers_standby : "&mdash;" %></span></h4>
                    <h4><span>DHC: </span><span class="color-light-blue"><%= (first_officers_dhc) ? first_officers_dhc : "&mdash;" %></span></h4>
                </div>
            </div>
        @endif

        @if (isset($userModules) && isset($module) && $userModules && in_array(4,$userModules[$module->id]))
        <div class="clearfix"></div>
            <div class="col-xs-12" style="padding: 0 30px">
                <h3>CABIN CREW</h3>
                <h4><span>OPT: </span><span class="color-light-blue"><%= (cabin_crew) ? cabin_crew : "&mdash;" %></span></h4>
                <h4><span>SUP: </span><span class="color-light-blue"><%= (cabin_crew_sup) ? cabin_crew_sup : "&mdash;" %></span></h4>
                <h4><span>SBY: </span><span class="color-light-blue"><%= (cabin_crew_standby) ? cabin_crew_standby : "&mdash;" %></span></h4>
                <h4><span>DHC: </span><span class="color-light-blue"><%= (cabin_crew_dhc) ? cabin_crew_dhc : "&mdash;" %></span></h4>
            </div>
        </div>
        @endif
</script>
