<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 */
?>

<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => 'Admin', 'moduleName' => trans("content.flight")." | ".trans("content.edit")])

            <div class="col-sm-12">
                    @if ($errors->all())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{!! $error !!}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                <div class="margin-bottom-10">
                    <h2 class="margin-bottom-5">{{ getFlightNumberFull($flight->flightNumber)." | ". baseDateFormat(getFlightDepartureInitialDate($flight, true)) }}</h2>
                    <h4>SVC TYPE: {{ getFlightNumberType($flight->flightNumber) }}</h4>
                </div>

                <div class="clearfix"></div>
                <div class="margin-top-10">
                    {!! Form::open(['method' => 'POST', "url" => url("flight/{$flight->id}"), 'class' => 'form-horizontal']) !!}

                        <div class="form-group">
                            <div class="form-group col-sm-5">
                                <label class="col-sm-5 control-label">@lang("content.ac_type")</label>
                                <div class="col-sm-7">
                                    {!! Form::select('aircraft_type_id', $aircraftTypes, $flight->aircraft_type_id, ['class'=>'form-control', 'id'=>'aircraft_type_id']) !!}
                                </div>
                            </div>

                            <div class="form-group col-sm-5">
                                <label class="col-sm-5 control-label">@lang("content.ac_reg")</label>
                                <div class="col-sm-7">
                                    {!! Form::select('aircraft_id', $aircraft, $flight->aircraft_id, ['class'=>'form-control', 'id'=>'aircraft_id']) !!}
                                </div>
                            </div>
                        </div>

                        <div class="form-group">

                            <div class="form-group col-sm-12 margin-bottom-0">
                                <label class="col-sm-2 control-label text-left">STD</label>
                                <label class="col-sm-1 control-label text-center"></label>
                                <label class="col-sm-2 control-label text-left">PTD</label>
                                <label class="col-sm-2 control-label text-left">ETD</label>
                                <label class="col-sm-2 control-label text-left">ATD</label>
                                <label class="col-sm-2 control-label text-left">ABN</label>
                            </div>

                            <div class="form-group col-sm-12">
                                <div class="col-sm-2">
                                    {!! Form::text('std', $flight->std ? date("Y-m-d H:i", strtotime($flight->std)) : null, ['class'=>'form-control input-sm dtpicker fleetwatch-timing', 'id'=>'std']) !!}
                                </div>
                                <div class="col-sm-1 text-center" style="height: 40px; display: inline-block">
                                    <span id="std_copy" class="fa fa-arrow-right" style="line-height: 40px;"></span>
                                </div>
                                <div class="col-sm-2">
                                    {!! Form::text('ptd', $flight->ptd ? date("Y-m-d H:i", strtotime($flight->ptd)) : null, ['class'=>'form-control input-sm dtpicker fleetwatch-timing', 'id'=>'ptd']) !!}
                                </div>
                                <div class="col-sm-2">
                                    {!! Form::text('etd', $flight->etd ? date("Y-m-d H:i", strtotime($flight->etd)) : null, ['class'=>'form-control input-sm dtpicker fleetwatch-timing', 'id'=>'etd']) !!}
                                </div>
                                <div class="col-sm-2">
                                    {!! Form::text('atd', $flight->ata ? date("Y-m-d H:i", strtotime($flight->ata)) : null, ['class'=>'form-control input-sm dtpicker fleetwatch-timing', 'id'=>'atd']) !!}
                                </div>
                                <div class="col-sm-2">
                                    {!! Form::text('abn', $flight->abn ? date("Y-m-d H:i", strtotime($flight->abn)) : null, ['class'=>'form-control input-sm dtpicker fleetwatch-timing', 'id'=>'abn']) !!}
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="form-group col-sm-12 margin-bottom-0">
                                <label class="col-sm-2 control-label text-left">STA</label>
                                <label class="col-sm-1 control-label text-left"></label>
                                <label class="col-sm-2 control-label text-left">PTA</label>
                                <label class="col-sm-2 control-label text-left">ETA</label>
                                <label class="col-sm-2 control-label text-left">TDN</label>
                                <label class="col-sm-2 control-label text-left">ATA</label>
                            </div>

                            <div class="form-group col-sm-12">
                                <div class="col-sm-2">
                                    {!! Form::text('sta', $flight->sta ? date("Y-m-d H:i", strtotime($flight->sta)) : null, ['class'=>'form-control input-sm dtpicker fleetwatch-timing', 'id'=>'sta']) !!}
                                </div>
                                <div class="col-sm-1 text-center" style="height: 40px; display: inline-block">
                                    <span id="sta_copy" class="fa fa-arrow-right" style="line-height: 40px;"></span>
                                </div>
                                <div class="col-sm-2">
                                    {!! Form::text('pta', $flight->pta ? date("Y-m-d H:i", strtotime($flight->pta)) : null, ['class'=>'form-control input-sm dtpicker fleetwatch-timing', 'id'=>'pta']) !!}
                                </div>
                                <div class="col-sm-2">
                                    {!! Form::text('eta', $flight->eta ? date("Y-m-d H:i", strtotime($flight->eta)) : null, ['class'=>'form-control input-sm dtpicker fleetwatch-timing', 'id'=>'eta']) !!}
                                </div>
                                <div class="col-sm-2">
                                    {!! Form::text('tdn', $flight->tdn ? date("Y-m-d H:i", strtotime($flight->tdn)) : null, ['class'=>'form-control input-sm dtpicker fleetwatch-timing', 'id'=>'tdn']) !!}
                                </div>
                                <div class="col-sm-2">
                                    {!! Form::text('ata', $flight->ata ? date("Y-m-d H:i", strtotime($flight->ata)) : null, ['class'=>'form-control input-sm dtpicker fleetwatch-timing', 'id'=>'ata']) !!}
                                </div>
                            </div>

                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">@lang("content.save_changes")</button>
                        </div>

                    {!! Form::close() !!}
                </div>

            </div>


        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#aircraft-table");
    };

    $("#std_copy").on("click", function () {
       $("#ptd").val($("#std").val());
    });

    $("#sta_copy").on("click", function () {
        $("#pta").val($("#sta").val());
    });

    $(document).find(".dtpicker").datetimepicker({
        format: "Y-m-d H:i",
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        step: 1
    });

    pagefunction();

</script>
