<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov


 * Project: intranet.dev
 */

use App\Models\User;

if (isset($flight) && $flight->flightCrew->count()) {
    foreach ($flight->flightCrew as $crewItem) {
        $position = $crewItem->position();
    }
}
$userModules = Session::get('userModules');

?>
@extends($ajaxCall)
@section("content")

@include('general.tab-header', ['departmentName' => 'Commercial', 'moduleName' => 'Flight Details'])

<div class="row" style="padding-bottom: 50px">
    <div class="col-sm-12">
        <div class="panel panel-primary">
            <div class="panel-heading">
                <h3 class="panel-title"><strong>{!! $CURRENT_IATA_CODE.' '.$flight->flightNumber->flight_number !!}</strong></h3>
            </div>
            <div class="panel-body" style="overflow: auto;">
                <div class="row">
                    <div class="col-sm-4">
                        <h3>
                            <strong>{!! $flight->flightNumber->departure_airport !!}</strong>
                            <span id="m_dep_city" class="font14">@lang("content.departure")</span>
                        </h3>
                    </div>
                    <div class="col-sm-4 text-center">
                        <h3>
                            <strong>{!! $CURRENT_IATA_CODE.' '.$flight->flightNumber->flight_number !!}</strong>
                        </h3>
                    </div>
                    <div class="col-sm-4 text-right">
                        <h3>
                            <span id="m_dep_city" class="font14">@lang("content.arrival")</span>
                            <strong>{!! $flight->flightNumber->arrival_airport !!}</strong>
                        </h3>
                    </div>

                    {{--Departure/Arrival information--}}
                    <div class="col-sm-12">
                        <div class="panel panel-primary" style="margin-bottom: 11px">
                            <div class="panel-heading" style="padding: 5px 15px">PASSENGER NUMBERS INFORMATION</div>
                            <div class="panel-body" style="padding: 0 10px">
                                <!-- departure dates table -->
                                <table class="table text-center table-condensed">
                                    <thead>
                                    <tr>
                                        <th>STD</th>
                                        <th>ETD</th>
                                        <th>ATD</th>
                                        <th>ABN</th>
                                        <th>STA</th>
                                        <th>ETA</th>
                                        <th>TDN</th>
                                        <th>ATA</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr class="text-left">
                                        <td style="width: 12.5%" id="m_std" class="text-success">{!! ($flight->std && $flight->std != EMPTY_DATETIME) ? date('d M Y, H:i', strtotime($flight->std)) : "&mdash;" !!}</td>
                                        <td style="width: 12.5%" id="m_etd" class="text-danger">{!! ($flight->etd && $flight->etd != EMPTY_DATETIME) ? date('d M Y, H:i', strtotime($flight->etd)) : "&mdash;" !!}</td>
                                        <td style="width: 12.5%" id="m_atd" class="text-danger">{!! ($flight->atd && $flight->atd != EMPTY_DATETIME) ? date('d M Y, H:i', strtotime($flight->atd)) : "&mdash;" !!}</td>
                                        <td style="width: 12.5%" id="m_abn" class="text-danger">{!! ($flight->abn && $flight->abn != EMPTY_DATETIME) ? date('d M Y, H:i', strtotime($flight->abn)) : "&mdash;"  !!}</td>
                                        <td style="width: 12.5%" id="m_sta" class="text-success">{!! ($flight->sta && $flight->sta != EMPTY_DATETIME) ? date('d M Y, H:i', strtotime($flight->sta)) : "&mdash;" !!}</td>
                                        <td style="width: 12.5%" id="m_eta" class="text-danger">{!! ($flight->eta && $flight->eta != EMPTY_DATETIME) ? date('d M Y, H:i', strtotime($flight->eta)) : "&mdash;" !!}</td>
                                        <td style="width: 12.5%" id="m_ata" class="text-danger">{!! ($flight->ata && $flight->ata != EMPTY_DATETIME) ? date('d M Y, H:i', strtotime($flight->ata)) : "&mdash;" !!}</td>
                                        <td style="width: 12.5%" id="m_tdn" class="text-danger">{!! ($flight->tdn && $flight->tdn != EMPTY_DATETIME) ? date('d M Y, H:i', strtotime($flight->tdn)) : "&mdash;" !!}</td>
                                    </tr>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>


                    {{--Delays information--}}
                    @if (count($flight->delays))
                    <div class="col-sm-12">
                        <div class="panel panel-danger" style="margin-bottom: 11px">
                            <div class="panel-heading" style="padding: 5px 15px">FLIGHT DELAYS INFORMATION</div>
                            <div class="panel-body" style="padding: 0 10px">
                                <!-- departure dates table -->
                                <table class="table text-center table-condensed">
                                    <thead>
                                        <th>@lang("content.duration")</th>
                                        <th>@lang("content.code")</th>
                                        <th>@lang("content.description")</th>
                                    </thead>
                                    <tbody>
                                        @foreach($flight->delays as $delay)
                                            @php $reason = $delay->delay @endphp
                                            <tr>
                                                <td data-left>{{ $delay->duration }}</td>
                                                <td data-left>{{ $reason->code }}</td>
                                                <td data-left>{{ $reason->description }}
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    @endif


                    {{--PAX ACTUAL--}}
                    @if (in_array(2, $userModules[2]))
                        <div class="col-sm-12">
                            <div class="panel panel-primary" style="margin-bottom: 11px">
                                <div class="panel-heading" style="padding: 5px 15px">PASSENGER NUMBERS INFORMATION</div>
                                <div class="panel-body" style="padding: 0 10px">
                                    <table class="table text-center table-condensed">
                                        <thead>
                                        <tr>
                                            <th style="width: 12.5%">PAX ACT</th>
                                            <th style="width: 12.5%">C</th>
                                            <th style="width: 12.5%">Y</th>
                                            <th style="width: 12.5%">INF</th>
                                            <th style="width: 12.5%">PAX BKD</th>
                                            <th style="width: 12.5%">C</th>
                                            <th style="width: 12.5%">Y</th>
                                            <th style="width: 12.5%">INF</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr class="text-left">
                                            <td></td>
                                            <td id="m_pax_actually_c">{!! $flight->pax_c_actual !!}</td>
                                            <td id="m_pax_actually_y">{!! $flight->pax_y_actual !!}</td>
                                            <td id="m_pax_actually_inf">{!! $flight->pax_inf_actual !!}</td>
                                            <td></td>
                                            <td id="m_pax_booked_c">{!! $flight->pax_c_booked !!}</td>
                                            <td id="m_pax_booked_y">{!! $flight->pax_y_booked !!}</td>
                                            <td id="m_pax_booked_inf">{!! $flight->pax_inf_booked !!}</td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    @endif

                        {{--Baggage Information--}}
                        @if (in_array(3, $userModules[2]))
                            <div class="col-sm-9">
                                <div class="panel panel-primary" style="margin-bottom: 11px">
                                    <div class="panel-heading" style="padding: 5px 15px">BAGGAGE, CARGO, MAIL INFORMATION</div>
                                    <div class="panel-body" style="padding: 0 10px">
                                        <table class="table text-center table-condensed">
                                            <thead>
                                            <tr class="text-left">
                                                <th style="width: 45%" colspan="4">BAGGAGE</th>
                                                <th style="width: 20%" colspan="2">CARGO</th>
                                                <th style="width: 20%" colspan="2">MAIL</th>
                                                <th class="text-center">@lang("content.total")</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr class="text-left">
                                                <td>Allowance</td>
                                                <td>Actual</td>
                                                <td>Excess Baggage</td>
                                                <td>Excess Baggage Revenue</td>
                                                <td>Kgs</td>
                                                <td>@lang("content.revenue")</td>
                                                <td>Kgs</td>
                                                <td>@lang("content.revenue")</td>
                                                <td rowspan="2" class="text-center vertical-center">${!! $flight->total_revenue !!}</td>
                                            </tr>
                                            <tr class="text-left">
                                                <td>{!! $flight->baggage_allowance !!}</td>
                                                <td>{!! $flight->baggage ? $flight->baggage : '&mdash;' !!}</td>
                                                <td>{!! $flight->excess_baggage !!}</td>
                                                <td>${!! $flight->excess_baggage_revenue !!}</td>
                                                <td>{!! $flight->cargo !!}</td>
                                                <td>${!! $flight->cargo_revenue !!}</td>
                                                <td>{!! $flight->mail !!}</td>
                                                <td>${!! $flight->mail_revenue !!}</td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        @endif

                        @if (in_array(6, $userModules[2]))
                            <div class="col-sm-3">
                                <div class="panel panel-primary">
                                    <div class="panel-heading" style="padding: 5px 15px;">FUEL INFORMATION</div>
                                    <div class="panel-body" id="fuel_information_panel" style="padding: 5px">
                                        <dl class="dl-horizontal" style="margin: 0">
                                            <dt>In tanks</dt>
                                            <dd>{!! $flight->in_tanks !!}</dd>
                                            <dt>Uplifted</dt>
                                            <dd>{!! $flight->uplifted !!}</dd>
                                            <dt>@lang("content.departure")</dt>
                                            <dd>{!! $flight->dep_fuel !!}</dd>
                                            <dt>Utilised</dt>
                                            <dd>{!! $flight->utilised !!}</dd>
                                            <dt>@lang("content.arrival")</dt>
                                            <dd>{!! $flight->arr_fuel !!}</dd>
                                        </dl>
                                    </div>
                                </div>
                            </div>
                        @endif

                    {{--Fuel Information--}}
                    @if (in_array('NOT APPLY', $userModules[2]))
                        <div class="col-sm-12">
                        <div class="panel panel-primary" style="margin-bottom: 11px">
                            <div class="panel-heading" style="padding: 5px 15px"></div>
                            <div class="panel-body" style="padding: 0 10px">
                                <table class="table text-center table-condensed">
                                    <thead>
                                    <tr>
                                        <th style="width: 25%">FUEL</th>
                                        <th style="width: 15%">In tanks</th>
                                        <th style="width: 15%">Uplifted</th>
                                        <th style="width: 15%">@lang("content.departure")</th>
                                        <th style="width: 15%">Utilised</th>
                                        <th style="width: 15%">@lang("content.arrival")</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr class="text-left">
                                        <td></td>
                                        <td id="m_pax_actually_c">{!! $flight->in_tanks !!}</td>
                                        <td id="m_pax_actually_y">{!! $flight->uplifted !!}</td>
                                        <td id="m_pax_actually_inf">{!! $flight->dep_fuel !!}</td>
                                        <td id="m_pax_booked_c">{!! $flight->utilised !!}</td>
                                        <td id="m_pax_booked_inf">{!! $flight->arr_fuel !!}</td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    @endif

                @if (in_array(4, $userModules[2]) || in_array(5, $userModules[2]))
                    <?php // Get Flight Crew in Order
                    $captains = $firstOfficers = $flightAttendants = [
                            'general' => [],
                            'standby' => [],
                            'dhc'     => []
                    ];
                    foreach($flight->flightCrewItems as $each){
                        $user = User::find($each->user_id);
                        if ($user){
                            $fullName =  $user->UserFullName;
                            if (in_array($each->position_id, [
                                USER_CAPTAIN_POSITION_ID,
                                USER_CHIEF_PILOT_POSITION_ID,
                                USER_PILOT_INSTRUCTOR_POSITION_ID,
                            ])){
                                if ($each->is_standby)
                                    $captains['standby'][] = '<a href="'.\route("homepage")."#". url("/")."/crew/profile?id=".$each->user_id.'" target="_blank">'.$fullName.'</a>';
                                elseif ($each->is_dhc)
                                    $captains['dhc'][] =  '<a href="'.\route("homepage")."#". url("/")."/crew/profile?id=".$each->user_id.'" target="_blank">'.$fullName.'</a>';
                                else
                                    $captains['general'][] =  '<a href="'.\route("homepage")."#". url("/")."/crew/profile?id=".$each->user_id.'" target="_blank">'.$fullName.'</a>';
                            }
                            elseif (in_array($each->position_id, [
                                USER_FIRST_OFFICER_POSITION_ID,
                                USER_COPILOT_JUNIOR_POSITION_ID,
                            ])){
                                if ($each->is_standby)
                                    $firstOfficers['standby'][] =  '<a href="'.\route("homepage")."#". url("/")."/crew/profile?id=".$each->user_id.'" target="_blank">'.$fullName.'</a>';
                                elseif ($each->is_dhc)
                                    $firstOfficers['dhc'][] =  '<a href="'.\route("homepage")."#". url("/")."/crew/profile?id=".$each->user_id.'" target="_blank">'.$fullName.'</a>';
                                else
                                    $firstOfficers['general'][] = '<a href="'.\route("homepage")."#". url("/")."/crew/profile?id=".$each->user_id.'" target="_blank">'.$fullName.'</a>';
                            }
                            elseif (in_array($each->position_id, [
                                USER_PURSER_ID,
                                USER_INSTRUCTOR_FLIGHT_ATTENDANT_ID,
                                USER_SENIOR_INSTRUCTOR_FLIGHT_ATTENDANT_ID,
                                USER_FLIGHT_ATTENDANT_ID,
                                USER_FLIGHT_ATTENDANT_N2_ID,
                                USER_FLIGHT_ATTENDANT_JUNIOR_ID,
                            ])){
                                if ($each->is_standby)
                                    $flightAttendants['standby'][] =  '<a href="'.\route("homepage")."#". url("/")."/crew/profile?id=".$each->user_id.'" target="_blank">'.$fullName.'</a>';
                                elseif ($each->is_dhc)
                                    $flightAttendants['dhc'][] =  '<a href="'.\route("homepage")."#". url("/")."/crew/profile?id=".$each->user_id.'" target="_blank">'.$fullName.'</a>';
                                else
                                    $flightAttendants['general'][] = '<a href="'.\route("homepage")."#". url("/")."/crew/profile?id=".$each->user_id.'" target="_blank">'.$fullName.'</a>';
                            }
                        }
                    }
                    ?>
                    <div class="col-sm-12">
                        <div class="panel panel-primary" style="margin-bottom: 11px">
                            <div class="panel-heading" style="padding: 5px 15px">CREW INFORMATION</div>
                                <div class="panel-body" style="padding: 0 10px">
                                    <table class="table table-condensed">
                                    @if (in_array(4, $userModules[2]))
                                        <tr>
                                            <td style="width: 180px"><strong>CAPTAIN(s):</strong></td>
                                            <td id="m_captains" style="width: 40%">
                                                {!! count($captains['general']) ? implode(', ', $captains['general']) : '' !!}
                                            </td>
                                            <td style="width: 180px"><strong>STANDBY:</strong></td>
                                            <td id="m_captains" style="width: 20%">
                                                {!! count($captains['standby']) ? implode(', ', $captains['standby']) : '' !!}
                                            </td>
                                            <td style="width: 180px"><strong>DHC:</strong></td>
                                            <td id="m_captains" style="width: 20%">
                                                {!! count($captains['dhc']) ? implode(', ', $captains['dhc']) : '' !!}
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><strong>FIRST OFFICER(s):</strong></td>
                                            <td id="m_first_officers">
                                                {!! count($firstOfficers['general']) ? implode(', ', $firstOfficers['general']) : '' !!}
                                            </td>
                                            <td><strong>STANDBY:</strong></td>
                                            <td id="m_first_officers">
                                                {!! count($firstOfficers['standby']) ? implode(', ', $firstOfficers['standby']) : '' !!}
                                            </td>
                                            <td><strong>DHC:</strong></td>
                                            <td id="m_first_officers">
                                                {!! count($firstOfficers['dhc']) ? implode(', ', $firstOfficers['dhc']) : '' !!}
                                            </td>
                                        </tr>
                                    @endif

                                    @if (in_array(5, $userModules[2]))
                                        <tr>
                                            <td><strong>CABIN CREW:</strong></td>
                                            <td id="m_cabin_crew">
                                                {!! count($flightAttendants['general']) ? implode(', ', $flightAttendants['general']) : '' !!}
                                            </td>
                                            <td><strong>STANDBY:</strong></td>
                                            <td id="m_cabin_crew">
                                                {!! count($flightAttendants['standby']) ? implode(', ', $flightAttendants['standby']) : '' !!}
                                            </td>
                                            <td><strong>DHC:</strong></td>
                                            <td id="m_cabin_crew">
                                                {!! count($flightAttendants['dhc']) ? implode(', ', $flightAttendants['dhc']) : '' !!}
                                            </td>
                                        </tr>
                                    @endif
                                </table>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
</div>
@stop
