<?php

//initialize the page
require_once(public_path("smart/inc/init.php"));

//require UI configuration (nav, ribbon, etc.)
require_once(public_path("smart/inc/config.ui.php"));

include_once(public_path("smart/inc/user_variables.php"));


/*---------------- PHP Custom Scripts ---------

YOU CAN SET CONFIGURATION VARIABLES HERE BEFORE IT GOES TO NAV, RIBBON, ETC.
E.G. $page_title = "Custom Title" */

$page_title = trans("modules.flight_watch");

/* ---------------- END PHP Custom Scripts ------------- */

//include header
//you can add your custom css in $page_css array.
//Note: all css files are inside css/ folder
$page_css[] = "your_style.css";

$no_main_header = true;

$page_body_prop = array("id"=>"extr-page", "class"=>"animated fadeInDown");

include(public_path("smart/inc/header.php"));

?>

<style>
    span.item {
        display: inline-block;
        margin-top: 8px;
    }
    div.fleetwatch_form .form-control{
        font-size: 14px !important;
    }
    div.fleetwatch_form select.crew{
        max-width: 200px !important;
    }
    div.fleetwatch_form label{
        font-size: 14px !important;
    }
    body{
        background-color: #FFFFff;
    }
    .form-inline input[type="text"],
    .form-inline input[type="email"],
    .form-inline select {
        margin-right: 10px;
        max-width: 160px;
    }
    #mytimeline .ui-widget-content {
        background: #FFF;
    }
    .message-item > pre {
        max-width: 890px;
    }

    div.timeline-groups-text{
        font-weight: bold;
    }

    a.left_sidebar:hover{
        cursor: pointer !important;
    }
    th.checkbox-column:hover{
        cursor: pointer !important;
    }

    #header_container{
        display: flex;
        flex-flow: row;
        width: 100%;
        padding: 20px 30px;
    }

    #airports_airlines_group {
        display: flex;
        flex-flow: column;
        flex-grow: 1;
        justify-content: center;
    }

    #airports_container{
        display: flex;
        justify-content: center;
    }

    #airports_container > a{
        margin-right: 5px;
    }

    #airlines_container{
        display: flex;
        justify-content: center;
        flex-wrap: wrap;
    }

    #airlines_container > a, #airlines_container > img{
        margin: 2px;
    }

    /*Time container*/
    #form_and_time_container{
        margin: 10px;
        display: flex;
        flex-flow: row;
        width: 100%;
    }

    #time_container{
        flex-grow: 1;
        flex-flow: column;
        justify-content: center;
    }

    #logo-group{
        margin-right: 30px;
    }

    .flight-form {
        width: 100%;
        flex-direction: row;
        align-items: center;
        display: flex;
        padding: 10px;
        text-align: center;
        flex-wrap: wrap;
    }

    .flight-form input {
        display: block;
        padding: 6px 12px;
        font-size: 13px;
        color: #555;
        background-color: #fff;
        background-image: none;
        min-width: 0;
        border: 1px solid #ccc;
    }

    .info-box input.width-50{
        padding: 5px;
        width: 50px !important;
    }
    .p-0{
        padding: 0 !important;
    }
    .fg-1{
        flex-grow: 1;
    }
    .fg-2{
        flex-grow: 2;
    }
    .fg-3{
        flex-grow: 3;
    }
    .fg-4{
        flex-grow: 4;
    }
    .fg-5{
        flex-grow: 5;
    }
    .box-grow{
        display: flex;
    }
    .box-grow > *{
        flex-grow: 1;
    }
    .box-grow > *:not(:last-child) {
        margin-right: 10px;
    }

    .box-column{
        display: flex;
        flex-direction: column;
        flex-wrap: wrap;
    }
    .box-column.margin-bottom-5 > *{
        margin-bottom: 5px;
    }

    .box,
    .box-column
    {
        display: flex;
        flex-wrap: wrap;
    }

    .box-nowrap{
        flex-wrap: nowrap !important;
        display: flex;
    }

    .box:not(.table-bordered) > *,
    .box-column:not(.table-bordered) > *,
    .box-nowrap:not(.table-bordered) > *
    {
        padding-top: 0 !important;
        padding-bottom: 0 !important;
        margin: 5px;
    }

    .box input[type=text]:not(.datetimepicker, .width-50), .box select,
    .box-column input[type=text]:not(.datetimepicker, .width-50), .box-column select,
    .box-grow input[type=text]:not(.datetimepicker, .width-50), .box-grow select,
    label.width-80
    {
        flex-basis: 80px !important;
        min-width: 80px !important;
    }

    label.width-50
    {
        flex-basis: 50px !important;
        min-width: 50px !important;
    }

    .box input.datetimepicker,
    .box-column input.datetimepicker,
    .box-grow input.datetimepicker
    {
        width: 150px !important;
    }

    .align-items-center{
        align-items: center;
    }
    .justify-content-center{
        justify-content: center;
    }

    .min-70{
        min-width: 70px !important;
    }

    .box-bordered{
        border: 2px solid #868686;
        border-radius: 15px;
    }
    .color-dark-blue > *,
    .color-dark-blue
    {
        color: #11237c
    }
    .color-dark-red > *,
    .color-dark-red
    {
        color: #ac0909
    }
    .my-0{
        margin-top: 0 !important;
        margin-bottom: 0 !important;
    }
    .mx-1{
        margin-left: 10px;
        margin-right: 10px;
    }
    .box.item-delay{
        width: 270px;
        margin: 5px 0;
    }
</style>


<div id="header_container">
    <div id="logo-group" style="{{ $div_external_page }}">
        <img style="{{ $logo_external_page }}" src="{{ $logo_fw }}"  alt="Logo">
        <h2 style="{{ $logo_text_external_page }}">{{ $logo_text }}</h2>
        <!-- END AJAX-DROPDOWN -->
    </div>

    @if (env(CARRIER) == HANDLING)
        <div id="airports_airlines_group">
            @if(count($handlingAirports) > 1)
                <div id="airports_container">
                    <a id="all_stations" style="cursor:pointer;  margin-bottom: 5px;" class="btn btn-success font-md quick-airports {{ !count($staffStations) ? "btn-warning" : "" }}" data-id="">ALL</a>
                    @foreach($handlingAirports as $id => $each)
                        @if (in_array($id, $staffStations))
                            <a style="cursor:pointer; margin-bottom: 5px;" class="btn btn-primary font-md quick-airports {{ in_array($id, $staffStations) ? "btn-warning" : "" }}" data-id="{{ $id }}">{{ $each }}</a>
                        @endif
                    @endforeach
                </div>
            @endif

            @if (!$isMobile && count($handlingAirlines) > 1)
                <div id="airlines_container">
                    <a id="all_airlines" style="cursor:pointer;" class="btn btn-success font-sm quick-airlines {{ !count($staffAirlines) ? "selected" : "" }}" data-id="">ALL</a>
                    @foreach($handlingAirlines as $id => $each)
                        @if (in_array($id, $staffAirlines))
                            <img style="cursor:pointer;"  data-id="{{ $id }}" class="header-airline-logo quick-airlines {{ in_array($id, $staffAirlines) ? "selected" : "" }}" src="{{  asset("storage/airlines/img/{$each}")}}" />
                        @endif
                    @endforeach
                </div>
            @endif
        </div>
    @endif
</div>

<div class="clearfix"></div>

<div id="main" role="main" style="padding: 0 10px !important;">

    <!-- MAIN CONTENT -->
    <div id="content" class="">

        @include('general.tab-header')

        <div id="form_and_time_container">

            <div id="form_container">
                {!! Form::open(["method"=>"get", "id"=>"go_to_date_form", 'class' => 'form-inline']) !!}
                <button id="btn_prev_date" style="font-size:18px; padding: 0 10px; margin-right: 5px;" class="floatOnly btn btn-primary">{{ LEFT_ARROW }}</button>
                {!! Form::input("text", "go_to_date", \request()->get("go_to_date") ? \request()->get("go_to_date") : date("Y-m-d"), ["class"=>"form-control height27 floatOnly date fleetwatch-input-date margin-right-5", "placeholder"=>"Date", "id"=>"go_to_date"]) !!}
                <button id="btn_next_date" style="font-size:18px; padding: 0 10px; margin-right: 5px;" class="floatOnly btn btn-primary">{{ RIGHT_ARROW }}</button>
                {{--                    {!! Form::select('go_to_airline_id[]', $airlines, \request()->get('go_to_airline_id'), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'go_to_airline_id']) !!}--}}
                {{--                    {!! Form::select('go_to_airport_id[]', $locationsAirports, \request()->get('go_to_airport_id'), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'go_to_airport_id']) !!}--}}
                {!! Form::submit("Submit", [ "id" => "btn_go_to_date", "class" => "btn btn-primary"]) !!}
                <span style="font-size: 11px; color: #5f5f5f; display: none; margin-left: 20px;" id="loading-fleetwatch-data">
                        <img width="24" src="{{ asset("/assets/img/2.GIF") }}" alt="Loading..."/>
                    </span>
                {!! Form::close() !!}

            </div>

            <div id="time_container" class="text-center">
                <span class="timeNow">@lang("content.today"): {!! gmdate('D, d M Y') !!}</span>
                <h4 class="timeNow" style="color: #ff0400">@lang("content.time_now"):<span class="timeNow" id="timeNow" style="color: #ff0400"></span></h4>
            </div>
        </div>

        <div id="fleetwatch_message_block" style="clear: both"></div>

        <!-- Fleet watch timeline -->
        <div id="mytimeline" style="min-height: 50px;  min-width: 950px; width: 100%; margin-bottom: 20px;"></div>

        <div class="col-sm-12">
            <span class="color_item"><span class="flight_color available"></span> - @lang("content.scheduled")</span>
            <span class="color_item"><span class="flight_color on_time"></span> - @lang("content.on_time")</span>
            <span class="color_item"><span class="flight_color delayed"></span> - @lang("content.delayed")</span>
            <span class="color_item"><span class="flight_color et_delayed"></span> - ETD/ETA</span>
            <span class="color_item"><span class="flight_color diversion"></span> - @lang("content.diversion")</span>
            <span class="color_item"><span class="flight_color created_by_email"></span> - @lang("content.auto_created")</span>
            <span class="color_item"><span class="flight_color edited_by_email"></span> - @lang("content.auto_edited")</span>
            <span class="color_item"><span class="flight_color edited"></span> - @lang("content.schedule_update")</span>
            <span class="color_item"><span class="flight_color manually_created"></span> - @lang("content.manually_created")</span>
            {{--            <span class="color_item"><span class="flight_color maintenance"></span> - @lang("content.maintenance")</span>--}}

            <span style="display: none; margin-left: 20px;" id="loading-fleetwatch-form">
                <img width="24" src="{{ asset("/assets/img/2.GIF") }}" alt="Loading..."/> Loading, please wait...
            </span>
        </div>

        <div class="clearfix"></div>

        <hr/>

        <!--------Crew Hours Info Modal------------>
        {{--        @include('template/crew-change-process')--}}

        <!-------- Include Flight Form ---------------->
        @include("flight-watch.templates.form")

        <!-- Include Flight modal information window -->
        @include("flight-watch.templates.modal_info")

        <!-- Include Flight maintenance modal window -->
        @include("flight/modal_maintenance_info")

    </div>

</div>
<!-- END MAIN PANEL -->
<!-- ==========================CONTENT ENDS HERE ========================== -->

<script type="text/javascript">
    var baseUrl = "{{ url('/') }}";
    var baseDashboardUrl = "{{ url('home/dashboard') }}";
    var baseHomeUrl = "{{ route("homepage") }}";
    var AIRLINE = "{{ env("AIRLINE") }}";
    var CARRIER = "{{ env("CARRIER") }}";
    var CURRENT_IATA_CODE = "{{ env("IATA_CODE") }}";

    var ETD = 'ETD';
    var ATD = 'ATD';
    var ABN = 'ABN';
    var ETA = 'ETA';
    var ATA = 'ATA';
    var TDN = 'TDN';

    var LDS = 'LDS';
    var MVT = 'MVT';
    var CPM = 'CPM';
    var LDM = 'LDM';
    var LPM = 'LPM';
    var PSM = 'PSM';
    var PTM = 'PTM';
    var UCM = 'UCM';
    var TPM = 'TPM';
    var PL = 'PL';
    var PNL = 'PNL';
    var PRL = 'PRL';
    var ADL = 'ADL';
    var NOT = 'NOT';
    var SLS = 'SLS';
    var HBG = 'HBG';
    var LIR = 'LIR';
    var CAL = 'CAL';
    var CREW_LIST = 'CREW LIST';
    var NOTOC = 'NOTOC';
    var OTHS = 'OTHS';
    var ONLOAD = 'ONLOAD';
    var LOADSHEET = "L O A D S H E E T";
    var LOADSHEET_FINAL = "LOADSHEET FINAL";

</script>

<?php include(public_path("smart/inc/scripts.php")); ?>

<link rel="stylesheet" href="{{ asset("/assets/timeline/timeline.css?5") }}" />
<link rel="stylesheet" href="{{ asset("/assets/timeline/timeline-theme.css?5") }}" />
<link rel="stylesheet" href="{{ asset("/packages/ionicons/css/ionicons.min.css") }}" />

<script src="<?php echo asset("/assets/js/vendor/underscore-min.js"); ?>"></script>

<script src="{{ asset("/assets/js/vendor/bootstrap-tooltip.js") }}"></script>
<script type="text/javascript">

    pageSetUp();

    var $airlineModule = {{ $airlineModule ? 1 : 0 }},
        $groupsWidth = "{{ $airlineModule ? "130px" : "100px" }}",
        $timelinePeriod = {{ $airlineName == COASTAL ? 12 : 24 }},
        $userAnyAdmin = {{ userAnyAdmin() }},
        airportId = "{{ \request()->get("airport_id") }}",
        airlineId = "{{ \request()->get("airline_id") }}",
        editable = 1; //isset($userModules) && isset($module) && isset($userModules[$module->id]) && in_array(10,$userModules[$module->id]) ? 1 : 0
    json = {!! $json !!},
        goToDate = '{{ (\request()->get("go_to_date")) ? date('D M d Y H:i:s O', strtotime(\request()->get("go_to_date"))) : false }}',
        startVisibleDate = '{!! (\request()->get("start_time")) ? \request()->get("start_time") : false !!}',
        endVisibleDate = '{!! (\request()->get("end_time")) ? \request()->get("end_time") : false !!}',

        aircraftByAirline = {!! json_encode($aircraftByAirline) !!},
        acTypesByAirline = {!! json_encode($acTypesByAirline) !!},
        flightNumbersObj = {!! json_encode($flightNumbersObj) !!},
        aircraftByType = {!! json_encode($aircraftByType) !!}

    // Tooltip
    $("[data-toggle='tooltip']").popover({ trigger: "hover" });

</script>

{{--<script src="{{ asset("/assets/js/vendor/bootbox.min.js") }}"></script>--}}
<script type="text/javascript" src="https://www.google.com/jsapi"></script>
{{--<script src="{{ asset("/assets/js/vendor/google-jsapi.js") }}"></script>--}}
<script src="{{ asset("/assets/timeline/timeline.js") }}"></script>
<script src="{{ asset("/assets/js/views/operation/timeline.js?189") }}"></script>
<script src="{{ asset("/assets/js/vendor/jquery.bpopup.min.js") }}"></script>
<script src="{{ asset("/assets/js/vendor/jquery.datetimepicker.js") }}"></script>
<script src="{{ asset("/assets/js/vendor/select-sync-mine.js") }}"></script>
<script src="{{ asset("/assets/js/views/operation/form.js?187") }}"></script>

<script type="text/javascript">

    runAllForms();

    ApplySpecificFormSubmit($(document).find("#formParseMessages"));
    //    ApplySpecificFormSubmit($(document).find("#formMVTDeparture"));
    //    ApplyFormInputSubmit("#formMVTArrival");

    ApplyTableFilter("#tableFltDepartures");
    ApplyTableFilter("#tableFltArrivals");
    ApplyTableFilter("#tableFltAll");

    ApplyTableFilter("#flightMessages");
    {{--ApplyTableFilter("#fltTod");--}}
    {{--ApplyTableFilter("#fltTom");--}}

</script>
